/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.OtherTaskTypeEnum;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.swing.DeviceType;
import com.huawei.ism.tool.infograb.swing.IDeviceManageUI;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskPanel;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDeviceAction
implements ActionListener,
INodeSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddDeviceAction.class);

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.info("Click add device btn.");
        if (GrabContext.getInstance().getDevCount().get() >= 1000) {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.task.device_sum_limit_info"));
            return;
        }
        this.addDevice();
    }

    private void addDevice() {
        ArrayList<DeviceType> supportDevTypes = new ArrayList<DeviceType>();
        supportDevTypes.add(DeviceType.HOST);
        supportDevTypes.add(DeviceType.DATABASE);
        supportDevTypes.add(DeviceType.SWITCH);
        supportDevTypes.add(DeviceType.STORAGE);
        IDeviceManageUI connUi = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        DeviceManageSetting setting = new DeviceManageSetting(false, true, true);
        List<String> supportDevTypeList = this.getSupportedTypes(supportDevTypes);
        this.initDeviceAddDialogData(setting);
        if (this.isTimeTask()) {
            this.initDeviceAddDialogDataTimeTask(setting);
        } else {
            RealTimeTaskPanel currentTaskPanel = (RealTimeTaskPanel)GrabContext.getInstance().getCurrentTask();
            RealTimeTask currentTask = (RealTimeTask)currentTaskPanel.getTask();
            List<String> currentCategroy = currentTask.getTaskCategory();
            ArrayList<String> otherTaskType = new ArrayList<String>();
            otherTaskType.add(ResourceUtil.getString((String)"infograb.item.category.hypermetro"));
            otherTaskType.add(ResourceUtil.getString((String)"infograb.item.category.network.discovery"));
            if (currentCategroy.contains(ResourceUtil.getString((String)"infograb.item.category.data_migration"))) {
                this.initDataMigrationAddDialogData(setting);
            } else if (currentCategroy.size() == 1 && currentCategroy.contains(ResourceUtil.getString((String)"infograb.item.category.hypermetro"))) {
                LOGGER.info("init other task type setting, task type is hypermetro");
                this.initDeviceAddDialogDataForOther(setting, OtherTaskTypeEnum.HYPERMETRO);
            } else if (currentCategroy.size() == 1 && currentCategroy.contains(ResourceUtil.getString((String)"infograb.item.category.network.discovery"))) {
                LOGGER.info("init other task type setting, task type is network discovery");
                this.initDeviceAddDialogDataForOther(setting, OtherTaskTypeEnum.NETWORKDISCOVERY);
            } else if (currentCategroy.size() == 1 && currentCategroy.contains(ResourceUtil.getString((String)"infograb.item.category.DataTurbo.collect"))) {
                LOGGER.info("init other task type setting, task type is DataTurbo collect");
                this.initDeviceAddDialogDataForOther(setting, OtherTaskTypeEnum.DATA_TURBO_COLLECT);
            } else {
                this.initDeviceAddDialogData(setting);
            }
        }
        boolean flag = connUi.showAddDeviceDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), supportDevTypeList, null, DeviceDialogType.All, setting);
        if (!flag) {
            LOGGER.error("Show add device dialog err.");
        }
    }

    private void initDeviceAddDialogData(DeviceManageSetting setting) {
        LinkedList<ItDeviceType> itDeviceList = new LinkedList<ItDeviceType>();
        HashMap deviceTypel2 = new HashMap();
        itDeviceList.add(ItDeviceType.Host);
        itDeviceList.add(ItDeviceType.Database);
        itDeviceList.add(ItDeviceType.Switch);
        LinkedList<String> hostdeviceTypeL2 = new LinkedList<String>();
        hostdeviceTypeL2.add("Linux");
        hostdeviceTypeL2.add("AIX");
        hostdeviceTypeL2.add("HP-UX");
        hostdeviceTypeL2.add("Solaris");
        hostdeviceTypeL2.add("VMware");
        hostdeviceTypeL2.add("Windows");
        hostdeviceTypeL2.add("FusionSphere");
        hostdeviceTypeL2.add("XenServer");
        LinkedList<String> dataBasedeviceTypeL2 = new LinkedList<String>();
        dataBasedeviceTypeL2.add("Oracle");
        dataBasedeviceTypeL2.add("MySQL");
        dataBasedeviceTypeL2.add("SQLServer");
        dataBasedeviceTypeL2.add("DB2");
        LinkedList<String> switchdeviceTypeL2 = new LinkedList<String>();
        switchdeviceTypeL2.add("Brocade");
        switchdeviceTypeL2.add("Cisco");
        deviceTypel2.put(ItDeviceType.Host, hostdeviceTypeL2);
        deviceTypel2.put(ItDeviceType.Database, dataBasedeviceTypeL2);
        deviceTypel2.put(ItDeviceType.Switch, switchdeviceTypeL2);
        setting.setItDeviceList(itDeviceList);
        setting.setDeviceTypel2(deviceTypel2);
    }

    private void initDeviceAddDialogDataForOther(DeviceManageSetting setting, OtherTaskTypeEnum taskTypeEnum) {
        LinkedList<ItDeviceType> itDeviceList = new LinkedList<ItDeviceType>();
        HashMap deviceTypel2 = new HashMap();
        itDeviceList.add(ItDeviceType.Host);
        LinkedList<String> hostdeviceTypeL2 = new LinkedList<String>();
        if (taskTypeEnum.equals((Object)OtherTaskTypeEnum.HYPERMETRO)) {
            hostdeviceTypeL2.add("VMware");
            hostdeviceTypeL2.add("Windows");
            hostdeviceTypeL2.add("Solaris");
            hostdeviceTypeL2.add("AIX");
            hostdeviceTypeL2.add("HP-UX");
        } else if (OtherTaskTypeEnum.DATA_TURBO_COLLECT.equals((Object)taskTypeEnum)) {
            hostdeviceTypeL2.add("Linux");
        } else {
            hostdeviceTypeL2.add("Linux");
            hostdeviceTypeL2.add("VMware");
        }
        deviceTypel2.put(ItDeviceType.Host, hostdeviceTypeL2);
        setting.setItDeviceList(itDeviceList);
        setting.setDeviceTypel2(deviceTypel2);
    }

    private void initDataMigrationAddDialogData(DeviceManageSetting setting) {
        LinkedList<ItDeviceType> itDeviceList = new LinkedList<ItDeviceType>();
        HashMap deviceTypel2 = new HashMap();
        itDeviceList.add(ItDeviceType.Host);
        itDeviceList.add(ItDeviceType.Database);
        itDeviceList.add(ItDeviceType.Switch);
        itDeviceList.add(ItDeviceType.Storage);
        LinkedList<String> migrateDeviceTypeL2 = new LinkedList<String>();
        migrateDeviceTypeL2.add("Linux");
        migrateDeviceTypeL2.add("AIX");
        migrateDeviceTypeL2.add("HP-UX");
        migrateDeviceTypeL2.add("Solaris");
        migrateDeviceTypeL2.add("VMware");
        migrateDeviceTypeL2.add("Windows");
        migrateDeviceTypeL2.add("FusionSphere");
        migrateDeviceTypeL2.add("XenServer");
        LinkedList<String> storageDatabaseDeviceTypeL2 = new LinkedList<String>();
        storageDatabaseDeviceTypeL2.add("Oracle");
        storageDatabaseDeviceTypeL2.add("MySQL");
        storageDatabaseDeviceTypeL2.add("SQLServer");
        storageDatabaseDeviceTypeL2.add("DB2");
        LinkedList<String> switchdeviceTypeL2 = new LinkedList<String>();
        switchdeviceTypeL2.add("Brocade");
        switchdeviceTypeL2.add("Cisco");
        LinkedList<String> storagedeviceTypeL2 = new LinkedList<String>();
        storagedeviceTypeL2.add("EMC");
        storagedeviceTypeL2.add("HP");
        storagedeviceTypeL2.add("IBM");
        storagedeviceTypeL2.add("Huawei");
        storagedeviceTypeL2.add("NetApp");
        storagedeviceTypeL2.add("PureStorage");
        storagedeviceTypeL2.add("Fujistu");
        deviceTypel2.put(ItDeviceType.Host, migrateDeviceTypeL2);
        deviceTypel2.put(ItDeviceType.Database, storageDatabaseDeviceTypeL2);
        deviceTypel2.put(ItDeviceType.Switch, switchdeviceTypeL2);
        deviceTypel2.put(ItDeviceType.Storage, storagedeviceTypeL2);
        setting.setItDeviceList(itDeviceList);
        setting.setDeviceTypel2(deviceTypel2);
    }

    private void initDeviceAddDialogDataTimeTask(DeviceManageSetting setting) {
        LinkedList<ItDeviceType> itDeviceList = new LinkedList<ItDeviceType>();
        HashMap deviceTypel2 = new HashMap();
        itDeviceList.add(ItDeviceType.Host);
        LinkedList<String> hostdeviceTypeL2 = new LinkedList<String>();
        hostdeviceTypeL2.add("Linux");
        hostdeviceTypeL2.add("XenServer");
        deviceTypel2.put(ItDeviceType.Host, hostdeviceTypeL2);
        setting.setItDeviceList(itDeviceList);
        setting.setDeviceTypel2(deviceTypel2);
    }

    private List<String> getSupportedTypes(List<DeviceType> currList) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (DeviceType currType : currList) {
            resultList.add(currType.toString());
        }
        return resultList;
    }

    public boolean isNodeSupport(DevNode dev) {
        return true;
    }

    private boolean isTimeTask() {
        String type = GrabContext.getInstance().getCurrentTask().getTask().getTaskType();
        return null != type && type.equalsIgnoreCase(ResourceUtil.getString((String)"infograb.task.timely"));
    }
}

