/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.service.pub.DevInfoXlsParser;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceToolAction;
import com.huawei.ism.tool.devicemanager.ui.action.ImportFileType;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.intf.worktaker.AddDeviceService;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.swing.DevNodeImportAsyncExcutor;
import com.huawei.ism.tool.infograb.swing.DeviceContext;
import com.huawei.ism.tool.infograb.swing.DeviceManageService;
import com.huawei.ism.tool.infograb.swing.DeviceQueryErrorParser;
import com.huawei.ism.tool.infograb.swing.IDeviceManageService;
import com.huawei.ism.tool.infograb.utils.DeviceModelChecker;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.ssh.SshConnectionSecurityChecker;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.NetUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class BatchImportAction
extends DeviceToolAction {
    private static final long serialVersionUID = -7822596635558259665L;
    private static final int IMPORT_SUCCESS = 0;
    private static final int IMPORT_STOP = 2;
    private static final int IMPORT_FAILED = -1;
    private static final int IMPORT_OTHER = 8;
    private static final long IMPORT_FILE_SIZE = 0xA00000L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BatchImportAction.class);
    private static int importXmlError = 2;
    private Map<GrabDevNode1, String> deviceImportResult = null;
    private IDeviceManageService deviceManageService = new DeviceManageService();
    private Window parent;
    private List<String> isTaskDevicesIp = new ArrayList<String>();
    private Collection<GrabDevNode1> deviceList;
    private List<String> descptionList = new LinkedList<String>();
    private AddDeviceService addDeviceService;
    private File select2ImportFile;
    private boolean fromAddDeviceDialog = false;
    private int handledCount = 0;

    public BatchImportAction(Window parent) {
        this.parent = parent;
    }

    public BatchImportAction(Window parent, AddDeviceService addDeviceService, File select2ImportFile, boolean fromAddDeviceDialog) {
        this.parent = parent;
        this.addDeviceService = addDeviceService;
        this.select2ImportFile = select2ImportFile;
        this.fromAddDeviceDialog = fromAddDeviceDialog;
    }

    public void abstractActionPerformed(ActionEvent event) {
        DeviceContext.getInstance().setErrorStatus(0);
        this.deviceImportResult = new LinkedHashMap<GrabDevNode1, String>();
        int ret = this.doImport();
        if (8 == ret) {
            this.isTaskDevicesIp.clear();
            OperationEnum.BATCH_IMPORT.failLog("");
            return;
        }
        if (2 == ret) {
            OperationEnum.BATCH_IMPORT.failLog("");
            return;
        }
        if (-1 == ret) {
            OperationEnum.BATCH_IMPORT.failLog("");
            if (1 == DeviceContext.getInstance().getErrorStatus()) {
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"toolbox.proy.name.errormsg"));
                return;
            }
            if (1 == importXmlError) {
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"toolbox.xml.proy.errormsg"));
            } else if (this.deviceImportResult.isEmpty() && (null == this.deviceList || this.deviceList.isEmpty())) {
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.layout.device.import.failed"));
            } else {
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"toolbox.proy.errormsg"));
            }
        }
        OperationEnum.BATCH_IMPORT.successLog("");
        this.parent.dispose();
        ToolUtils.executeAddDevice2Complete(this.addDeviceService);
    }

    public int doImport() {
        File importFile = this.getImportFile();
        if (importFile == null) {
            if (this.fromAddDeviceDialog) {
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.batch.import.choosefile"));
            }
            LOGGER.info("No import file !");
            return 8;
        }
        String filePath = null;
        try {
            filePath = importFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical file path error.");
            return -1;
        }
        if (!FileUtils.isDiskFull((String)filePath, (long)0xA00000L)) {
            LOGGER.info("No import file, too big");
            return 8;
        }
        if (this.checkDevNode(importFile)) {
            return 2;
        }
        this.deviceList = this.parseDeviceFile(importFile, this.deviceImportResult);
        if (this.deviceList == null || this.deviceList.isEmpty()) {
            return -1;
        }
        if (!this.checkDeviceFile()) {
            return 2;
        }
        this.checkSshConnection();
        if (this.deviceList.isEmpty()) {
            return 2;
        }
        ImportDeviceTask importDeviceTask = new ImportDeviceTask();
        DevNodeImportAsyncExcutor.execute(this.parent, importDeviceTask);
        this.showImportInfoDialog(this.deviceList, this.descptionList);
        this.deviceImportResult.clear();
        LOGGER.info("import file success");
        return 0;
    }

    private void checkSshConnection() {
        List<GrabDevNode1> sshGrabNodes = this.deviceList.stream().filter(node -> DeviceModelChecker.isGrabBySsh(node)).collect(Collectors.toList());
        List sshIps = sshGrabNodes.stream().map(DevNode::getIp).collect(Collectors.toList());
        if (!new SshConnectionSecurityChecker(this.parent, sshGrabNodes).check()) {
            this.deviceList.removeIf(devNode1 -> sshIps.contains(devNode1.getIp()));
        }
    }

    private File getImportFile() {
        if (this.fromAddDeviceDialog) {
            return this.select2ImportFile;
        }
        return this.selectImportFile();
    }

    boolean checkDevNode(File importFile) {
        String suffix;
        return GrabContext.getInstance().isUpgradeEval() && ((suffix = this.getFileSuffix(importFile)).equals(ImportFileType.XLS.getValue()) || suffix.equals(ImportFileType.XLSX.getValue())) && this.checkNotHasRootPW(importFile);
    }

    private boolean checkNotHasRootPW(File importFile) {
        DevInfoXlsParser xlsParser = new DevInfoXlsParser();
        try {
            Collection parseDevs = xlsParser.parseFile(importFile);
            if (parseDevs != null && !DeviceAddDialog.checkHasRootPW((Collection)parseDevs, (Window)this.parent)) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.info("parseXlsTasks error.");
        }
        return false;
    }

    private File selectImportFile() {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("description", "*.xls;*xlsx");
        extParams.put("PathId", "device_manage_export_devcelist_001");
        String title = ResourceUtil.getString((String)"infograb.layout.device.import.title");
        extParams.put("title", title);
        File importFile = ToolFileChooser.selectFile(this.parent, new String[]{"xls", "xlsx"}, 2, true, extParams);
        return importFile;
    }

    private String getFileSuffix(File importFile) {
        String fileName = importFile.getName();
        String fileSuffix = fileName.substring(fileName.lastIndexOf(46) + 1);
        return fileSuffix;
    }

    private void showImportInfoDialog(Collection<GrabDevNode1> devList, List<String> descList) {
        LinkedList failRet = new LinkedList();
        boolean isNotRootFlag = false;
        int i = 0;
        for (GrabDevNode1 devnode : devList) {
            String deviceType;
            String dest;
            String des = "ERROR!";
            if (!descList.isEmpty()) {
                des = descList.get(i);
            }
            String uName = devnode.getLoginUser().getUserName();
            String deviceITType = "";
            if (devnode.getItDeviceType() != null) {
                deviceITType = devnode.getItDeviceType().getName();
            }
            isNotRootFlag = !StringUtils.isNULLStr(dest = this.promptSwitchRoot(deviceITType, deviceType = devnode.getDeviceName(), uName, devnode));
            des = des + dest;
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(devnode.getIp());
            if (null == devnode.getDevTypeLevel2() || devnode.getDevTypeLevel2().toString().isEmpty()) {
                tmp.add(devnode.getItDeviceType().toString());
            } else {
                tmp.add(devnode.getDevTypeLevel2().toString());
            }
            tmp.add(des);
            failRet.add(tmp);
            ++i;
        }
        if (isNotRootFlag) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.layout.device.import.no.root.prompt"));
        }
        SubDialogUtils.showMultiInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.layout.device.import.deviceadddialog.batcherror"), (String[])new String[]{ResourceUtil.getString((String)"infograb.layout.device.errormsg.ip"), ResourceUtil.getString((String)"infograb.layout.device.errormsg.name"), ResourceUtil.getString((String)"infograb.layout.device.errormsg.reason")}, failRet);
    }

    private boolean checkDeviceFile() {
        if (!GrabContext.getInstance().isUpgradeEval() && GrabContext.getInstance().getDevCount().get() + this.deviceList.size() > 1000) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.task.device_sum_limit_info"));
            return false;
        }
        return true;
    }

    private String promptSwitchRoot(String deviceITType, String deviceType, String uName, GrabDevNode1 devnode) {
        String des = "";
        String successDes = ResourceUtil.getString((String)"devicemanager.layout.device.import.success");
        String modifyDes = ResourceUtil.getString((String)"devicemanager.layout.device.import.modify");
        if (!GrabContext.getInstance().isUpgradeEval() && "Host".equalsIgnoreCase(deviceITType) && !"Windows".equalsIgnoreCase(deviceType) && "Host".equalsIgnoreCase(deviceITType) && !"Windows".equalsIgnoreCase(deviceType)) {
            User user = GrabContext.getInstance().getAdminNameAndPassMap().get(devnode.getIp());
            if (!"root".equals(uName) && null == user && (des.equals(successDes) || des.equals(modifyDes))) {
                des = ToolUtils.isFunsionSphere(devnode) ? ResourceUtil.getString((String)"devicemanager.layout.device.import.success.fusionsphere.not.root") : ResourceUtil.getString((String)"devicemanager.layout.device.import.success.not.root");
            }
        }
        return des;
    }

    private TaskResult checkDeviceIsInvalid(GrabDevNode1 devNode) {
        TaskResult devNodeTaks = new TaskResult();
        devNodeTaks.setErrorId(devNode.getIp());
        boolean passwdIllegal = StringUtils.isNULLStr(devNode.getLoginUser().getPassword());
        boolean usernameIllegal = StringUtils.isNULLStr(devNode.getLoginUser().getUserName());
        boolean portIllegal = devNode.getPort() < 0;
        boolean deviceIllegal = false;
        if (devNode.getDevTypeLevel2().toString().equalsIgnoreCase("Windows")) {
            deviceIllegal = passwdIllegal || usernameIllegal;
        } else {
            boolean bl = deviceIllegal = passwdIllegal || usernameIllegal || portIllegal;
        }
        if (deviceIllegal) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Device msg(username, password, port) is error");
            }
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.errorMess"));
            this.descptionList.add(ResourceUtil.getString((String)"import.devNode.errorMess"));
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        Socks5Proxy socks = devNode.getSocks5Proxy();
        boolean socksIllegal = this.checkSocks5Valid(socks);
        if (socksIllegal) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Socks msg(IP, Name, Port) is error");
            }
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.socks5.errorMess"));
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        List<MultiRouteNode> ssh = devNode.getSshForwardList();
        boolean sshOK = this.checkSshValid(devNode, ssh);
        if (sshOK) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Ssh msg(Host, User, Pwd, Port) is error");
            }
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.ssh.errorMess"));
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        return null;
    }

    private boolean checkSocks5Valid(Socks5Proxy socks) {
        if (null == socks) {
            return false;
        }
        boolean ipIsOk = !NetUtil.isValidIP((String)socks.getServerIp());
        boolean socksName = StringUtils.isNULLStr(socks.getName());
        boolean portOK = StringUtils.isNULLStr(socks.getPort());
        if (socksName || portOK || ipIsOk) {
            return true;
        }
        if (!socks.isAuthentic()) {
            return false;
        }
        boolean usernameOk = StringUtils.isNULLStr(socks.getUser());
        boolean passwdOk = StringUtils.isNULLStr(socks.getPass());
        return usernameOk || passwdOk;
    }

    private boolean checkSshValid(GrabDevNode1 devNode, List<MultiRouteNode> ssh) {
        if (null == ssh) {
            return false;
        }
        boolean sshNameInValid = StringUtils.isNULLStr(devNode.getSshName());
        if (sshNameInValid) {
            return true;
        }
        for (MultiRouteNode multiRouteNode : ssh) {
            boolean sshPortOK;
            boolean sshHostOK = !NetUtil.isValidIP((String)multiRouteNode.getHost());
            boolean sshPwdOK = StringUtils.isNULLStr(multiRouteNode.getPwd());
            boolean sshUserOK = StringUtils.isNULLStr(multiRouteNode.getUname());
            boolean bl = sshPortOK = multiRouteNode.getPort() < 0;
            if (!sshHostOK && !sshPwdOK && !sshUserOK && !sshPortOK) continue;
            return true;
        }
        return false;
    }

    private List<Socks5Proxy> addListChilden(List<Socks5Proxy> socks5List, Socks5Proxy socks5) {
        if (socks5List.isEmpty()) {
            socks5List.add(socks5);
            return socks5List;
        }
        int size = socks5List.size();
        for (int i = 0; i < size; ++i) {
            Socks5Proxy socks5Proxy = socks5List.get(i);
            if (!socks5Proxy.getName().equals(socks5.getName())) continue;
            LOGGER.info("update socks5 !");
            socks5Proxy.setName(socks5.getName());
            socks5Proxy.setAuthentic(socks5.isAuthentic());
            String pass = socks5.getPass();
            socks5Proxy.setPass(pass);
            socks5Proxy.setPort(socks5.getPort());
            socks5Proxy.setUser(socks5.getUser());
            socks5Proxy.setServerIp(socks5.getServerIp());
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pass);
            break;
        }
        return socks5List;
    }

    public boolean isAvailable() {
        return true;
    }

    private Collection<GrabDevNode1> parseDeviceFile(File importFile, Map<GrabDevNode1, String> deviceImpResult) {
        String suffix = this.getFileSuffix(importFile);
        ArrayList<GrabDevNode1> devList = new ArrayList<GrabDevNode1>();
        Collection parseDevs = null;
        HashMap result = new HashMap();
        if (suffix.equals(ImportFileType.XLS.getValue()) || suffix.equals(ImportFileType.XLSX.getValue())) {
            LOGGER.info("Import file's type is xls or xlsx");
            HashMap<ItDeviceType, Object> supportedTyeMap = new HashMap<ItDeviceType, Object>();
            supportedTyeMap.put(ItDeviceType.Host, null);
            supportedTyeMap.put(ItDeviceType.Database, null);
            if (!GrabContext.getInstance().isUpgradeEval()) {
                supportedTyeMap.put(ItDeviceType.Switch, null);
            }
            DevInfoXlsParser xlsParser = new DevInfoXlsParser(result, supportedTyeMap);
            try {
                parseDevs = xlsParser.parseFile(importFile);
            }
            catch (ToolException e) {
                LOGGER.info("parseXlsTasks error.");
            }
        }
        if (parseDevs == null || parseDevs.isEmpty()) {
            LOGGER.info("Imported file is null");
            return new ArrayList<GrabDevNode1>(0);
        }
        for (DevNode devNode : parseDevs) {
            GrabDevNode1 devNode1 = ToolUtils.obaseToNode1(devNode);
            if (result.containsKey(devNode)) {
                deviceImpResult.put(devNode1, (String)result.get(devNode));
            }
            devList.add(devNode1);
        }
        return devList;
    }

    public void setSelect2ImportFile(File select2ImportFile) {
        this.select2ImportFile = select2ImportFile;
    }

    private class ImportDeviceTask
    implements Callable<Boolean> {
        private ImportDeviceTask() {
        }

        private int getCheckIPMark() {
            return ((DeviceManageService)BatchImportAction.this.deviceManageService).getDeviceImportService().getIpIsOk();
        }

        @Override
        public Boolean call() {
            BatchImportAction.this.descptionList.clear();
            BatchImportAction.this.handledCount = 0;
            ArrayList<Socks5Proxy> socks5List = new ArrayList<Socks5Proxy>();
            socks5List.addAll(SettingService.getProxies());
            KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap = new KeyOrderedHashMap<String, List<MultiRouteNode>>();
            sshMap.putAll(SettingService.getSshForwards());
            KeyOrderedHashMap sshMapCollocate = SettingService.getSshMapCollocate();
            ArrayList<Socks5Proxy> sockLs = new ArrayList<Socks5Proxy>();
            String currError = ResourceUtil.getString((String)"toolbox.proy.errormsg");
            DevNodeImportAsyncExcutor.getDevNodeImportProgressDialog().setInitDevCount(BatchImportAction.this.deviceList.size(), 0);
            this.getImportResult(socks5List, sshMap, sshMapCollocate, sockLs, currError);
            SettingService.saveProxies(sshMap, sockLs);
            return true;
        }

        private void getImportResult(List<Socks5Proxy> socks5List, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMapCollocate, List<Socks5Proxy> sockLs, String currError) {
            TaskResult importResult = null;
            for (GrabDevNode1 devNode : BatchImportAction.this.deviceList) {
                String currResult;
                if (BatchImportAction.this.deviceImportResult.get(devNode) != null && (currResult = (String)BatchImportAction.this.deviceImportResult.get(devNode)) != null) {
                    BatchImportAction.this.descptionList.add(currResult);
                    continue;
                }
                importResult = BatchImportAction.this.checkDeviceIsInvalid(devNode);
                if (null != importResult) {
                    BatchImportAction.this.deviceImportResult.put(devNode, importResult.getErrorLocaleDescription());
                    continue;
                }
                importResult = this.addDevice(devNode);
                if (null != (importResult = DeviceQueryErrorParser.parseErrorInfo(importResult))) {
                    BatchImportAction.this.descptionList.add(importResult.getErrorLocaleDescription());
                    BatchImportAction.this.deviceImportResult.put(devNode, importResult.getErrorLocaleDescription());
                } else if (1 == this.getCheckIPMark()) {
                    BatchImportAction.this.descptionList.add(ResourceUtil.getString((String)"devnodes_import_not_null_ip"));
                    BatchImportAction.this.deviceImportResult.put(devNode, ResourceUtil.getString((String)"devnodes_import_not_null_ip"));
                } else if (2 == this.getCheckIPMark()) {
                    BatchImportAction.this.descptionList.add(ResourceUtil.getString((String)"devnodes_import_error_ip"));
                    BatchImportAction.this.deviceImportResult.put(devNode, ResourceUtil.getString((String)"devnodes_import_error_ip"));
                }
                if (null != importResult && TaskResult.Result.SUCCESS.equals((Object)importResult.getResult())) {
                    if (null != devNode.getSocks5Proxy()) {
                        sockLs.addAll(BatchImportAction.this.addListChilden(socks5List, devNode.getSocks5Proxy()));
                    }
                    if (null != devNode.getSshForwardList()) {
                        String jumpName = devNode.getSshName();
                        sshMap.put(devNode.getSshName(), (List<MultiRouteNode>)sshMapCollocate.get(jumpName));
                    }
                }
                DevNodeImportAsyncExcutor.getDevNodeImportProgressDialog().refreshHandleTaskCount(++BatchImportAction.this.handledCount);
                if (null == importResult) {
                    importResult = new TaskResult();
                    importResult.setResult(TaskResult.Result.FAILED);
                }
                LogUtils.addOperaLog((String)"operalog.name.importdevice", (DevNode)devNode, (TaskResult)importResult);
            }
        }

        private TaskResult addDevice(GrabDevNode1 devNode) {
            TaskResult importResult = null;
            String currTaskType = null;
            if (null == BatchImportAction.this.addDeviceService) {
                currTaskType = GrabContext.getInstance().getCurrentTask().getTask().getTaskType();
            }
            if (ResourceUtil.getString((String)"curr.periodtask.desc").equalsIgnoreCase(currTaskType)) {
                if (this.isPeriodSupport(devNode.getDevTypeLevel2().toString())) {
                    importResult = BatchImportAction.this.deviceManageService.importDevice(devNode);
                    if (null != importResult) {
                        importResult.setResultObject(devNode);
                    }
                } else {
                    importResult = BatchImportAction.this.deviceManageService.importDeviceSetFail(devNode);
                    if (null != importResult) {
                        importResult.setResultObject(devNode);
                    }
                }
            } else {
                importResult = this.dealwithRealTimeResult(devNode);
            }
            return importResult;
        }

        private TaskResult dealwithRealTimeResult(GrabDevNode1 devNode) {
            TaskResult importResult;
            if (this.isRealTimeSupport(devNode.getDevTypeLevel2().toString())) {
                importResult = BatchImportAction.this.deviceManageService.importDevice(devNode);
                if (null != importResult) {
                    importResult.setResultObject(devNode);
                }
            } else {
                importResult = BatchImportAction.this.deviceManageService.importDeviceSetFail(devNode);
                if (null != importResult) {
                    importResult.setResultObject(devNode);
                }
            }
            return importResult;
        }

        private TaskResult dealwithProxy(GrabDevNode1 devNode) {
            TaskResult importResult = null;
            if ((null != devNode.getSocks5Proxy() || null != devNode.getSshForwardList()) && null != (importResult = BatchImportAction.this.deviceManageService.importDeviceSetNoProxy(devNode))) {
                importResult.setResultObject(devNode);
            }
            return importResult;
        }

        private boolean isPeriodSupport(String devType) {
            boolean result = false;
            ArrayList<String> devListSpt = new ArrayList<String>();
            devListSpt.add("Linux");
            devListSpt.add("XenServer");
            for (int i = 0; i < devListSpt.size(); ++i) {
                if (!((String)devListSpt.get(i)).equalsIgnoreCase(devType)) continue;
                result = true;
                break;
            }
            return result;
        }

        private boolean isUltraPathSupport(String devType) {
            boolean result = false;
            ArrayList<String> devListSpt = new ArrayList<String>();
            devListSpt.add("Linux");
            devListSpt.add("AIX");
            devListSpt.add("Solaris");
            devListSpt.add("VMware");
            for (int i = 0; i < devListSpt.size(); ++i) {
                if (!((String)devListSpt.get(i)).equalsIgnoreCase(devType)) continue;
                result = true;
                break;
            }
            return result;
        }

        private boolean isRealTimeSupport(String devType) {
            boolean result = false;
            if (StringUtils.isNULLStr(devType)) {
                LOGGER.error("[isRealTimeSupport] The devType is null.");
                return result;
            }
            ArrayList<String> devListSpt = new ArrayList<String>();
            devListSpt.add("Linux");
            devListSpt.add("Solaris");
            devListSpt.add("Aix");
            devListSpt.add("HP-UX");
            devListSpt.add("VMware");
            devListSpt.add("Windows");
            devListSpt.add("FusionsPhere");
            devListSpt.add("XenServer");
            devListSpt.add("Oracle");
            devListSpt.add("MySQL");
            devListSpt.add("SQLServer");
            devListSpt.add("DB2");
            if (!GrabContext.getInstance().isUpgradeEval()) {
                devListSpt.add("Brocade");
                devListSpt.add("Cisco");
            }
            for (int i = 0; i < devListSpt.size(); ++i) {
                if (!((String)devListSpt.get(i)).equalsIgnoreCase(devType.trim())) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

