/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabParamEntity;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.grab.CompressDataTurboLogThread;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabWorktaker;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.AddDevDialogResult;
import com.huawei.ism.tool.infograb.ui.AddDevServiceTask;
import com.huawei.ism.tool.infograb.ui.InfoGrabIsmTable;
import com.huawei.ism.tool.infograb.ui.MultiWarningContnueDialog;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskPanel;
import com.huawei.ism.tool.infograb.ui.StorUpAddDevDialog;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.InformationDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.Utils;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectDeviceAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectDeviceAction.class);
    private static final Object INFO_COLLECT_LOCK = new Object();
    private static int taskNum = 1;
    private InfoGrabService grabService = InfoGrabService.getInstance();
    private volatile boolean grabThreadsRunning = false;
    private Thread collectionThread = null;
    private RealTimeTaskPanel taskPanel;

    public CollectDeviceAction(RealTimeTaskPanel taskPanel) {
        this.taskPanel = taskPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.collectionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("Click collect device btn.");
                CollectDeviceAction.this.doCollect();
            }
        }, "GrabThread");
        this.collectionThread.start();
    }

    private void refreshUI() {
        JLabel taskStatus = this.taskPanel.getTaskStatus();
        taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.collecting"));
        taskStatus.setIcon(ResourceUtil.getImage((String)"loading.gif"));
        taskStatus.repaint();
    }

    private boolean ensureDialog(List<GrabDevNode2> selectNodes) {
        InfoGrabIsmTable table = ((RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).getDevTable();
        List rows = table.getAllRows();
        RealTimeTaskPanel realTimeTaskPanel = (RealTimeTaskPanel)GrabContext.getInstance().getCurrentTask();
        RealTimeTask realTimeTask = (RealTimeTask)realTimeTaskPanel.getTask();
        List<String> taskCategory = realTimeTask.getTaskCategory();
        if (taskCategory.contains(ResourceUtil.getString((String)"infograb.item.category.pre_update_exploration"))) {
            ArrayList<TableRow> notCollectedDeviceRows = new ArrayList<TableRow>();
            boolean isSelectedCorrect = true;
            Map<String, List<String>> collectedResult = GrabContext.getInstance().getCollectedResult();
            for (TableRow row : rows) {
                GrabDevNode2 dev = (GrabDevNode2)((Object)row.getUserObject());
                if (null != collectedResult.get(dev.getDeviceSerialNumber())) continue;
                notCollectedDeviceRows.add(row);
                if (selectNodes.contains((Object)dev)) continue;
                isSelectedCorrect = false;
            }
            if (this.isSelecteCorrect(table, rows, notCollectedDeviceRows, isSelectedCorrect)) {
                return false;
            }
        }
        try {
            if (!this.checkWindowsConnection(selectNodes)) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("exec check win conn error");
        }
        return true;
    }

    private boolean isSelecteCorrect(InfoGrabIsmTable table, List<TableRow> rows, List<TableRow> notCollectedDeviceRows, boolean isSelectedCorrect) {
        if (isSelectedCorrect) {
            ProgressDialog progressDialog = new ProgressDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame());
            ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
            AddDevServiceTask addServiceTask = new AddDevServiceTask(rows);
            AddDevDialogResult addTaskResult = (AddDevDialogResult)taskExecutor.execute(addServiceTask);
            StorUpAddDevDialog addDialog = addTaskResult.getDialogResult();
            this.showWarningDialog(addDialog);
            return 0 != addDialog.getValue();
        }
        String waringMsg = ResourceUtil.getString((String)"infograb.remind.pre.upgrade.grab.selectall");
        InformationDialog dia = DialogUtils.createShowinfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)waringMsg);
        if (0 == dia.getValue()) {
            for (TableRow notCollectedDeviceRow : notCollectedDeviceRows) {
                table.markTableRow(new TableRow[]{notCollectedDeviceRow});
            }
        }
        return true;
    }

    private boolean checkWindowsConnection(List<GrabDevNode2> selectNodes) throws InterruptedException, ExecutionException {
        ArrayList<GrabDevNode2> winDevList = new ArrayList<GrabDevNode2>();
        for (GrabDevNode2 selectNode : selectNodes) {
            if (!ToolUtils.isWindowsHost(selectNode)) continue;
            winDevList.add(selectNode);
        }
        if (winDevList.isEmpty()) {
            return true;
        }
        String checkTipKey = "infograb.layout.device.add.deviceadddialog.win.paconn.check.tip";
        ProgressDialog progressDialog = new ProgressDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), ResourceUtil.getString((String)checkTipKey), 470);
        WinConnCheckTask winCheckTask = new WinConnCheckTask(progressDialog, winDevList);
        Future resultFuture = AsyncExcutor.submit((Callable)winCheckTask);
        progressDialog.setVisible(true);
        List warningDatas = (List)resultFuture.get();
        if (!warningDatas.isEmpty()) {
            MultiWarningContnueDialog warningDialog = new MultiWarningContnueDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), ResourceUtil.getString((String)"infograb.collect.windows.connection.warning.dialog.desc"), new String[]{ResourceUtil.getString((String)"infograb.devicetable.head.ip"), ResourceUtil.getString((String)"infograb.devicetable.head.devicemodel"), ResourceUtil.getString((String)"infograb.devicetable.head.sn")}, warningDatas);
            warningDialog.setVisible(true);
            if (0 == warningDialog.getClickValue()) {
                LOGGER.info("Click OK, Go back to the Start collection interface.");
                ListIterator<GrabDevNode2> selectNodesIterator = selectNodes.listIterator();
                this.removeNotPassDevice(warningDatas, selectNodesIterator);
                return !selectNodes.isEmpty();
            }
            return false;
        }
        return true;
    }

    private void removeNotPassDevice(List<List<String>> warningDatas, Iterator<GrabDevNode2> selectNodesIterator) {
        block0: while (selectNodesIterator.hasNext()) {
            GrabDevNode2 devNode2 = selectNodesIterator.next();
            for (List<String> devInfolist : warningDatas) {
                if (!devInfolist.get(0).trim().equals(devNode2.getIp().trim())) continue;
                selectNodesIterator.remove();
                continue block0;
            }
        }
    }

    private void showWarningDialog(StorUpAddDevDialog warningDialog) {
        if (Utils.isJunitTest()) {
            warningDialog.setVisible(false);
            warningDialog.setValue(0);
        } else {
            warningDialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCollect() {
        Object object = INFO_COLLECT_LOCK;
        synchronized (object) {
            if (this.grabThreadsRunning) {
                DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.waitcollectionstop"));
                OperationEnum.DO_COLLECT.failLog("");
                return;
            }
            List<GrabDevNode2> currSelectedNodes = ((RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).getSelectedDevNode();
            boolean result = this.checkTask(currSelectedNodes);
            if (!result) {
                OperationEnum.DO_COLLECT.failLog("");
                return;
            }
            RealTimeTaskPanel currentTaskPanel = (RealTimeTaskPanel)GrabContext.getInstance().getCurrentTask();
            this.refreshUI();
            RealTimeTaskDetailContainer container = (RealTimeTaskDetailContainer)currentTaskPanel.getTaskDetailContainer();
            for (GrabDevNode2 devNode : currSelectedNodes) {
                devNode.setCollectStop(false);
                if (!devNode.isCollectDone()) continue;
                devNode.setCollectDone(false);
                int oldProcess = ((RealTimeTask)currentTaskPanel.getTask()).getTaskCurruentProcess();
                int newProcess = oldProcess - 1;
                ((RealTimeTask)currentTaskPanel.getTask()).setTaskCurruentProcess(newProcess);
                currentTaskPanel.refreshTaskProcess();
            }
            GrabWorktaker.getInstance().collectDevsInfos(new GrabParamEntity(currSelectedNodes, container, taskNum, null), currentTaskPanel.getTask());
            RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get(currSelectedNodes.stream().findFirst().get());
            if (collectTask.isContainsDataTurboSence()) {
                new CompressDataTurboLogThread(currSelectedNodes).start();
            }
            ++taskNum;
        }
    }

    private boolean checkTask(List<GrabDevNode2> currSelectedNodes) {
        if (!GrabUtil.checkAtLeastOneNode(currSelectedNodes)) {
            LOGGER.info("Not select an devNode");
            return false;
        }
        if (!this.grabService.isSelectedNodesStopped(currSelectedNodes)) {
            LOGGER.info("The devNode is busy");
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.option.error.grab"));
            return false;
        }
        if (!this.grabService.preCheckResultFolder()) {
            LOGGER.info("Not collect, please check the file's read or write right! ");
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.resultfolder.error"));
            return false;
        }
        if (!this.grabService.checkDiskCapactity((long)currSelectedNodes.size() * 0x500000L)) {
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.diskcapactityinsufficient"));
            if (0 == warningDialog.getValue()) {
                LOGGER.info("Select the disk may result in the acquisition failed due to insufficient capacity!");
                return this.ensureDialog(currSelectedNodes);
            }
            return false;
        }
        if (this.checkSmratIdcScenario(currSelectedNodes)) {
            return false;
        }
        return this.ensureDialog(currSelectedNodes);
    }

    private boolean checkSmratIdcScenario(List<GrabDevNode2> currSelectedNodes) {
        if (GrabContext.getInstance().getCurrentTask() == null || GrabContext.getInstance().getCurrentTask().getTask() == null) {
            return false;
        }
        if (this.checkSmartIdcCollect(currSelectedNodes)) {
            List<GrabDevNode2> allNodes;
            if (currSelectedNodes.size() > 1) {
                DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.collectdeviceaction.nasinfo"));
                return true;
            }
            JComponent compent = GrabContext.getInstance().getCurrentTask().getTaskDetailContainer();
            if (compent instanceof RealTimeTaskDetailContainer && !this.grabService.isSelectedNodesStopped(allNodes = ((RealTimeTaskDetailContainer)compent).getAllDevNode())) {
                LOGGER.info("devNode is busy");
                DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.collectdeviceaction.nasinfo"));
                return true;
            }
        }
        return false;
    }

    private boolean checkSmartIdcCollect(List<GrabDevNode2> currSelectedNodes) {
        for (GrabDevNode2 devNode2 : currSelectedNodes) {
            if (!"NetApp".equals(devNode2.getDevTypeLevel2().toString()) && (!"EMC".equalsIgnoreCase(devNode2.getDevTypeLevel2().toString()) || !"VMAX".equalsIgnoreCase(devNode2.getDeviceModel()))) continue;
            return true;
        }
        return false;
    }

    public void setRunning(boolean isRunning) {
        this.grabThreadsRunning = isRunning;
    }

    public Thread getCollectionThread() {
        return this.collectionThread;
    }

    private static final class WinConnCheckTask
    implements Callable<List<List<String>>> {
        private ProgressDialog progressDialog;
        private List<GrabDevNode2> winDevList;

        public WinConnCheckTask(ProgressDialog progressDialog, List<GrabDevNode2> winDevList) {
            this.progressDialog = progressDialog;
            this.winDevList = winDevList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<List<String>> call() {
            try {
                ConnUtils.sleep(100);
                ArrayList warningDatas = new ArrayList();
                for (GrabDevNode2 selectNode : this.winDevList) {
                    boolean isPaexec = ToolUtils.isWinConnected(selectNode);
                    if (isPaexec) continue;
                    ArrayList<String> oneRow = new ArrayList<String>();
                    oneRow.add(selectNode.getIp());
                    oneRow.add(selectNode.getDeviceType().toString());
                    oneRow.add(selectNode.getDeviceSerialNumber());
                    warningDatas.add(oneRow);
                    WmicConnectionManager.releaseConn(selectNode);
                }
                ArrayList arrayList = warningDatas;
                return arrayList;
            }
            finally {
                this.progressDialog.setVisible(false);
                this.progressDialog.dispose();
            }
        }
    }
}

