/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.infograb.base.IDetailContainer;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelDeviceAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelDeviceAction.class);
    private IConnectionManage connMng;
    private InfoGrabService grabService = InfoGrabService.getInstance();
    private JFrame parent;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.connMng = this.grabService.getCurrConnManager();
        LOGGER.info("Click del device btn.");
        List<GrabDevNode2> currSelectedNodes = ((IDetailContainer)((Object)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer())).getSelectedDevNode();
        this.clearExcelData(currSelectedNodes);
        if (!GrabUtil.checkAtLeastOneNode(currSelectedNodes)) {
            LOGGER.info("Should select at least a devNode");
            OperationEnum.DELETE_DEVICE.failLog("");
            return;
        }
        this.parent = GrabContext.getInstance().getCurrInfoGrabFrame();
        WarningDialog wdialog = DialogUtils.showYesNoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devnodes_delete_action"));
        if (0 == wdialog.getValue()) {
            this.delFinalDevNodes(currSelectedNodes);
        }
    }

    private void clearExcelData(List<GrabDevNode2> currSelectedNodes) {
        Map<String, LinkedList<String>> hostMap = GrabContext.getInstance().getHostData();
        Map<String, LinkedList<String>> dbMap = GrabContext.getInstance().getDbData();
        Map<String, LinkedList<String>> switchMap = GrabContext.getInstance().getSwitchData();
        Map<String, ArrayList<LinkedList<String>>> longMap = GrabContext.getInstance().getOverlengthData();
        for (GrabDevNode2 dev : currSelectedNodes) {
            String sn = dev.getDeviceSerialNumber();
            if (!hostMap.isEmpty() && hostMap.containsKey(sn)) {
                hostMap.remove(sn);
            }
            if (!dbMap.isEmpty() && dbMap.containsKey(sn)) {
                dbMap.remove(sn);
            }
            if (!switchMap.isEmpty() && switchMap.containsKey(sn)) {
                switchMap.remove(sn);
            }
            if (longMap.isEmpty() || !longMap.containsKey(sn)) continue;
            longMap.remove(sn);
        }
    }

    private void delFinalDevNodes(List<GrabDevNode2> currSelectedNodes) {
        List<GrabDevNode2> finalDeldevNodes = this.getFinalDevNodes(currSelectedNodes);
        LinkedList tableDatas = new LinkedList();
        for (GrabDevNode2 devnode : finalDeldevNodes) {
            LinkedList<String> data = new LinkedList<String>();
            data.add(devnode.getDeviceName());
            data.add(devnode.getIp());
            tableDatas.add(data);
        }
        this.delDevice(finalDeldevNodes);
    }

    private List<GrabDevNode2> getFinalDevNodes(List<GrabDevNode2> currSelectedNodes) {
        if (!this.grabService.isSelectedNodesStopped(currSelectedNodes)) {
            ArrayList<GrabDevNode2> finalDeldevNodesList = new ArrayList<GrabDevNode2>();
            ArrayList<GrabDevNode2> delFaildevNodes = new ArrayList<GrabDevNode2>();
            for (GrabDevNode2 devnode : currSelectedNodes) {
                if (!this.grabService.findNodeStatus(devnode).booleanValue()) {
                    finalDeldevNodesList.add(devnode);
                    continue;
                }
                delFaildevNodes.add(devnode);
            }
            this.createFinalAlert(delFaildevNodes, finalDeldevNodesList);
            return finalDeldevNodesList;
        }
        return currSelectedNodes;
    }

    private void createFinalAlert(List<GrabDevNode2> delFaildevNodes, List<GrabDevNode2> finalDeldevNodes) {
        ArrayList<String> rowData;
        String[] tabletitle = new String[]{ResourceUtil.getString((String)"infograb.passwordtable.head.ip"), ResourceUtil.getString((String)"devnodes_detele_fail_reason")};
        String failReason = ResourceUtil.getString((String)"devnodes_detele_fail_reason_info");
        String succReason = ResourceUtil.getString((String)"devnodes_delete_success");
        LinkedList tableDatasList = new LinkedList();
        for (GrabDevNode2 devnode : delFaildevNodes) {
            rowData = new ArrayList<String>();
            rowData.add(devnode.getItDeviceType() + "_" + devnode.getIp());
            rowData.add(failReason);
            tableDatasList.add(rowData);
        }
        for (GrabDevNode2 devnode : finalDeldevNodes) {
            rowData = new ArrayList();
            rowData.add(devnode.getItDeviceType() + "_" + devnode.getIp());
            rowData.add(succReason);
            tableDatasList.add(rowData);
        }
        SubDialogUtils.showMultiInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devnodes_delete_fail"), (String[])tabletitle, tableDatasList);
    }

    private void delDevice(List<GrabDevNode2> currSelectedNodes) {
        LinkedList<GrabDevNode2> currNodesList = new LinkedList<GrabDevNode2>();
        for (GrabDevNode2 delDevNode : currSelectedNodes) {
            if (this.grabService.isDevNodeCollecting(delDevNode).booleanValue()) {
                currNodesList.add(delDevNode);
                continue;
            }
            LOGGER.info("Delete devNode ip is ***.");
            this.clearDataCache(delDevNode);
            this.closeDevNodeConn(delDevNode);
            this.delDevNodeFromDevMng(delDevNode);
            this.releaseWinConn(delDevNode);
            OperationEnum.DELETE_DEVICE.successLogWithResources(delDevNode.getIp(), delDevNode.getDeviceName());
        }
        this.avoidDelNodeAlert(currNodesList);
    }

    private void releaseWinConn(GrabDevNode2 delDevNode) {
        if (ToolUtils.isWindowsHost(delDevNode)) {
            WmicConnectionManager.releaseConn(EntityUtils.toOldDev(delDevNode));
        }
    }

    private void avoidDelNodeAlert(List<GrabDevNode2> currNodes) {
        if (!currNodes.isEmpty()) {
            StringBuffer alertDisStrBuf = new StringBuffer();
            for (GrabDevNode2 node : currNodes) {
                LOGGER.info("The devNode is busy IP is ***.");
                alertDisStrBuf.append("IP:    " + node.getIp()).append(GrabFileFactory.ENTER);
            }
            alertDisStrBuf.append(ResourceUtil.getString((String)"infograb.option.error.del"));
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)alertDisStrBuf.toString());
        }
    }

    private void clearDataCache(GrabDevNode2 devNode) {
        GrabContext ctx = GrabContext.getInstance();
        ctx.getExecuteResultMap().remove((Object)devNode);
        ctx.getNodeStatusMap().remove((Object)devNode);
        GrabFlowAdapter.getInstance().getNodeGrabFlowMap().remove((Object)devNode);
        GrabContext.getInstance().getAdminNameAndPassMap().remove(devNode.getIp());
        LOGGER.info("Cached data cleared");
    }

    private void closeDevNodeConn(GrabDevNode2 devNodeConn) {
        TLVConnection conn = null;
        if (this.connMng == null) {
            return;
        }
        Object connMngcon = this.connMng.getTLVConnection((DevNode)devNodeConn);
        if (connMngcon instanceof TLVConnection) {
            conn = (TLVConnection)this.connMng.getTLVConnection((DevNode)devNodeConn);
        }
        if (null != conn) {
            this.connMng.closeTLVConnetcion((Object)conn);
        }
        LOGGER.info("Close device *** tlvCon.");
    }

    private void delDevNodeFromDevMng(GrabDevNode2 devNode) {
        String sn;
        String ip = devNode.getIp();
        if (!this.deleteOneDevice(ip, sn = devNode.getDeviceSerialNumber()) && LOGGER.isErrorEnabled()) {
            LOGGER.error("Delete one device *** in devMng failed");
        }
    }

    private boolean deleteOneDevice(String ip, String sn) {
        DefaultNodeProviderImpl devContainer = DefaultNodeProviderImpl.getInstance();
        List nodes = devContainer.getNodeList();
        for (com.huawei.ism.tool.obase.entity.DevNode devNode : nodes) {
            if (!ip.equals(devNode.getIp()) || !sn.equals(devNode.getDeviceSerialNumber())) continue;
            try {
                devContainer.removeNode(devNode);
            }
            catch (ToolException e) {
                LOGGER.error("[Delete dev >> " + ip + "][Failed]", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }
}

