/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.infograb.base.BaseTaskPanel;
import com.huawei.ism.tool.infograb.base.IDetailContainer;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.action.DelDeviceAction;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelTaskAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelDeviceAction.class);
    private IConnectionManage connMng;
    private InfoGrabService grabService = InfoGrabService.getInstance();
    private JFrame parent;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.connMng = this.grabService.getCurrConnManager();
        LOGGER.info("Click del task btn.");
        this.parent = GrabContext.getInstance().getCurrInfoGrabFrame();
        if (GrabContext.getInstance().getCollectTasks().isEmpty()) {
            DialogUtils.showInfoDialog((Frame)this.parent, (String)ResourceUtil.getString((String)"infograb.task.delete_no_task"));
            OperationEnum.DELETE_TASK.failLog("");
        } else {
            WarningDialog wdialog = DialogUtils.showYesNoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.task.delete_info"));
            if (0 == wdialog.getValue()) {
                List<GrabDevNode2> allNodes = ((IDetailContainer)((Object)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer())).getAllDevNode();
                this.delFinalDevNodes(allNodes);
                OperationEnum.DELETE_TASK.successLog("");
            }
        }
    }

    private void delFinalDevNodes(List<GrabDevNode2> allNodes) {
        List<GrabDevNode2> finalDeldevNodes = this.getFinalDevNodes(allNodes);
        LinkedList tableDatas = new LinkedList();
        for (GrabDevNode2 devnode : finalDeldevNodes) {
            LinkedList<String> data = new LinkedList<String>();
            data.add(devnode.getDeviceName());
            data.add(devnode.getIp());
            tableDatas.add(data);
        }
        this.delDevice(finalDeldevNodes);
        if (allNodes.size() == finalDeldevNodes.size()) {
            this.deleteTaskPanel();
        }
    }

    private void deleteTaskPanel() {
        BaseTaskPanel delTask = GrabContext.getInstance().getCurrentTask();
        GrabContext.getInstance().getCurrInfoGrabFrame().getcurrLayout().deleteSelectedTask(delTask);
    }

    private List<GrabDevNode2> getFinalDevNodes(List<GrabDevNode2> currSelectedNodes) {
        if (!this.grabService.isSelectedNodesStopped(currSelectedNodes)) {
            ArrayList<GrabDevNode2> finalDeldevNodes = new ArrayList<GrabDevNode2>();
            ArrayList<GrabDevNode2> delFaildevNodes = new ArrayList<GrabDevNode2>();
            for (GrabDevNode2 devnode : currSelectedNodes) {
                if (!this.grabService.findNodeStatus(devnode).booleanValue()) {
                    finalDeldevNodes.add(devnode);
                    continue;
                }
                delFaildevNodes.add(devnode);
            }
            this.createFinalAlert(delFaildevNodes, finalDeldevNodes);
            return finalDeldevNodes;
        }
        return currSelectedNodes;
    }

    private void createFinalAlert(List<GrabDevNode2> delFaildevNodes, List<GrabDevNode2> finalDeldevNodes) {
        ArrayList<String> rowData;
        String[] tabletitle = new String[]{ResourceUtil.getString((String)"infograb.passwordtable.head.ip"), ResourceUtil.getString((String)"devnodes_detele_fail_reason")};
        String failReason = ResourceUtil.getString((String)"devnodes_detele_fail_reason_info");
        String succReason = ResourceUtil.getString((String)"devnodes_delete_success");
        LinkedList tableDatas = new LinkedList();
        for (GrabDevNode2 devnode : delFaildevNodes) {
            rowData = new ArrayList<String>();
            rowData.add(devnode.getItDeviceType() + "_" + devnode.getIp());
            rowData.add(failReason);
            tableDatas.add(rowData);
        }
        for (GrabDevNode2 devnode : finalDeldevNodes) {
            rowData = new ArrayList();
            rowData.add(devnode.getItDeviceType() + "_" + devnode.getIp());
            rowData.add(succReason);
            tableDatas.add(rowData);
        }
        SubDialogUtils.showMultiInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devnodes_delete_fail"), (String[])tabletitle, tableDatas);
    }

    private void delDevice(List<GrabDevNode2> currSelectedNodes) {
        LinkedList<GrabDevNode2> currNodes = new LinkedList<GrabDevNode2>();
        for (GrabDevNode2 delDevNode : currSelectedNodes) {
            if (this.grabService.isDevNodeCollecting(delDevNode).booleanValue()) {
                currNodes.add(delDevNode);
                continue;
            }
            LOGGER.info("Delete devNode ip is ***.");
            this.clearDataCache(delDevNode);
            this.closeDevNodeConn(delDevNode);
            this.delDevNodeFromDevMng(delDevNode);
            this.clearExcelData(currSelectedNodes);
        }
        this.avoidDelNodeAlert(currNodes);
    }

    private void clearExcelData(List<GrabDevNode2> currSelectedNodes) {
        Map<String, LinkedList<String>> hostMap = GrabContext.getInstance().getHostData();
        Map<String, LinkedList<String>> dbMap = GrabContext.getInstance().getDbData();
        Map<String, LinkedList<String>> switchMap = GrabContext.getInstance().getSwitchData();
        Map<String, ArrayList<LinkedList<String>>> longMap = GrabContext.getInstance().getOverlengthData();
        for (GrabDevNode2 dev : currSelectedNodes) {
            String sn = dev.getDeviceSerialNumber();
            if (!hostMap.isEmpty() && hostMap.containsKey(sn)) {
                hostMap.remove(sn);
            }
            if (!dbMap.isEmpty() && dbMap.containsKey(sn)) {
                dbMap.remove(sn);
            }
            if (!switchMap.isEmpty() && switchMap.containsKey(sn)) {
                switchMap.remove(sn);
            }
            if (longMap.isEmpty() || !longMap.containsKey(sn)) continue;
            longMap.remove(sn);
        }
    }

    private void avoidDelNodeAlert(List<GrabDevNode2> currNodes) {
        if (!currNodes.isEmpty()) {
            StringBuffer alertDis = new StringBuffer();
            for (GrabDevNode2 node : currNodes) {
                LOGGER.info("The devNode is busy IP is ***.");
                alertDis.append("IP:    " + node.getIp()).append(GrabFileFactory.ENTER);
            }
            alertDis.append(ResourceUtil.getString((String)"infograb.option.error.del"));
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)alertDis.toString());
        }
    }

    private void clearDataCache(GrabDevNode2 devNode) {
        GrabContext ctx = GrabContext.getInstance();
        ctx.getExecuteResultMap().remove((Object)devNode);
        ctx.getNodeStatusMap().remove((Object)devNode);
        GrabFlowAdapter.getInstance().getNodeGrabFlowMap().remove((Object)devNode);
        LOGGER.info("Cached data cleared");
    }

    private void closeDevNodeConn(GrabDevNode2 devNode) {
        TLVConnection conn = null;
        if (this.connMng == null) {
            return;
        }
        Object connMngcon = this.connMng.getTLVConnection((DevNode)devNode);
        if (connMngcon instanceof TLVConnection) {
            conn = (TLVConnection)this.connMng.getTLVConnection((DevNode)devNode);
        }
        if (null != conn) {
            this.connMng.closeTLVConnetcion((Object)conn);
        }
        LOGGER.info("Close device *** tlvCon.");
    }

    private void delDevNodeFromDevMng(GrabDevNode2 devNode) {
        String suNumber = devNode.getIp();
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        if (!devMng.deleteOneDevice(suNumber) && LOGGER.isErrorEnabled()) {
            LOGGER.error("Delete one device[" + suNumber + "] in devMng failed");
        }
    }
}

