/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrame;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class DirSetupButtonAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(DirSetupButtonAction.class);
    private static final String SAVEPATH_DEFAULT_ID = "infograb_saveresult_path_id001";
    private InfoGrabMainFrame dialog = null;

    public DirSetupButtonAction(InfoGrabMainFrame dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!HibernateContainer.getInstance().containsKey(SAVEPATH_DEFAULT_ID)) {
            HibernateContainer.getInstance().put(SAVEPATH_DEFAULT_ID, (Object)(FileUtils.getDefaultDirectory() + "\\data\\infograb"));
        }
        if (!InfoGrabService.getInstance().isAllDevNodeStoppped()) {
            DialogUtils.showErrorDialog((Window)this.dialog, (String)ResourceUtil.getString((String)"infograb.remind.nochangewhencollecting"));
            OperationEnum.SET_REPORT_DIR.failLog("");
            return;
        }
        Optional<String> pathOptional = this.getReportDirPath();
        if (!pathOptional.isPresent() || this.checkPathInvalid(pathOptional.get(), event)) {
            OperationEnum.SET_REPORT_DIR.failLog("");
            return;
        }
        try {
            InfoGrabDirPropertiesUtil.setProperty(pathOptional.get());
            DialogUtils.showInfoDialog((Frame)this.dialog, (String)ResourceUtil.getString((String)"infograb.remind.dirchangesuccess"));
            OperationEnum.SET_REPORT_DIR.successLog("");
        }
        catch (Exception ex) {
            log.error("Save collect dir failed!!!");
            DialogUtils.showInfoDialog((Frame)this.dialog, (String)ResourceUtil.getString((String)"infograb.remind.dirchangefail"));
            OperationEnum.SET_REPORT_DIR.failLog("");
        }
    }

    private boolean checkPathInvalid(String path, ActionEvent event) {
        if (!FilesUtil.checkNormalPath(path)) {
            log.info("The path can contain only letters, digits, _, point, and a single space.");
            DialogUtils.showInfoDialog((Frame)this.dialog, (String)ResourceUtil.getString((String)"infograb.remind.dirchangefail.character"));
            this.actionPerformed(event);
            return true;
        }
        if (!FilesUtil.checkBlankPath(path)) {
            log.info("The path cannot contain space.");
            DialogUtils.showInfoDialog((Frame)this.dialog, (String)ResourceUtil.getString((String)"infograb.remind.dirchangefail.noblank"));
            this.actionPerformed(event);
            return true;
        }
        return false;
    }

    private Optional<String> getReportDirPath() {
        String[] eats = new String[]{};
        File file = ToolFileChooser.selectFile(this.dialog, ResourceUtil.getString((String)"infograb.set.directory.title"), eats, SAVEPATH_DEFAULT_ID, ResourceUtil.getString((String)"infograb.folder"), 1);
        if (null == file) {
            return Optional.empty();
        }
        try {
            return Optional.of(file.getCanonicalPath());
        }
        catch (IOException e1) {
            log.error("Save collect dir failed.");
            DialogUtils.showInfoDialog((Frame)this.dialog, (String)ResourceUtil.getString((String)"infograb.remind.dirchangefail"));
            return Optional.empty();
        }
    }
}

