/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.devicemanager.service.pub.DevInfoXlsParser;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.slf4j.Logger;

public class DownLoadAction
implements ToolHyperLinkLabel.ClickListener {
    public static final String TEMPLATE_FILE_NAME = "DeviceList_Template.xls";
    public static final String TEMPLATE_FILE_PATH = "/config/templatefile/";
    private static final String TEMPLATE_COMMAND_FILE_NAME = "InfoGrab_Command_List.xls";
    private static final String TEMPLATE_COMMAND_HOSTINFO = "InfoGrab_HostInfo_List.xls";
    private static final String BEGIN_TEMPLATE_HOSTINFO_ZH = "HostInfo_List_zh.xls";
    private static final String BEGIN_TEMPLATE_HOSTINFO_EN = "HostInfo_List_en.xls";
    private static final String NEW_TEMPLATE_COMMAND_FILE_NAME_ZH = "Command_List_zh.xls";
    private static final String NEW_TEMPLATE_COMMAND_FILE_NAME_EN = "Command_List_en.xls";
    private static final String COMMAND_FILE_DEPLOY_NAME_ZH = "DeployCommand_List_zh.xls";
    private static final String COMMAND_FILE_DEPLOY_NAME_EN = "DeployCommand_List_en.xls";
    private static final String TEMPLATE_COMMAND_FILE_FOR_DEPLOY_NAME = "Deploy_Command_List.xls";
    private static final long serialVersionUID = 1L;
    private static final String IMPORT_TEMPLATE_FILE = "device";
    private static final String COMMAND_LIST = "commandlist";
    private static final String SAVEPATH_DEFAULT_ID = "Import_saveresult_path";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DownLoadAction.class);
    private final Window parent;
    private final String type;

    public DownLoadAction(Window parent, String type) {
        this.parent = parent;
        this.type = type;
    }

    private boolean savaTemplate2Local() {
        String defaultFileName;
        String title;
        if (this.type.equalsIgnoreCase(IMPORT_TEMPLATE_FILE)) {
            title = ResourceUtil.getString((String)"infograb.layout.device.downloadtemplate.path");
            defaultFileName = TEMPLATE_FILE_NAME;
        } else if (this.type.equalsIgnoreCase("hostinfo")) {
            title = ResourceUtil.getString((String)"infograb.hostmultipath.hostinfo.save.path");
            defaultFileName = TEMPLATE_COMMAND_HOSTINFO;
        } else if (this.type.equalsIgnoreCase("deployCommandlist")) {
            title = ResourceUtil.getString((String)"infograb.layout.device.downloadcommandlist.path");
            defaultFileName = TEMPLATE_COMMAND_FILE_FOR_DEPLOY_NAME;
            GrabContext.getInstance().setGetCommandList(1);
        } else {
            title = ResourceUtil.getString((String)"infograb.layout.device.downloadcommandlist.path");
            defaultFileName = TEMPLATE_COMMAND_FILE_NAME;
            GrabContext.getInstance().setGetCommandList(1);
        }
        String suffix = "xls";
        String filePath = ToolFileChooser.getSaveFilePath(title, suffix, this.parent, defaultFileName, SAVEPATH_DEFAULT_ID);
        if (null == filePath) {
            return false;
        }
        return this.writeTemplateFile2Local(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeTemplateFile2Local(String filePath) {
        block10: {
            boolean bl;
            InputStream ins = this.selectMould();
            FileOutputStream outs = null;
            try {
                int size;
                if (null == ins) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.templatefile.not.found"));
                    LOGGER.info("Can not find Template file");
                    boolean bl2 = false;
                    return bl2;
                }
                if (!FileUtils.isDiskSpaceFull((String)filePath, (InputStream)ins)) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.save.error"));
                    boolean bl3 = false;
                    StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
                    return bl3;
                }
                outs = new FileOutputStream(new File(filePath));
                byte[] b = new byte[1024];
                while ((size = ins.read(b, 0, 1024)) != -1) {
                    ((OutputStream)outs).write(b, 0, size);
                }
                bl = true;
                StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(DownLoadAction.class).error("Save template file error.");
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.save.error"));
                break block10;
            }
            finally {
                StreamUtils.closeStream(outs, (InputStream)ins);
            }
            return bl;
        }
        return false;
    }

    private InputStream selectMould() {
        InputStream ins;
        Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
        boolean isChineseLocalo = Locale.SIMPLIFIED_CHINESE.equals(locale);
        switch (this.type.toLowerCase(Locale.ENGLISH)) {
            case "device": {
                ins = DevInfoXlsParser.getTemplateFile();
                break;
            }
            case "hostinfo": {
                String templateFileName = Boolean.valueOf(isChineseLocalo).equals(true) ? BEGIN_TEMPLATE_HOSTINFO_ZH : BEGIN_TEMPLATE_HOSTINFO_EN;
                ins = DownLoadAction.class.getResourceAsStream(TEMPLATE_FILE_PATH + templateFileName);
                break;
            }
            case "deploycommandlist": {
                String templateFileName = Boolean.valueOf(isChineseLocalo).equals(true) ? COMMAND_FILE_DEPLOY_NAME_ZH : COMMAND_FILE_DEPLOY_NAME_EN;
                ins = DownLoadAction.class.getResourceAsStream(TEMPLATE_FILE_PATH + templateFileName);
                break;
            }
            default: {
                String templateFileName = Boolean.valueOf(isChineseLocalo).equals(true) ? NEW_TEMPLATE_COMMAND_FILE_NAME_ZH : NEW_TEMPLATE_COMMAND_FILE_NAME_EN;
                ins = DownLoadAction.class.getResourceAsStream(TEMPLATE_FILE_PATH + templateFileName);
            }
        }
        return ins;
    }

    @Override
    public void clickLink(MouseEvent e) {
        boolean result = this.savaTemplate2Local();
        if (result) {
            LOGGER.info("file save success");
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.save.success"));
            this.logSuccess();
        } else {
            this.logFail();
        }
        if (this.type.equalsIgnoreCase(IMPORT_TEMPLATE_FILE)) {
            LogUtils.addImportLog((String)"infograb.layout.device.import.downloadtemplate", (String)"Smartkit", (boolean)result);
        } else {
            LogUtils.addImportLog((String)"infograb.layout.device.import.downloadcommandlist", (String)"Smartkit", (boolean)result);
        }
    }

    private void logFail() {
        if (this.isTemplate()) {
            OperationEnum.GET_IMPORT_TEMPLATE.failLog("");
            return;
        }
        if (this.isHostCommand()) {
            OperationEnum.GET_DEVICE_COMMAND_LIST.failLog("");
        }
    }

    private void logSuccess() {
        if (this.isTemplate()) {
            OperationEnum.GET_IMPORT_TEMPLATE.successLog("");
            return;
        }
        if (this.isHostCommand()) {
            OperationEnum.GET_DEVICE_COMMAND_LIST.successLog("");
        }
    }

    private boolean isHostCommand() {
        return COMMAND_LIST.equalsIgnoreCase(this.type);
    }

    private boolean isTemplate() {
        return IMPORT_TEMPLATE_FILE.equalsIgnoreCase(this.type);
    }
}

