/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrameLayout;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.SwingUtilities;

public class ExploreButtonAction
implements ActionListener {
    private InfoGrabMainFrameLayout layout;

    public ExploreButtonAction(InfoGrabMainFrameLayout layout) {
        this.layout = layout;
    }

    private boolean checkRootDir(Object infoGrabDir) {
        boolean rootDirisOK = true;
        String rootDir = infoGrabDir.toString().substring(0, 2);
        File[] roots = File.listRoots();
        if (null != roots) {
            int rootDirNum = roots.length;
            int flag = 0;
            for (File root : roots) {
                if (root.toString().contains(rootDir)) continue;
                ++flag;
            }
            if (flag == rootDirNum) {
                rootDirisOK = false;
            }
        }
        return rootDirisOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String infoGrabDir = InfoGrabDirPropertiesUtil.getProperty();
        if (null != infoGrabDir && !this.checkRootDir(infoGrabDir)) {
            DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString((String)"report.dir.not.exit"));
            OperationEnum.VIEW_REPORT.failLog("");
            return;
        }
        String taskDir = InfoGrabService.getInstance().getSelectDevNodeReportDir();
        this.layout.getViewReportBtn().setEnabled(false);
        if (null != infoGrabDir && !"".equals(infoGrabDir)) {
            if (!"".equals(taskDir)) {
                if (infoGrabDir.toString().endsWith(File.separator)) {
                    ToolUtils.exeExportSelectFile(infoGrabDir.toString() + taskDir, false);
                } else {
                    ToolUtils.exeExportSelectFile(infoGrabDir.toString() + File.separator + taskDir, false);
                }
            } else {
                ToolUtils.exeExportSelectFile(infoGrabDir.toString(), false);
            }
        } else {
            ToolUtils.exeExportSelectFile(System.getProperty("user.dir"), false);
        }
        OperationEnum.VIEW_REPORT.successLog("");
        SwingUtilities.invokeLater(new ReEnableViewBtnTask(this.layout));
    }

    private static final class ReEnableViewBtnTask
    implements Runnable {
        private InfoGrabMainFrameLayout layout;

        public ReEnableViewBtnTask(InfoGrabMainFrameLayout layout) {
            this.layout = layout;
        }

        @Override
        public void run() {
            ConnUtils.sleep(1000);
            this.layout.getViewReportBtn().setEnabled(true);
        }
    }
}

