/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.InfoGrabUserOpData;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrame;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.tool.infograb.utils.SceneEnvironmentImpl;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.SmartIdcUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrabMainWindowListener
extends WindowAdapter
implements KeyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrabMainWindowListener.class);

    public GrabMainWindowListener() {
        LoggerFactory.getLogger(this.getClass()).info("Information Collection start.");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.action();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.action();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void action() {
        String closeRemind;
        InfoGrabMainFrame parent = GrabContext.getInstance().getCurrInfoGrabFrame();
        WarningDialog dialog = DialogUtils.showYesNoDialog((Window)parent, (String)(closeRemind = GrabContext.isGrabzip != false ? ResourceUtil.getString((String)"infoGrab.remind.close") : ResourceUtil.getString((String)"infoGrab.remind.close.zip")));
        if (0 == dialog.getValue()) {
            try {
                GrabEngine.getInstance().clear();
                GrabContext.getInstance().getCurrInfoGrabFrame().dispose();
                SmartIdcUtil.INSTANCE.stopServer();
                if (!SceneEnvironmentImpl.getInstance().isScene()) return;
                ((RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).saveData2Scene();
                LOGGER.info("Successed to write data to scenedata.xml");
                SceneEnvironmentImpl.getInstance().finishedSceneTask(GrabContext.getInstance().getResultList());
                return;
            }
            catch (ToolException e) {
                LOGGER.error("exit program error.");
                return;
            }
            finally {
                this.saveUserOpData();
                LOGGER.info("exit program.");
                OperationEnum.CLOSE_TOOL.successLog("");
                ToolUtils.exitSystem();
            }
        } else {
            GrabContext.getInstance().getCurrInfoGrabFrame().setDefaultCloseOperation(0);
        }
    }

    private void saveUserOpData() {
        GrabContext instance = GrabContext.getInstance();
        List<InfoGrabUserOpData> userList = instance.getInfoGrabUserOpDatas();
        for (InfoGrabUserOpData infoGrabUserOpData : userList) {
            infoGrabUserOpData.setClickPreviewReport(instance.getClickPreviewReport());
            infoGrabUserOpData.setGetCommandList(instance.getGetCommandList());
            infoGrabUserOpData.setOpenHelpFile(String.valueOf(instance.getClickHelpDocument()));
            infoGrabUserOpData.setScriptGrab(instance.getScriptGrab());
        }
        UserOpDataSaveUtil.batchSaveUserOpdata(userList);
    }
}

