/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.PatchUtil;
import com.huawei.ism.tool.base.utils.RSAUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SHA256Check;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.infograb.entity.ExtendedCommandEntity;
import com.huawei.ism.tool.infograb.entity.ExtendedCommandImportResult;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExtendedCommandTask
implements Callable<ExtendedCommandImportResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportExtendedCommandTask.class);
    private static final int COLUMN_DEVICE_TYPE_INDEX = 0;
    private static final int COLUMN_COMMAND_INDEX = 1;
    private static final int COLUMN_PARAM_TYPE_INDEX = 2;
    private static final int COLUMN_PARAM_VALUE_INDEX = 3;
    private static final int ERROR_INDEX = -1;
    private static final int MAX_EFFECTIVE_ROW_COUNT = 256;
    private static final String PARAM_FLAG = "%param%";
    private static final String ALL_DEVICE_TYPE = "Linux,AIX,HP-UX,Solaris,VMware,Windows,FusionSphere,XenServer,Oracle_SSH,Oracle_JDBC,MySQL,SQLServer,DB2,Brocade,Cisco,EMC,HP";
    private static final String ALL_PARAM_TYPE = "1,2,3";
    private static final String PARAM_TYPE_RANGE = "1";
    private static final String PARAM_TYPE_LIST = "2";
    private static final String PARAM_TYPE_NONE = "3";
    private static final String SEPERATE_FOR_LIST = ",";
    private static final String SEPERATE_FOR_RANGE = "-";
    private File signFile;
    private File cmdFile;
    private Map<String, List<String>> extendedCommands = new HashMap<String, List<String>>();
    private List<ExtendedCommandEntity> checkFailedCommands = new ArrayList<ExtendedCommandEntity>();
    private ExtendedCommandImportResult result = new ExtendedCommandImportResult();
    private int effectiveRowCount;

    public ImportExtendedCommandTask(File signFile, File cmdFile) {
        this.signFile = signFile;
        this.cmdFile = cmdFile;
    }

    @Override
    public ExtendedCommandImportResult call() {
        try {
            this.doImport();
        }
        catch (Exception e) {
            LOGGER.error("Failed import extended command", (Throwable)e);
        }
        return this.result;
    }

    private void setPreCheckResult(boolean isSuccess, String failedDesc) {
        this.result.setSuccess(isSuccess);
        this.result.setFailedDesc(failedDesc);
        LOGGER.info("the current result is <{}>", (Object)this.result);
    }

    private void doImport() {
        if (null == this.signFile || null == this.cmdFile) {
            this.setPreCheckResult(false, ResourceUtil.getString((String)"extended.command.collect.dialog.import.failed.no.file"));
            LOGGER.info("not select a extended command file .");
            OperationEnum.EXTENDED_COMMAND_IMPORT.failLog("");
            return;
        }
        if (!this.checkSignFile()) {
            this.setPreCheckResult(false, ResourceUtil.getString((String)"extended.command.collect.dialog.import.failed.sign"));
            LOGGER.info("check with sign file failed .");
            OperationEnum.EXTENDED_COMMAND_IMPORT.failLog("");
            return;
        }
        if (!this.parseExcel(this.cmdFile)) {
            this.setPreCheckResult(false, ResourceUtil.getString((String)"extended.command.collect.dialog.import.failed.excel"));
            LOGGER.info("read commands from the excel file failed.");
            OperationEnum.EXTENDED_COMMAND_IMPORT.failLog("");
            return;
        }
        OperationEnum.EXTENDED_COMMAND_IMPORT.successLog("");
    }

    private boolean checkSignFile() {
        String shaVerifyCode = StreamUtils.readStringFormFile((File)this.signFile);
        if (StringUtils.isNULLStr((String)shaVerifyCode)) {
            return false;
        }
        PublicKey publicKey = RSAUtils.getPublicKey((String)PatchUtil.importRSAKey());
        String fileHash = "";
        if (null != publicKey) {
            shaVerifyCode = RSAUtils.decrypt((PublicKey)publicKey, (String)shaVerifyCode);
            try {
                fileHash = SHA256Check.getInstance().getHash(this.cmdFile.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("Get cmdFile is error.", (Throwable)e);
            }
        }
        return fileHash.equals(shaVerifyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean parseExcel(File xlsFile) {
        HSSFWorkbook xlsTempWorkbook = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(xlsFile);
            xlsTempWorkbook = new HSSFWorkbook((InputStream)fis);
            Sheet sheet = this.getSheet(xlsTempWorkbook, "command");
            int rows = sheet.getLastRowNum() + 1;
            for (int startRow = 2; startRow < rows; ++startRow) {
                this.readXlsTempItems(sheet, startRow);
            }
            this.setResultWhileFinishParse();
        }
        catch (IOException e) {
            LOGGER.error("create workbook error.");
            boolean bl = false;
            StreamUtils.closeResource(null, (Closeable)xlsTempWorkbook);
            StreamUtils.closeStream(null, (InputStream)fis);
            return bl;
        }
        catch (ToolException e2) {
            LOGGER.error("The specfic sheet does not exist.");
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    StreamUtils.closeResource(null, xlsTempWorkbook);
                    StreamUtils.closeStream(null, (InputStream)fis);
                    throw throwable;
                }
            }
            StreamUtils.closeResource(null, (Closeable)xlsTempWorkbook);
            StreamUtils.closeStream(null, (InputStream)fis);
            return bl;
        }
        StreamUtils.closeResource(null, (Closeable)xlsTempWorkbook);
        StreamUtils.closeStream(null, (InputStream)fis);
        return true;
    }

    private void setResultWhileFinishParse() {
        this.result.setExtendedCommands(this.extendedCommands);
        this.result.setCheckFailedCommands(this.checkFailedCommands);
        if (!this.result.isSuccess()) {
            this.result.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.dialog.import.failed.param"));
            return;
        }
        if (256 < this.effectiveRowCount) {
            this.result.setSuccess(false);
            this.result.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.count.too.much"));
            return;
        }
    }

    private Sheet getSheet(HSSFWorkbook writeWorkbook, String sheetTitle) throws ToolException {
        HSSFSheet sheet = writeWorkbook.getSheet(sheetTitle);
        if (null == sheet) {
            throw new ToolException("The specfic sheet does not exist.");
        }
        return sheet;
    }

    private void readXlsTempItems(Sheet modelSheet, int row) {
        ExtendedCommandEntity commandEntity = new ExtendedCommandEntity();
        Row rowObj = modelSheet.getRow(row);
        String devType = this.getContentFromCell(rowObj, 0);
        commandEntity.setDevType(devType);
        commandEntity.setCommand(this.getContentFromCell(rowObj, 1));
        commandEntity.setParamType(this.getContentFromCell(rowObj, 2));
        commandEntity.setParamValue(this.getContentFromCell(rowObj, 3));
        if (!this.checkCommand(devType, commandEntity)) {
            this.result.setSuccess(false);
            this.checkFailedCommands.add(commandEntity);
            LOGGER.error("command is not correct :" + commandEntity.toString());
            return;
        }
        this.putExtendedCommand2Map(devType, commandEntity);
    }

    private String getContentFromCell(Row rowObj, int columnNum) {
        if (rowObj.getLastCellNum() > columnNum) {
            return POIUtils.getStringCellValue(rowObj.getCell(columnNum));
        }
        return "";
    }

    private boolean checkCommand(String devType, ExtendedCommandEntity commandEntity) {
        String command = commandEntity.getCommand();
        String paramType = commandEntity.getParamType();
        String paramValue = commandEntity.getParamValue();
        if (StringUtils.isNULLStr((String)devType) && StringUtils.isNULLStr((String)command) && StringUtils.isNULLStr((String)paramType) && StringUtils.isNULLStr((String)paramValue)) {
            commandEntity.setEmpty(true);
            return true;
        }
        return this.checkDeviceType(commandEntity, devType) && this.checkCommandStyle(commandEntity, command, paramType) && this.checkParamStyle(commandEntity, paramType) && this.checkParamValue(commandEntity, paramType, paramValue);
    }

    private boolean checkParamValue(ExtendedCommandEntity commandEntity, String paramType, String paramValue) {
        if (!PARAM_TYPE_NONE.equals(paramType) && StringUtils.isNULLStr((String)paramValue)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.no.param.value"));
            return false;
        }
        if (PARAM_TYPE_NONE.equals(paramType) && !StringUtils.isNULLStr((String)paramValue)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.no.param"));
            return false;
        }
        if (PARAM_TYPE_LIST.equals(paramType) && !paramValue.contains(SEPERATE_FOR_LIST) || PARAM_TYPE_RANGE.equals(paramType) && !paramValue.contains(SEPERATE_FOR_RANGE)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.param.range.error"));
            return false;
        }
        if (PARAM_TYPE_RANGE.equals(paramType)) {
            String[] range = paramValue.split(SEPERATE_FOR_RANGE);
            if (2 == range.length && !paramValue.contains(".")) {
                int rangeMin = StringUtils.str2Int((String)range[0]);
                int rangeMax = StringUtils.str2Int((String)range[1]);
                if (-1 != rangeMin && -1 != rangeMax) {
                    return true;
                }
            }
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.param.range.error"));
            return false;
        }
        return true;
    }

    private boolean checkParamStyle(ExtendedCommandEntity commandEntity, String paramType) {
        if (StringUtils.isNULLStr((String)paramType)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.no.param.type"));
            return false;
        }
        if (!ALL_PARAM_TYPE.contains(paramType) || paramType.contains(SEPERATE_FOR_LIST)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.param.type.error"));
            return false;
        }
        return true;
    }

    private boolean checkCommandStyle(ExtendedCommandEntity commandEntity, String command, String paramType) {
        if (StringUtils.isNULLStr((String)command)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.null"));
            return false;
        }
        if (!(StringUtils.isNULLStr((String)paramType) || PARAM_TYPE_NONE.equals(paramType) || command.contains(PARAM_FLAG))) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.command.pt.not.match"));
            return false;
        }
        return true;
    }

    private boolean checkDeviceType(ExtendedCommandEntity commandEntity, String devType) {
        if (StringUtils.isNULLStr((String)devType)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.device.type.null"));
            return false;
        }
        if (!ALL_DEVICE_TYPE.contains(devType) || devType.contains(SEPERATE_FOR_LIST)) {
            commandEntity.setFailedDesc(ResourceUtil.getString((String)"extended.command.collect.import.error.device.type.error"));
            return false;
        }
        return true;
    }

    private void putExtendedCommand2Map(String devType, ExtendedCommandEntity commandEntity) {
        if (commandEntity.isEmpty()) {
            return;
        }
        List<String> oneTypeCommand = this.extendedCommands.get(devType);
        if (null == oneTypeCommand) {
            oneTypeCommand = new ArrayList<String>();
        }
        oneTypeCommand.addAll(this.translate2standardCommands(commandEntity));
        this.extendedCommands.put(devType, oneTypeCommand);
        ++this.effectiveRowCount;
    }

    private List<String> translate2standardCommands(ExtendedCommandEntity commandEntity) {
        ArrayList<String> standardCommands = new ArrayList<String>();
        String command = commandEntity.getCommand();
        String paramVaule = commandEntity.getParamValue();
        String paramType = commandEntity.getParamType();
        if (StringUtils.isNULLStr((String)paramVaule)) {
            standardCommands.add(command);
        } else if (PARAM_TYPE_LIST.equals(paramType)) {
            String[] params;
            for (String param : params = paramVaule.split(SEPERATE_FOR_LIST)) {
                standardCommands.add(command.replace(PARAM_FLAG, param));
            }
        } else {
            String[] paramRange = paramVaule.split(SEPERATE_FOR_RANGE);
            int rangeLeft = StringUtils.str2Int((String)paramRange[0]);
            int rangeRight = StringUtils.str2Int((String)paramRange[1]);
            int increaseSize = 1;
            if (rangeLeft > rangeRight) {
                increaseSize = -1;
            }
            while (rangeLeft != rangeRight + increaseSize) {
                standardCommands.add(command.replace(PARAM_FLAG, String.valueOf(rangeLeft)));
                rangeLeft += increaseSize;
            }
        }
        return standardCommands;
    }

    public Map<String, List<String>> getExtendedCommands() {
        return this.extendedCommands;
    }

    public List<ExtendedCommandEntity> getCheckFailedCommands() {
        return this.checkFailedCommands;
    }
}

