/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.ui.ErrorDetailInfoDialog;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListMouseAdapter
extends MouseAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListMouseAdapter.class);

    @Override
    public void mouseClicked(MouseEvent event) {
        RealTimeTaskDetailContainer mainDialog = (RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer();
        if (SwingUtilities.isRightMouseButton(event) || event.getClickCount() > 1) {
            LOGGER.info("you click error, please click left mouse button");
            return;
        }
        GrabDevNode2 devNode = mainDialog.getCurrentChosenDevNode();
        int index = mainDialog.getListIndex(event.getPoint(), mainDialog.getDetailList());
        if (null == devNode || -1 == index) {
            return;
        }
        List<ExecuteResult> execResultList = GrabContext.getInstance().getExecuteResultMap().get((Object)devNode);
        if (null != execResultList && execResultList.size() > index) {
            ExecuteResult rec = execResultList.get(index);
            ErrorDetailInfoDialog detailDialog = new ErrorDetailInfoDialog((String)rec.getResultMap().get("err_msg"), GrabContext.getInstance().getCurrInfoGrabFrame());
            detailDialog.setVisible(true);
        }
    }
}

