/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.action;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.grab.GrabThread;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskPanel;
import com.huawei.ism.tool.infograb.ui.action.CollectDeviceAction;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopCollectAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopCollectAction.class);
    private InfoGrabService grabService = InfoGrabService.getInstance();
    private ProgressDialog busywaitDialog = null;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.busywaitDialog = new CustMsgProgressDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), ResourceUtil.getString((String)"infograb.remind.waitforstopcollect"), 415);
        new Thread(new Runnable(){

            @Override
            public void run() {
                StopCollectAction.this.doEndGrabThread();
            }
        }, "stopGrabThread").start();
    }

    private void doEndGrabThread() {
        List<GrabDevNode2> currSelectedNodes = ((RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).getSelectedDevNode();
        if (this.checkSelectNodesInvalid(currSelectedNodes)) {
            OperationEnum.STOP_COLLECT.failLog("");
            return;
        }
        Map<GrabDevNode2, GrabThread> currThreadMap = GrabEngine.getInstance().getCurrThreadMap();
        ArrayList<GrabThread> grabThreads = new ArrayList<GrabThread>();
        RealTimeTask task = (RealTimeTask)GrabContext.getInstance().getCurrentTask().getTask();
        if (task.getTaskCurruentProcess() != task.getTaskMaxProcess()) {
            JLabel taskStatus = ((RealTimeTaskPanel)GrabContext.getInstance().getCurrentTask()).getTaskStatus();
            taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.part_not_collect"));
            taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
            GrabContext.getInstance().getCurrentTask().repaint();
        }
        this.setTaskStopped(currSelectedNodes, currThreadMap, grabThreads);
        this.hideBusywaitDialog();
        this.refreshFrameUI(currSelectedNodes);
    }

    private boolean checkSelectNodesInvalid(List<GrabDevNode2> currSelectedNodes) {
        if (currSelectedNodes.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.no.selected.devnode"));
            LOGGER.info("The device is not selected, can not be terminated");
            return true;
        }
        if (this.checkDevNodeStatus(currSelectedNodes)) {
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.isendgrabinfo"));
            if (1 == warningDialog.getValue() || -1 == warningDialog.getValue()) {
                LOGGER.info("you cancal end grabinfo");
                return true;
            }
        } else {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.nohavegrabrunning"));
            LOGGER.info("The selected device is not running, can not be terminated!");
            return true;
        }
        if (this.checkCollectionThreadStatus()) {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.waitcollectionstart"));
            LOGGER.info("starting collection function,please wait");
            return true;
        }
        if (!GrabUtil.checkAtLeastOneNode(currSelectedNodes)) {
            LOGGER.info("Not select an devNode");
            return true;
        }
        return false;
    }

    private void checkNodesStoped(List<GrabDevNode2> currSelectedNodes) {
        this.showDialogInDispatchThread();
        LOGGER.info("start check task running status by stop task.");
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("stop buzywaitDialog failed..");
            }
        } while (!this.allChoosedDevStoped(currSelectedNodes));
        LOGGER.info("all task has stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTaskStopped(List<GrabDevNode2> currSelectedNodes, Map<GrabDevNode2, GrabThread> currThreadMap, List<GrabThread> grabThreads) {
        for (GrabDevNode2 devNode : currSelectedNodes) {
            GrabThread currThread = currThreadMap.get((Object)devNode);
            if (null == currThread) continue;
            grabThreads.add(currThread);
            currThread.setStop(true);
            OperationEnum.STOP_COLLECT.successLogWithResources(devNode.getIp(), devNode.getDeviceName());
        }
        this.checkNodesStoped(currSelectedNodes);
        Object object = GrabEngine.BLOCKING_QUEUE_LOCK;
        synchronized (object) {
            GrabEngine.getInstance().getLbkqBlockingQueue().removeAll(grabThreads);
        }
    }

    private void showDialogInDispatchThread() {
        SwingUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (StopCollectAction.this.busywaitDialog != null) {
                    StopCollectAction.this.busywaitDialog.setVisible(true);
                }
            }
        });
    }

    private boolean allChoosedDevStoped(List<GrabDevNode2> currSelectedNodes) {
        int i = 0;
        for (GrabDevNode2 devNode : currSelectedNodes) {
            if (InfoGrabService.getInstance().findNodeStatus(devNode).booleanValue() && !devNode.isCollectStop() && !devNode.isCollectDone()) continue;
            ++i;
        }
        return i == currSelectedNodes.size();
    }

    private void hideBusywaitDialog() {
        if (this.busywaitDialog != null) {
            this.busywaitDialog.setVisible(false);
            this.busywaitDialog.dispose();
            this.busywaitDialog = null;
        }
    }

    private boolean checkDevNodeStatus(List<GrabDevNode2> currSelectedNodes) {
        for (GrabDevNode2 devNode2 : currSelectedNodes) {
            if (!this.grabService.findNodeStatus(devNode2).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void refreshFrameUI(List<GrabDevNode2> currSelectedNodes) {
        for (GrabDevNode2 devNode2 : currSelectedNodes) {
            if (this.grabService.findNodeStatus(devNode2).booleanValue()) {
                ((RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).refreshStopStatus(devNode2);
            }
            this.grabService.setNodesStopped(devNode2);
        }
    }

    private boolean checkCollectionThreadStatus() {
        Thread grabThread;
        CollectDeviceAction collectDeviceAction = ((RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).getCollectDeviceAction();
        return null != collectDeviceAction && null != (grabThread = collectDeviceAction.getCollectionThread()) && Thread.State.RUNNABLE == grabThread.getState();
    }
}

