/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.render;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.context.ItemResultEnum;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.ui.render.ProgressBar;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ItemListCellRender
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 401434561456821436L;
    private static final Dimension DATE_LABLE_SIZE = new Dimension(160, 20);
    private static final Dimension SCRIPT_LABEL_SIZE = new Dimension(300, 20);

    @Override
    public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean flag, boolean cellHasFocus) {
        ExecuteResult result = null;
        Color bg = null;
        boolean isSelected = flag;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isSelected = true;
        }
        JPanel viewPan = new JPanel();
        if (value instanceof ExecuteResult) {
            result = (ExecuteResult)value;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JComponent view = this.getjComponent(result, format);
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "North");
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        if (isSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty("setForeground", new Object[]{Color.WHITE}, viewPan);
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    JComponent getjComponent(ExecuteResult result, SimpleDateFormat format) {
        JComponent view;
        if (null != result) {
            GrabDevNode2 dev = result.getDevNode();
            JLabel nameLabel = new JLabel();
            nameLabel.setText(ResourceUtil.getString((String)result.getDescription()));
            nameLabel.setPreferredSize(SCRIPT_LABEL_SIZE);
            JLabel dataLabel = new JLabel(format.format(result.getExecuteStartTime()));
            JLabel statusLabel = this.getStatusLabel(result);
            dataLabel.setPreferredSize(DATE_LABLE_SIZE);
            JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), dataLabel});
            view = this.checkBuildBoxLeft(result, dev, nameLabel, statusLabel, dateComp);
        } else {
            Date date = Calendar.getInstance().getTime();
            String dateStr = format.format(date);
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{new JLabel(dateStr), Box.createHorizontalStrut(12), new JLabel(ResourceUtil.getString((String)"infograb.cell.render.errormsg")), Box.createHorizontalStrut(12)});
        }
        return view;
    }

    private JComponent checkBuildBoxLeft(ExecuteResult result, GrabDevNode2 dev, JLabel nameLabel, JLabel statusLabel, JComponent dateComp) {
        JComponent view = result.isShowProgress() ? new ProgressBar(null, result.getCurItemProgress(), dateComp, Box.createHorizontalStrut(12), new JLabel(dev.getIp().trim()), Box.createHorizontalStrut(12), nameLabel, Box.createHorizontalStrut(32), UCD.buildHBoxLeft((Component[])new Component[]{statusLabel, Box.createHorizontalStrut(5)})) : UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, Box.createHorizontalStrut(12), new JLabel(dev.getIp().trim()), Box.createHorizontalStrut(12), nameLabel, Box.createHorizontalStrut(32), UCD.buildHBoxLeft((Component[])new Component[]{statusLabel, Box.createHorizontalStrut(5)})});
        return view;
    }

    private JLabel getStatusLabel(ExecuteResult result) {
        ItemResultEnum itemResultEnum = result.getItemResultEnum();
        JLabel statusLabel = new JLabel(itemResultEnum.getResultDesc());
        if (result.isCureItemCollecting()) {
            String text = this.prepareLabelTips(result);
            statusLabel.setText(text);
            ImageIcon icon = ResourceUtil.getImage((String)"loading.gif");
            statusLabel.setIcon(icon);
            icon.setImageObserver(GrabContext.getInstance().getCurrInfoGrabFrame());
            return statusLabel;
        }
        switch (itemResultEnum) {
            case NOCHECK: {
                if (result.isPrepareItem()) {
                    statusLabel.setText(ResourceUtil.getString((String)"infograb.cpu.or.io.check.result.failed.txt"));
                }
                statusLabel.setIcon(GrabContext.FAILED_IMAGE);
                break;
            }
            case FAILD: {
                statusLabel.setIcon(GrabContext.FAILED_IMAGE);
                break;
            }
            case PARTIALSUCC: 
            case NOTCOLLECT: 
            case CHECK_ENDED: 
            case STOPED: {
                statusLabel.setIcon(GrabContext.SUCCESS_NOTALL_IMAGE);
                break;
            }
            default: {
                statusLabel.setIcon(GrabContext.SUCCESS_IMAGE);
            }
        }
        return statusLabel;
    }

    public String prepareLabelTips(ExecuteResult result) {
        String text;
        if (result.isProcessItem()) {
            text = ResourceUtil.getString((String)"infograb.dev.status.Processing");
            text = text + (result.isShowProgress() ? "    " + result.getCurItemProgress() + "%" : "");
        } else if (result.isPrepareItem()) {
            text = ResourceUtil.getString((String)"infograb.detail.preparechecking");
        } else {
            text = ResourceUtil.getString((String)"infograb.dev.status.collecting");
            text = text + (result.isShowProgress() ? "    " + result.getCurItemProgress() + "%" : "");
        }
        return text;
    }
}

