/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Box;

public class ProgressBar
extends Box {
    private static final Color DEFAULT = new Color(125, 173, 225);
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private static final int MAX = 100;
    private int progress = 0;
    private Color color = DEFAULT;

    public ProgressBar(Color color, int progress, Component ... components) {
        super(0);
        this.color = color == null ? DEFAULT : color;
        this.progress = ProgressBar.getValidProgress(progress);
        this.addComs(components);
    }

    @Override
    public void paintComponent(Graphics gra) {
        super.paintComponent(gra);
        if (this.progress != 0) {
            gra.setColor(this.color);
            gra.fillRect(0, 0, this.getWidth() * this.progress / 100, this.getHeight());
            gra.setColor(Color.GRAY);
            if (gra instanceof Graphics2D) {
                ((Graphics2D)gra).setStroke(STROKE);
                ((Graphics2D)gra).drawRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private void addComs(Component ... components) {
        if (null == components || components.length == 0) {
            return;
        }
        this.add(components[0]);
        for (int index = 1; index < components.length; ++index) {
            this.add(Box.createHorizontalStrut(12));
            this.add(components[index]);
        }
    }

    public static int getValidProgress(int progress) {
        return Math.min(100, Math.max(0, progress));
    }
}

