/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.support;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.IntegrateGrabSetupDialog;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSelectionListener
implements TreeSelectionListener,
ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceSelectionListener.class);
    private IntegrateGrabSetupDialog dialog = null;
    private GrabDevNode2 currentDevNode = null;

    public DeviceSelectionListener(IntegrateGrabSetupDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.currentDevNode == null) {
            this.currentDevNode = this.dialog.getDeviceNode();
        }
        if (!this.isAtLeastOneItem()) {
            return;
        }
        this.saveCurrentCollectItem();
        this.enableChangeItems();
        this.applySendModeToSelectDevice();
        OperationEnum.MODIFY_COLLECT_SETTING.successLogWithResources(this.currentDevNode.getIp(), this.currentDevNode.getDeviceName());
        LOGGER.info("Dispose dialog:{}", (Object)this.dialog);
        this.dialog.dispose();
    }

    private void enableChangeItems() {
        GrabFlowAdapter currAdapter = GrabFlowAdapter.getInstance();
        List<Item> items = this.dialog.parseChooseCollectItem();
        List<String> categories = this.dialog.parseChooseCategory();
        currAdapter.getNodeGrabFlowMap().put(this.currentDevNode, items);
        currAdapter.getNodeSelectedCategoryMap().put(this.currentDevNode, categories);
    }

    private void applySendModeToSelectDevice() {
        if (this.dialog.getDevChooseDialog() == null) {
            return;
        }
        InfoGrabService service = InfoGrabService.getInstance();
        List<GrabDevNode2> devNodes = this.dialog.getDevChooseDialog().getSelectDevNode();
        for (GrabDevNode2 current : devNodes) {
            service.copyItemDcnToAnother(this.currentDevNode, current);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (this.dialog.getIntegrateXMLFile().isEmpty()) {
            CheckTreeNode lastCheckTreeNode = this.getOldTreeNode(event);
            lastCheckTreeNode.setSelected(false);
            lastCheckTreeNode.setHilight(false);
            if (this.currentDevNode == null) {
                this.currentDevNode = this.dialog.getDeviceNode();
            }
            if (lastCheckTreeNode == this.dialog.getCollectlayout().getDeviceRootNode()) {
                LOGGER.info("Last choose is root node...");
            } else {
                this.saveCurrentCollectItem();
            }
            CheckTreeNode newTreeNode = this.getNewTreeNode(event);
            if (newTreeNode != this.dialog.getCollectlayout().getDeviceRootNode()) {
                String ip = newTreeNode.getUserObject().toString();
                this.currentDevNode = this.getDevNodebyIP(ip);
                if (null != this.currentDevNode) {
                    this.dialog.initCollectItemTree(this.currentDevNode);
                    this.dialog.initCollectConfInfoItem(this.dialog.getAllCollectItems().get((Object)this.currentDevNode));
                }
            }
            this.dialog.repaint();
        }
    }

    private void saveCurrentCollectItem() {
        List<Item> items = this.dialog.parseChooseCollectItem();
        this.dialog.getAllCollectItems().put(this.currentDevNode, items);
    }

    private boolean isAtLeastOneItem() {
        if (this.dialog.parseChooseCollectItem().isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infograb.option.error.checkoneitem"));
            return false;
        }
        return true;
    }

    private GrabDevNode2 getDevNodebyIP(String ip) {
        for (GrabDevNode2 devNode : this.dialog.getDevNodes()) {
            if (!devNode.getIp().equals(ip)) continue;
            return devNode;
        }
        return null;
    }

    private CheckTreeNode getOldTreeNode(TreeSelectionEvent event) {
        TreePath treePath = event.getOldLeadSelectionPath();
        if (treePath == null) {
            return (CheckTreeNode)this.dialog.getCollectlayout().getDeviceRootNode().getFirstChild();
        }
        return (CheckTreeNode)treePath.getLastPathComponent();
    }

    private CheckTreeNode getNewTreeNode(TreeSelectionEvent event) {
        return (CheckTreeNode)event.getNewLeadSelectionPath().getLastPathComponent();
    }
}

