/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui.support;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.base.IDetailContainer;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabSetupDialog;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskDetailContainer;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.IntegrateGrabSetupDialog;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSetupIcon
extends IsmTableCell.IconCell {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceSetupIcon.class);
    private static final long serialVersionUID = 1L;
    private final Object lock = new Object();
    private transient GrabDevNode2 device = null;
    private IDetailContainer parent = null;
    private String integrateXml = "";

    public DeviceSetupIcon(GrabDevNode2 node, IDetailContainer parent) {
        super((Icon)GrabContext.SETTING_IMAGE, ResourceUtil.getString((String)"infograb.setup"));
        this.device = node;
        this.parent = parent;
    }

    private void action() {
        this.parent.refurbishDetailList();
        InfoGrabService service = InfoGrabService.getInstance();
        if (service.isDevNodeCollecting(this.device).booleanValue()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the device is busy where IP is: " + this.device.getIp());
            }
            DialogUtils.showErrorDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.itemiscollecting"));
            return;
        }
        if (this.parent instanceof RealTimeTaskDetailContainer) {
            IntegrateGrabSetupDialog.showCollectSetupDialog(GrabContext.getInstance().getCurrInfoGrabFrame(), this.device, this.getIntegrateXml());
        } else if (this.parent instanceof PeriodGrabTaskDetailContainer) {
            PeriodGrabTaskDetailContainer taskDetailContainer = (PeriodGrabTaskDetailContainer)this.parent;
            new PeriodGrabSetupDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), taskDetailContainer, this.device).setVisible(true);
        }
    }

    public ActionListener getAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSetupIcon.this.action();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrateXml(String integrateXml) {
        Object object = this.lock;
        synchronized (object) {
            this.integrateXml = integrateXml;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIntegrateXml() {
        Object object = this.lock;
        synchronized (object) {
            return this.integrateXml;
        }
    }
}

