/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.cert.auth.AbstractAuthStep;
import com.huawei.ism.tool.cert.auth.RestAuthStep;
import com.huawei.ism.tool.infograb.utils.migration.SmartIdcUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.NetUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(CertCheckUtil.class);

    public static int checkDevCert(DevNode devNode) {
        return new CertCheckTask(devNode).check();
    }

    public static class InfoGrabRestAuthStep
    extends RestAuthStep {
        public InfoGrabRestAuthStep(DevNode devNode, int port) {
            super(devNode, port);
            this.addCertList(SmartIdcUtil.getIdcCert().toString());
        }
    }

    private static class SingleCertChecker
    implements Callable<Integer> {
        private final AbstractAuthStep authStep;

        @Override
        public Integer call() {
            if (this.authStep == null) {
                return -2;
            }
            if (!NetUtil.isHostConnectable(this.authStep.getIp(), this.authStep.getPort())) {
                log.info("Host not reachable in 2 seconds:{} port:{}", (Object)this.authStep.getIp(), (Object)this.authStep.getPort());
                return -2;
            }
            return this.authStep.process();
        }

        public SingleCertChecker(AbstractAuthStep authStep) {
            this.authStep = authStep;
        }
    }

    private static class CertCheckTask {
        private final DevNode devNode;

        public int check() {
            try {
                Future certCheckFuture = AsyncExcutor.submit((Callable)new SingleCertChecker(new InfoGrabRestAuthStep(this.devNode, this.devNode.getPort())));
                return (Integer)certCheckFuture.get(15L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                log.error("Check error ", (Throwable)e);
                return -1;
            }
        }

        public CertCheckTask(DevNode devNode) {
            this.devNode = devNode;
        }
    }
}

