/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import java.util.Objects;

public class DeviceModelChecker {
    public static boolean isGrabByRest(String deviceModel) {
        return "Vplex".equalsIgnoreCase(deviceModel) || "Unity".equalsIgnoreCase(deviceModel);
    }

    public static boolean isGrabBySsh(DevNode devNode) {
        return DeviceModelChecker.isHostDeviceBySsh(devNode) || DeviceModelChecker.isSwitchDevice(devNode) || DeviceModelChecker.isStorageDeviceBySsh(devNode);
    }

    private static boolean isStorageDeviceBySsh(DevNode devNode) {
        return DeviceType.valueOf("HP").equals(devNode.getDevTypeLevel2()) || "Isilon".equals(devNode.getDeviceModel()) || DeviceType.valueOf("IBM").equals(devNode.getDevTypeLevel2()) || DeviceType.valueOf("Huawei").equals(devNode.getDevTypeLevel2()) || "FAS".equals(devNode.getDeviceModel()) || DeviceType.valueOf("Fujistu").equals(devNode.getDevTypeLevel2()) || DeviceType.valueOf("PureStorage").equals(devNode.getDevTypeLevel2());
    }

    public static boolean isUseDefaultRestPort(String deviceModel) {
        return "Vplex".equalsIgnoreCase(deviceModel) || "Unity".equalsIgnoreCase(deviceModel);
    }

    public static boolean isNetAppDevice(String deviceModel) {
        return "C-MODE".equals(deviceModel) || "7-MODE".equals(deviceModel);
    }

    public static boolean isHuaweiDevice(String deviceModel) {
        return "OceanStor_V3/V5".equals(deviceModel) || "OceanStor_9000".equals(deviceModel);
    }

    public static boolean isIsilonDevice(String deviceModel) {
        return "Isilon".equals(deviceModel);
    }

    private static boolean isHostDeviceBySsh(DevNode devNode) {
        return ItDeviceType.Host.equals((Object)devNode.getItDeviceType()) && !"Windows".equals(devNode.getDevTypeLevel2().toString());
    }

    private static boolean isSwitchDevice(DevNode devNode) {
        return ItDeviceType.Switch.equals((Object)devNode.getItDeviceType());
    }

    public static boolean isGrabBySmartIdc(DevNode devNode) {
        DeviceType deviceType = devNode.getDevTypeLevel2();
        if (Objects.isNull(deviceType)) {
            return false;
        }
        String deviceTypeString = deviceType.toString();
        return "NetApp".equals(deviceTypeString) && !"FAS".equals(devNode.getDeviceModel()) || "EMC".equalsIgnoreCase(deviceTypeString) && "VMAX".equalsIgnoreCase(devNode.getDeviceModel());
    }

    private DeviceModelChecker() {
    }
}

