/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SHA256Check;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.obase.utils.CommonEncodeDetectUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;

public final class ExportFileUtil {
    public static final String EVAL_META_DATA_DIR_PREFIX = "EvalMetaData";
    public static final String PKG_INFO = "pkginfo";
    public static final String EVAL_CLIREM_KEY_PRIFIX = "_needEvalCmdRtn:";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExportFileUtil.class);
    private static final String DEFAULT_SPLIT = "*********^^^^^^^^^^************^^^^^^^^^^*********";
    private static final String CONFIG = "\\config";
    private String shaFileName = "";
    private File shaFile = null;
    private static ExportFileUtil instance = null;

    private ExportFileUtil() {
    }

    public static ExportFileUtil getInstance() {
        if (null == instance) {
            instance = new ExportFileUtil();
        }
        return instance;
    }

    public static boolean isHost(File file) {
        boolean result = false;
        ArrayList<String> hostTypes = new ArrayList<String>();
        hostTypes.add("linux");
        hostTypes.add("aix");
        hostTypes.add("windows");
        hostTypes.add("vmware");
        hostTypes.add("solaris");
        hostTypes.add("hp-ux");
        hostTypes.add("xenserver");
        hostTypes.add("fusionsphere");
        String devType = file.getName().split("_")[0];
        if (hostTypes.contains(devType.toLowerCase(Locale.ENGLISH))) {
            result = true;
        }
        return result;
    }

    public static boolean isDataBase(File file) {
        boolean result = false;
        ArrayList<String> dbTypes = new ArrayList<String>();
        dbTypes.add("oracle");
        dbTypes.add("mysql");
        dbTypes.add("sqlserver");
        dbTypes.add("db2");
        String devType = file.getName().split("_")[0];
        if (dbTypes.contains(devType.toLowerCase(Locale.ENGLISH))) {
            result = true;
        }
        return result;
    }

    public static boolean isSwitch(File file) {
        boolean result = false;
        ArrayList<String> switchTypes = new ArrayList<String>();
        switchTypes.add("brocade");
        switchTypes.add("cisco");
        String devType = file.getName().split("_")[0];
        if (switchTypes.contains(devType.toLowerCase(Locale.ENGLISH))) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveShaCode(File xlsReportDirFile, RealTimeTask collectTask, List<File> xlsFiles) throws ToolException, IOException {
        String xlsReportDir = xlsReportDirFile.getCanonicalPath();
        String shaDateEnd = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String shaName = "DeviceReportEncryptCode" + shaDateEnd + ".sign";
        String sha256HexCode = SHA256Check.getInstance().getHash(xlsReportDir);
        String sha512HexCode = ExportFileUtil.sha512CheckCode(sha256HexCode);
        String finalEncrypt = ExportFileUtil.mixEncrypt(sha256HexCode, sha512HexCode);
        StringBuffer shaStrBuff = new StringBuffer();
        shaStrBuff.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(shaName);
        this.shaFileName = shaStrBuff.toString();
        this.shaFile = new File(this.shaFileName);
        FileOutputStream fileOutPutStr = null;
        try {
            boolean createResult = this.shaFile.createNewFile();
            if (!createResult) {
                LOGGER.error("create shaFile failed.");
                String string = null;
                return string;
            }
            byte[] bytes = finalEncrypt.getBytes("UTF-8");
            int shaCodeLen = finalEncrypt.length();
            fileOutPutStr = new FileOutputStream(this.shaFile);
            fileOutPutStr.write(bytes, 0, shaCodeLen);
            StreamUtils.closeStream((OutputStream)fileOutPutStr, null);
        }
        catch (IOException e) {
            LOGGER.error("saveShaCode error.");
        }
        finally {
            StreamUtils.closeStream(fileOutPutStr, null);
        }
        return ExportFileUtil.saveReportZip(xlsReportDirFile.getCanonicalPath(), this.shaFile.getCanonicalPath(), collectTask, xlsFiles);
    }

    public static String sha512CheckCode(String message) {
        String result = "";
        try {
            MessageDigest sha512Digest = MessageDigest.getInstance("SHA-512");
            byte[] sha512Encode = sha512Digest.digest(message.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(sha512Encode.length * 2);
            for (int i = 0; i < sha512Encode.length; ++i) {
                String hex = Integer.toHexString(0xFF & sha512Encode[i]);
                if (1 == hex.length()) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            result = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("engypt CheckCode err");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UnsupportedEncoding error");
        }
        return result;
    }

    public static String mixEncrypt(String sha256, String sha512) {
        char[] char256 = sha256.toCharArray();
        char[] char512 = sha512.toCharArray();
        String charVersion = GrabUtil.getVersionShow().trim();
        StringBuffer sb = new StringBuffer();
        int j = 0;
        int k = 0;
        for (int i = 0; i < char256.length + char512.length; ++i) {
            if (0 == i % 3) {
                sb.append(char256[j]);
                ++j;
                continue;
            }
            sb.append(char512[k]);
            ++k;
        }
        sb.append(charVersion);
        return sb.toString();
    }

    public static String saveReportZip(String excelFile, String shFile, RealTimeTask collectTask, List<File> xlsFiles) throws ToolException {
        File dir;
        String taskName = collectTask.getTaskName();
        String taskDirName = collectTask.getTaskDirName();
        String shaDateEnd = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        StringBuffer zipStrBuff = new StringBuffer();
        zipStrBuff.append(InfoGrabDirPropertiesUtil.getProperty());
        if (!StringUtils.isNULLStr(taskDirName)) {
            zipStrBuff.append(File.separator);
            zipStrBuff.append(taskDirName);
        }
        if (!(dir = new File(zipStrBuff.toString())).exists() && !dir.mkdirs()) {
            throw new ToolException("save compatibility report mkdir err :" + dir.getName());
        }
        String zipName = "Eval_" + taskName + "_" + shaDateEnd + ".zip";
        zipStrBuff.append(File.separator);
        zipStrBuff.append(zipName);
        String zipFileName = zipStrBuff.toString();
        ExportFileUtil.createZipPkg(excelFile, shFile, collectTask, xlsFiles, zipFileName);
        return zipStrBuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void createZipPkg(String excelFile, String shFile, RealTimeTask collectTask, List<File> xlsFiles, String zipFileName) {
        block8: {
            ZipOutputStream out = null;
            FileInputStream excelFileIs = null;
            FileInputStream shaFileIs = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(zipFileName);
                out = new ZipOutputStream(fileOutputStream);
                excelFileIs = new FileInputStream(new File(FilePathUtils.checkFile((String)excelFile)));
                out.putNextEntry(new ZipEntry(new File(excelFile).getName()));
                ExportFileUtil.exportZipFile(excelFileIs, out);
                shaFileIs = new FileInputStream(new File(FilePathUtils.checkFile((String)shFile)));
                out.putNextEntry(new ZipEntry(new File(shFile).getName()));
                ExportFileUtil.exportZipFile(shaFileIs, out);
                ExportFileUtil.addCmdFileToZip(out, xlsFiles);
                List<String> taskType = collectTask.getTaskCategory();
                if (null != taskType && taskType.contains(ResourceUtil.getString((String)"infograb.item.category.network.discovery"))) {
                    ExportFileUtil.addPkginfoFileToZip(out);
                }
                StreamUtils.closeStream((OutputStream)out, null);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("saveReportZip, file not found.");
                break block8;
            }
            catch (IOException e2) {
                LOGGER.error("saveReportZip.");
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeStream(out, null);
                StreamUtils.closeStream(null, excelFileIs);
                StreamUtils.closeStream(null, shaFileIs);
                StreamUtils.closeStream((OutputStream)fileOutputStream, null);
                FileUtils.deleteFile((File)new File(excelFile));
                FileUtils.deleteFile((File)new File(shFile));
            }
            StreamUtils.closeStream(null, (InputStream)excelFileIs);
            StreamUtils.closeStream(null, (InputStream)shaFileIs);
            StreamUtils.closeStream((OutputStream)fileOutputStream, null);
            FileUtils.deleteFile((File)new File(excelFile));
            FileUtils.deleteFile((File)new File(shFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCmdFileToZip(ZipOutputStream out, List<File> xlsFiles) throws IOException {
        for (File xlsFile : xlsFiles) {
            String iniaFile = xlsFile.getAbsolutePath().replace(".xls", ".txt");
            String evalFileName = xlsFile.getAbsolutePath().replace(".xls", "_foreEval.txt");
            String zipPath = EVAL_META_DATA_DIR_PREFIX + File.separator + new File(evalFileName).getName();
            String zipIniaPath = EVAL_META_DATA_DIR_PREFIX + File.separator + new File(iniaFile).getName();
            out.putNextEntry(new ZipEntry(zipPath));
            FileInputStream input = new FileInputStream(new File(evalFileName));
            FileInputStream iniaInput = new FileInputStream(new File(iniaFile));
            try {
                ExportFileUtil.exportZipFile(input, out);
                out.putNextEntry(new ZipEntry(zipIniaPath));
                ExportFileUtil.exportZipFile(iniaInput, out);
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)input);
                StreamUtils.closeStream(null, (InputStream)iniaInput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPkginfoFileToZip(ZipOutputStream out) throws IOException {
        String infoGrabPath = InfoGrabDirPropertiesUtil.getProperty() + File.separator + PKG_INFO;
        File domainFile = new File(infoGrabPath + File.separator + "domain_storage");
        File typeFile = new File(infoGrabPath + File.separator + "type_infograb");
        File descFile = new File(infoGrabPath + File.separator + "desc");
        if (domainFile.exists() || typeFile.exists() || descFile.exists()) {
            LOGGER.error("file is exists.");
            return;
        }
        FileOutputStream outStream = null;
        try {
            new File(infoGrabPath).mkdirs();
            if (!(domainFile.createNewFile() && typeFile.createNewFile() && descFile.createNewFile())) {
                LOGGER.error("file create is failed");
                return;
            }
            String sourceContext = "fileCreateTime=" + new Date().getTime() + System.lineSeparator() + "scene=network discovery";
            byte[] sourceByte = sourceContext.getBytes(Charset.defaultCharset());
            outStream = new FileOutputStream(descFile);
            outStream.write(sourceByte);
            StreamUtils.closeStream((OutputStream)outStream, null);
        }
        catch (IOException e) {
            LOGGER.error("file write failed");
        }
        finally {
            StreamUtils.closeStream(outStream, null);
        }
        LOGGER.info("Start putting the file into the zip package");
        String zipDomainFile = PKG_INFO + File.separator + domainFile.getName();
        String zipTypeFile = PKG_INFO + File.separator + typeFile.getName();
        out.putNextEntry(new ZipEntry(zipDomainFile));
        out.putNextEntry(new ZipEntry(zipTypeFile));
        FileInputStream domainFileinput = new FileInputStream(domainFile);
        FileInputStream typeFileInput = new FileInputStream(typeFile);
        FileInputStream descFileInput = new FileInputStream(descFile);
        String zipDescFile = PKG_INFO + File.separator + descFile.getName();
        try {
            ExportFileUtil.exportZipFile(domainFileinput, out);
            ExportFileUtil.exportZipFile(typeFileInput, out);
            out.putNextEntry(new ZipEntry(zipDescFile));
            ExportFileUtil.exportZipFile(descFileInput, out);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)domainFileinput);
            StreamUtils.closeStream(null, (InputStream)typeFileInput);
            StreamUtils.closeStream(null, (InputStream)descFileInput);
            FileUtils.deleteFile((File)new File(infoGrabPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportZipFile(FileInputStream fileIs, ZipOutputStream out) throws IOException {
        try {
            int len;
            byte[] bytes = new byte[1024];
            while ((len = fileIs.read(bytes)) > 0) {
                out.write(bytes, 0, len);
            }
        }
        finally {
            if (null != out) {
                try {
                    out.closeEntry();
                }
                catch (IOException e) {
                    LOGGER.error("Close zip entry error.");
                }
            }
        }
    }

    public static List<String> getHostHeader() {
        LinkedList<String> headList = new LinkedList<String>();
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        headList.add(ResourceUtil.getString((String)"infograb.task.collect.num.jugde"));
        return headList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<String> sortByCmd(File txtFile, List<String> cmdList, String enCodeing) {
        ArrayList<String> cmdSortList = new ArrayList<String>();
        ArrayList<String> newCmdList = new ArrayList<String>();
        FileInputStream in = null;
        String line = null;
        BufferedReader bufferedReader = null;
        InputStreamReader reader = null;
        try {
            in = new FileInputStream(txtFile);
            reader = new InputStreamReader((InputStream)in, enCodeing);
            bufferedReader = new BufferedReader(reader);
            for (String cmd : cmdList) {
                if ("cmd_no".equals(cmd)) continue;
                newCmdList.add(cmd);
            }
            while ((line = bufferedReader.readLine()) != null) {
                if (StringUtils.isNULLStr(line)) continue;
                for (String newCmd : newCmdList) {
                    if (!newCmd.contains(line.trim())) continue;
                    cmdSortList.add(line.trim());
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("the file {} is not exist.", (Object)txtFile.getName());
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)bufferedReader);
        }
        catch (Exception e2) {
            LOGGER.error("read the file error.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeResource(null, (Closeable)in);
                    StreamUtils.closeResource(null, reader);
                    StreamUtils.closeResource(null, bufferedReader);
                    throw throwable;
                }
            }
            StreamUtils.closeResource(null, (Closeable)in);
            StreamUtils.closeResource(null, (Closeable)reader);
            StreamUtils.closeResource(null, (Closeable)bufferedReader);
        }
        StreamUtils.closeResource(null, (Closeable)in);
        StreamUtils.closeResource(null, (Closeable)reader);
        StreamUtils.closeResource(null, (Closeable)bufferedReader);
        return cmdSortList;
    }

    public static Map<String, String> getInfoByCmdTag(List<String> cmds, File resultFile, String enCodeing) {
        HashMap<String, String> result = new HashMap<String, String>();
        File descFile = resultFile;
        for (String cmdDesc : cmds) {
            StringBuilder temp = new StringBuilder();
            try (FileInputStream in = new FileInputStream(descFile);
                 InputStreamReader reader = new InputStreamReader((InputStream)in, enCodeing);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                temp = ExportFileUtil.getContent(bufferedReader, cmdDesc);
            }
            catch (IOException e) {
                LOGGER.error("Read the file error.", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Something wrong.", (Throwable)e);
            }
            result.put(cmdDesc, temp.toString());
        }
        return result;
    }

    private static StringBuilder getContent(BufferedReader bufferedReader, String cmdDesc) throws IOException {
        StringBuilder temp = new StringBuilder();
        String lineTxt = null;
        boolean start = false;
        while ((lineTxt = bufferedReader.readLine()) != null) {
            if (lineTxt.contains(cmdDesc)) {
                start = true;
            }
            if (!start) continue;
            if (!lineTxt.contains(DEFAULT_SPLIT)) {
                temp.append(lineTxt);
                temp.append(System.getProperty("line.separator"));
                continue;
            }
            start = false;
        }
        return temp;
    }

    public static boolean isCliKeyToBeEval(String key) {
        if (StringUtils.isNULLStr(key)) {
            return false;
        }
        return key.startsWith(EVAL_CLIREM_KEY_PRIFIX);
    }

    public static boolean isShowCliKeyInReport(String key) {
        if (StringUtils.isNULLStr(key)) {
            return false;
        }
        return !key.startsWith(EVAL_CLIREM_KEY_PRIFIX) && !key.equalsIgnoreCase("err_msg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileContent(String filePath) {
        String string;
        InputStream in = null;
        String charSet = null;
        try {
            if (filePath.startsWith(CONFIG)) {
                in = ExportFileUtil.class.getResourceAsStream(filePath);
                charSet = "UTF-8";
            }
            if (in == null) {
                in = new FileInputStream(new File(filePath));
                charSet = CommonEncodeDetectUtils.endcodeDetect(filePath);
            }
            string = ExportFileUtil.readLinesFromFile(in, charSet);
        }
        catch (Exception e) {
            try {
                ToolLoggerFactory.getLogger(FileUtils.class).error("Certificate error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, in);
                throw throwable;
            }
            StreamUtils.closeStream(null, (InputStream)in);
            return null;
        }
        StreamUtils.closeStream(null, (InputStream)in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLinesFromFile(InputStream in, String charSet) {
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        try {
            reader = new BufferedReader(new InputStreamReader(in, charSet));
            String readLine = null;
            while ((readLine = reader.readLine()) != null) {
                result.append(readLine).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            String string;
            try {
                LOGGER.error("Read powershell result from file error...", (Throwable)e);
                string = null;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)reader);
            return string;
        }
        StreamUtils.closeResource(null, (Closeable)reader);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileCanOperate(String file) {
        boolean bl;
        File resFile = new File(file);
        if (!resFile.exists()) {
            return false;
        }
        RandomAccessFile raf = null;
        FileLock fl = null;
        try {
            raf = new RandomAccessFile(resFile, "rw");
            FileChannel fc = raf.getChannel();
            fl = fc.tryLock();
            bl = fl.isValid();
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOGGER.error("lock file error", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, raf);
                ExportFileUtil.releaseFileLock(fl);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)raf);
            ExportFileUtil.releaseFileLock(fl);
            return bl2;
        }
        StreamUtils.closeResource(null, (Closeable)raf);
        ExportFileUtil.releaseFileLock(fl);
        return bl;
    }

    public static void releaseFileLock(FileLock fl) {
        if (fl != null) {
            try {
                fl.close();
            }
            catch (Exception e) {
                LOGGER.error("release lock error");
            }
        }
    }
}

