/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.grab.GrabThread;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.service.XLSStorageService;
import com.huawei.ism.tool.infograb.service.XlsClusterItem;
import com.huawei.ism.tool.infograb.service.XlsItem;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;

public class GrabCommonUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabCommonUtils.class);
    private static final String TAB = ":\t";
    private static final String ENTER = "\r\n";

    public static String dealErrorMessageWithEcho(String errMsg) {
        return Arrays.stream(errMsg.split(ENTER)).map(GrabCommonUtils::getErrorMessage).collect(Collectors.joining());
    }

    private static String getErrorMessage(String singleMsg) {
        String[] cmdStrs = singleMsg.split(TAB);
        if (cmdStrs.length != 2) {
            LOGGER.info("the errMsg [{}] is not normal.", (Object)singleMsg);
            return "";
        }
        if (ResourceUtil.getString((String)"infograb.python.errmsg.failed").equals(cmdStrs[1])) {
            return singleMsg + TAB + ResourceUtil.getString((String)"infograb.execute.cmd.failed.timeout") + ENTER;
        }
        return singleMsg + TAB + " " + ENTER;
    }

    public static String getErrMsg(String oldSuccess, String newSuccess, String oldFailed, String newFailed, Map<String, Object> retMap) {
        return String.valueOf(retMap.get("err_msg")).replace(oldSuccess, newSuccess).replace(oldFailed, newFailed);
    }

    public static List<XlsClusterItem> getMoreXlsItems(XlsClusterItem itemHost, XlsClusterItem itemLun, List<String> storageList) {
        AtomicInteger mappingViewNum = new AtomicInteger(1);
        return storageList.stream().map(mappingViewId -> GrabCommonUtils.getXlsItems(mappingViewId, itemHost, itemLun, mappingViewNum)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<XlsClusterItem> getXlsItems(String mappingViewId, XlsClusterItem itemHost, XlsClusterItem itemLun, AtomicInteger mappingViewNum) {
        return Arrays.asList(GrabCommonUtils.getHostItem(itemHost, mappingViewId, mappingViewNum), GrabCommonUtils.getLunItem(itemLun, mappingViewId, mappingViewNum));
    }

    private static XlsClusterItem getHostItem(XlsClusterItem itemHost, String mappingViewId, AtomicInteger mappingViewNum) {
        XlsClusterItem xlsItemNewHost = new XlsClusterItem();
        xlsItemNewHost.copyeItem(itemHost);
        xlsItemNewHost.setStorageId(mappingViewId);
        xlsItemNewHost.setMigrateItemKey(xlsItemNewHost.getMigrateItemKey() + mappingViewNum.getAndIncrement());
        return xlsItemNewHost;
    }

    private static XlsClusterItem getLunItem(XlsClusterItem itemLun, String mappingViewId, AtomicInteger mappingViewNum) {
        XlsClusterItem xlsItemNewLun = new XlsClusterItem();
        xlsItemNewLun.copyeItem(itemLun);
        xlsItemNewLun.setStorageId(mappingViewId);
        xlsItemNewLun.setMigrateItemKey(xlsItemNewLun.getMigrateItemKey() + mappingViewNum.getAndIncrement());
        return xlsItemNewLun;
    }

    public static Map<String, List<String>> transferJsonObj(String jsonStr, XlsClusterItem xmi) throws ToolException {
        LOGGER.info("begin to read json object.");
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            JSONArray jsonArr = jsonObj.getJSONArray(xmi.getMigrateItemKey());
            Map<String, List<String>> dataMap = xmi.getSinglePyItems().stream().map(XlsItem::getKey).collect(Collectors.toMap(Function.identity(), itemKey -> GrabCommonUtils.getSingleItemData(jsonArr, itemKey), (oldData, newData) -> newData));
            LOGGER.info("transfer JsonObj to Str success");
            return dataMap;
        }
        catch (RuntimeException e) {
            LOGGER.error("transfer JsonObj to Str failed.", (Throwable)e);
            throw new ToolException("infograb.failed.reason.clusterScriptErr", e);
        }
        catch (Exception e) {
            LOGGER.error("transfer JsonObj to Str failed.", (Throwable)e);
            throw new ToolException("infograb.failed.reason.clusterScriptErr", e);
        }
    }

    private static List<String> getSingleItemData(JSONArray jsonArr, String itemKey) {
        return IntStream.range(0, jsonArr.length()).boxed().map(index -> jsonArr.getJSONObject(index.intValue()).get(itemKey).toString()).collect(Collectors.toList());
    }

    public static Map<String, Object> callMigScriptData(File scriptFile, File txtFile, GrabDevNode2 dev) {
        if (!scriptFile.exists()) {
            LOGGER.error("scriptFile is not exists");
            return null;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        context.put("Logger", LOGGER);
        context.put("path", txtFile.toString());
        context.put("ip", dev.getIp());
        context.put("map", retMap);
        if (!StringUtils.isNULLStr((String)dev.getDevInfoPkgPath())) {
            context.put("reportPath", dev.getDevInfoPkgPath());
        }
        try {
            JythonExecuter jythonExecuter = new JythonExecuter(new File(InfograbConstants.SCRIPT_ROOT_PATH));
            jythonExecuter.compileScript(scriptFile);
            jythonExecuter.simpleInvokeFunction("execute", context);
            return retMap;
        }
        catch (SignException e) {
            LOGGER.error("execute script error signException", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("execute {} script error fileNotFound Exception", (Object)scriptFile.getName());
        }
        catch (ToolException e) {
            LOGGER.error("python error", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("execute script error Tool Exception", (Throwable)e);
        }
        return null;
    }

    public static ExecuteResult createExcuteResult(GrabDevNode2 deviceNode, Item item, Map<String, Object> result) {
        ExecuteResult currResult = new ExecuteResult();
        currResult.setDevNode(deviceNode);
        currResult.setDescription(item.getTitle());
        currResult.setItem(item);
        currResult.setProgress(item.getUpdateProcNumber());
        currResult.setResultMap(result);
        return currResult;
    }

    public static Map<String, Map<String, List<String>>> secondCallScript(List<XlsClusterItem> xlsStorageItemList, File storageTxtFile, File scriptClusterParentFile, Map<String, Map<String, List<String>>> dataMap, GrabDevNode2 devNode) throws ToolException {
        HashMap<String, Map<String, List<String>>> resultDataMap = new HashMap<String, Map<String, List<String>>>();
        for (int i = 1; i < xlsStorageItemList.size(); ++i) {
            XlsClusterItem xlsMig = xlsStorageItemList.get(i);
            File scriptFile = new File(scriptClusterParentFile, xlsMig.getPythonFileName());
            if (!scriptFile.exists()) {
                LOGGER.info("script file {} does not exist.", (Object)xlsMig.getPythonFileName());
                continue;
            }
            String scriptData = GrabCommonUtils.callScriptStorageData(xlsMig, storageTxtFile, scriptFile, devNode);
            LOGGER.info("script file {} exec success.", (Object)xlsMig.getPythonFileName());
            Map<String, List<String>> singleDataMap = GrabCommonUtils.transferJsonObj(scriptData, xlsMig);
            if (dataMap.containsKey(xlsMig.getMigrateItemKey()) && resultDataMap.containsKey(xlsMig.getMigrateItemKey())) continue;
            resultDataMap.put(xlsMig.getMigrateItemKey(), singleDataMap);
        }
        return resultDataMap;
    }

    public static String callScriptStorageData(XlsClusterItem xlsMig, File txtFile, File scriptFile, GrabDevNode2 devNode) throws ToolException {
        HashMap<String, String> contextStorage = new HashMap<String, String>();
        contextStorage.put("command", GrabThread.transferStoragePythonCmd(xlsMig));
        contextStorage.put("dev_model", devNode.getDeviceModel());
        contextStorage.put("dev_type", devNode.getDeviceType().toString());
        contextStorage.put("version", devNode.getProductVersion());
        try {
            String filePath = txtFile.getCanonicalPath();
            contextStorage.put("path", filePath);
            contextStorage.put("data_key", xlsMig.getMigrateItemKey());
            JythonExecuter jythonExecuter = new JythonExecuter(new File(InfograbConstants.SCRIPT_ROOT_PATH));
            jythonExecuter.compileScript(scriptFile);
            jythonExecuter.simpleInvokeFunction("execute", new Object[]{contextStorage});
            GrabCommonUtils.logCallScriptErrorInfo(scriptFile.getName(), contextStorage);
        }
        catch (SignException e) {
            LOGGER.error("{} not sign.callScriptStorageData error", (Object)scriptFile.getName());
        }
        catch (FileNotFoundException e) {
            LOGGER.error("{} not found.callScriptStorageData error", (Object)scriptFile.getName());
        }
        catch (IOException e) {
            LOGGER.error("get canonical file path error.", (Throwable)e);
        }
        return (String)contextStorage.get("result");
    }

    public static List<XlsClusterItem> getXlsStorageItemList(GrabDevNode2 devNode) {
        return XLSStorageService.getInstance().getMigratXlsItems(GrabCommonUtils.getXlsSheetName(devNode).toLowerCase(Locale.ENGLISH));
    }

    private static String getXlsSheetName(GrabDevNode2 devNode) {
        if (GrabCommonUtils.getNotUseCommonSheetDevices().contains(devNode.getDeviceName())) {
            return devNode.getItDeviceType().getName() + "_" + devNode.getDeviceName();
        }
        return "storage_common";
    }

    private static List<String> getNotUseCommonSheetDevices() {
        return Arrays.asList("Huawei", "EMC", "HP", "IBM", "HDS");
    }

    public static Map<String, List<String>> storageFirstCallScript(List<XlsClusterItem> xlsItems, File txtFile, File scriptClusterParentFile, Map<String, Map<String, List<String>>> dataMap, GrabDevNode2 devNode) throws ToolException {
        Map<String, List<String>> storageNameMap = new HashMap<String, List<String>>();
        int maxLen = xlsItems.size() >= 2 ? 2 : xlsItems.size();
        for (int i = 0; i < maxLen; ++i) {
            XlsClusterItem xlsMig = xlsItems.get(i);
            File scriptFile = new File(scriptClusterParentFile, xlsMig.getPythonFileName());
            if (!scriptFile.exists()) {
                LOGGER.info("script file {} does not exist.", (Object)xlsMig.getPythonFileName());
                continue;
            }
            String scriptData = GrabCommonUtils.callScriptMigrateData(xlsMig, txtFile, scriptFile, devNode);
            LOGGER.info("script storage file {} exec success.", (Object)xlsMig.getPythonFileName());
            Map<String, List<String>> singleDataMap = GrabCommonUtils.transferJsonObj(scriptData, xlsMig);
            if (singleDataMap.containsKey("report_date/time")) {
                singleDataMap.put("report_date/time", Collections.singletonList(MigrationUtils.DATE_FORMAT.format(new Date())));
                singleDataMap.put("infograb_version", Collections.singletonList(GrabUtil.getToolVersion().trim()));
                singleDataMap.put("ip_address", Collections.singletonList(devNode.getIp()));
                dataMap.put(xlsMig.getMigrateItemKey(), singleDataMap);
            }
            if (!singleDataMap.containsKey("mapping_view_id") && !singleDataMap.containsKey("share_name")) continue;
            storageNameMap = singleDataMap;
        }
        return storageNameMap;
    }

    public static String callScriptMigrateData(XlsClusterItem xlsMig, File txtFile, File scriptFile, GrabDevNode2 devNode) throws ToolException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("command", GrabThread.transferPythonCmd(xlsMig));
        context.put("dev_model", devNode.getDeviceModel());
        context.put("dev_type", devNode.getDeviceType().toString());
        context.put("version", devNode.getProductVersion());
        context.put("data_key", xlsMig.getMigrateItemKey());
        try {
            String filePath = txtFile.getCanonicalPath();
            context.put("path", filePath);
            JythonExecuter jythonExecuter = new JythonExecuter(new File(InfograbConstants.SCRIPT_ROOT_PATH));
            jythonExecuter.compileScript(scriptFile);
            jythonExecuter.simpleInvokeFunction("execute", new Object[]{context});
            GrabCommonUtils.logCallScriptErrorInfo(scriptFile.getName(), context);
        }
        catch (SignException e) {
            LOGGER.error("{} not sign.", (Object)scriptFile.getName());
        }
        catch (FileNotFoundException e) {
            LOGGER.error("{} not found.", (Object)scriptFile.getName());
        }
        catch (IOException e) {
            LOGGER.error("get canonical file path error.", (Throwable)e);
            return null;
        }
        return (String)context.get("result");
    }

    private static void logCallScriptErrorInfo(String scriptFileName, Map<String, String> context) {
        if (context.containsKey("error")) {
            LOGGER.error("call script {} error on: {}", (Object)scriptFileName, (Object)context.get("error"));
        }
    }
}

