/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabFlow;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.MigrationType;
import com.huawei.ism.tool.infograb.entity.Module;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabFlowAdapter;
import com.huawei.ism.tool.infograb.parser.InfoGrabItemPaser;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import java.util.List;

public class GrabItemUtils {
    private static final String DASH = "-";

    public static List<Item> getGrabItemList(IGrabFlowAdapter grabFlowAdapter, GrabDevNode2 devNode) {
        if (GrabItemUtils.isNasStorage(devNode)) {
            return GrabItemUtils.getStorageNASGrabItems(devNode);
        }
        return grabFlowAdapter.findProperFlow(devNode);
    }

    private static List<Item> getStorageNASGrabItems(GrabDevNode2 devNode) {
        return GrabItemUtils.getNasStorageFlow().getModuleList().stream().filter(module -> GrabItemUtils.filterDeviceModule(devNode, module)).map(Module::getItemList).findFirst().orElse(null);
    }

    private static boolean filterDeviceModule(GrabDevNode2 devNode, Module module) {
        String deviceNameKey = devNode.getDeviceName() + DASH + devNode.getDeviceModel();
        return module.getTitle().equals(deviceNameKey);
    }

    private static GrabFlow getNasStorageFlow() {
        return InfoGrabItemPaser.getInstance().hanldeGrabFlow(InfograbConstants.NAS_STORAGE_GRABFLOW_XML);
    }

    private static boolean isNasStorage(DevNode devNode) {
        return MigrationType.NAS.getName().equals(devNode.getMigrType()) && ItDeviceType.Storage.equals((Object)devNode.getItDeviceType());
    }

    private GrabItemUtils() {
    }
}

