/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabFlow;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.Module;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.parser.InfoGrabItemPaser;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OfflineImportUtils {
    public static boolean isOfflineHost(DevNode devNode) {
        return devNode.getItDeviceType().equals((Object)ItDeviceType.Host) && devNode.getNodeAddType().equals((Object)NodeAddEnum.OFFLINE_IMPORT);
    }

    public static List<String> getSupportOfflineHostTypes() {
        return Arrays.asList("Linux", "AIX", "HP-UX", "Solaris", "VMware", "Windows");
    }

    public static GrabFlow getOfflineHostFlow() {
        return InfoGrabItemPaser.getInstance().hanldeGrabFlow(InfograbConstants.OFFLINE_HOST_GRABFLOW_XML);
    }

    public static Map<ItDeviceType, GrabFlow> getType2Flow(DevNode devNode) {
        HashMap<ItDeviceType, GrabFlow> offlineFlowMap = new HashMap<ItDeviceType, GrabFlow>();
        offlineFlowMap.put(ItDeviceType.Host, OfflineImportUtils.getOfflineHostFlow());
        return OfflineImportUtils.isOfflineHost(devNode) ? offlineFlowMap : GrabContext.getInstance().getSysType2FlowMap();
    }

    public static boolean needCreateHostXml(GrabDevNode2 dev) {
        List<String> supportTypes = OfflineImportUtils.getSupportOfflineHostTypes();
        List<String> taskCategory = ((RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)dev)).getTaskCategory();
        return supportTypes.contains(dev.getDeviceName()) && taskCategory.contains(ResourceUtil.getString((String)"infograb.item.category.data_migration"));
    }

    public static File getParseScriptParent(DevNode devNode, List<ExecuteResult> currResultList) {
        return OfflineImportUtils.isOfflineHost(devNode) ? OfflineImportUtils.getOfflineParseScriptParent(currResultList) : new File(OfflineImportUtils.getGrabScriptParent(currResultList), "migration");
    }

    public static File getOfflineParseScriptParent(List<ExecuteResult> currResultList) {
        return new File(OfflineImportUtils.getGrabScriptParent(currResultList).getParentFile(), "migration");
    }

    private static File getGrabScriptParent(List<ExecuteResult> currResultList) {
        return new File(GrabUtil.fixPath(currResultList.get(0).getItem().getScriptPath())).getParentFile();
    }

    public static Optional<List<Item>> getHostGrabFlow(String deviceName) {
        Optional<Module> hostGrabModel = OfflineImportUtils.getHostGrabModel(deviceName);
        if (!hostGrabModel.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(hostGrabModel.get().getItemList());
    }

    private static Optional<Module> getHostGrabModel(String deviceName) {
        GrabFlow offlineHostFlow = OfflineImportUtils.getOfflineHostFlow();
        if (VerifyUtil.isEmpty((Object)offlineHostFlow)) {
            return Optional.empty();
        }
        return offlineHostFlow.getModuleList().stream().filter(module -> OfflineImportUtils.checkTile(deviceName, module)).findFirst();
    }

    private static boolean checkTile(String deviceName, Module module) {
        return deviceName.equalsIgnoreCase(module.getTitle());
    }
}

