/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.HttpSession;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONObject;
import com.huawei.migration.common.connection.https.HttpExecutor;
import com.huawei.migration.common.exception.ToolRuntimeException;
import com.huawei.migration.common.exception.certificate.CertCheckRuntimeException;
import com.huawei.migration.common.exception.https.HttpIoRuntimeException;
import com.huawei.migration.common.util.data.ObjectClassConverter;
import com.huawei.migration.common.util.path.ToolPathUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.StatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    private static final Logger log = LoggerFactory.getLogger(RestUtils.class);
    private static final int HTTP_SOCKET_TIMEOUT = 30000;
    private static final Path TRUSTED_CERT = Paths.get("certificate", "trusted");
    private static final Path CRL = Paths.get("certificate", "crl");
    private static final HttpExecutor HTTPEXECUTOR;

    public static String executeRestCmd(ClassicHttpRequest requestInfo, JSONObject params, boolean checkCertificate) throws ToolException {
        if (StringUtils.isNotEmpty((CharSequence)params.toString())) {
            requestInfo.setEntity((HttpEntity)new StringEntity(params.toString(), ContentType.APPLICATION_JSON));
        }
        try {
            return RestUtils.execute(requestInfo, checkCertificate);
        }
        catch (ToolRuntimeException exception) {
            log.error("execute rest request failed.", (Throwable)exception);
            throw new ToolException("failed to connection", exception);
        }
    }

    public static Optional<ClassicHttpRequest> getRequestBase(String methodName, String url) {
        HttpGet requestBase = null;
        switch (methodName) {
            case "GET": {
                requestBase = new HttpGet(url);
                break;
            }
            case "PUT": {
                requestBase = new HttpPut(url);
                break;
            }
            case "POST": {
                requestBase = new HttpPost(url);
                break;
            }
            case "DELETE": {
                requestBase = new HttpDelete(url);
                break;
            }
            default: {
                log.error("unsupport method {}", (Object)methodName);
            }
        }
        if (requestBase != null) {
            requestBase.setConfig(RestUtils.getRequestConfig(30000L));
        }
        return Optional.ofNullable(requestBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ResponseInfo sendRequest(RequestInfo requestInfo, long timeout, int retryTimes) throws ToolException {
        ResponseInfo responseInfo;
        Object object;
        CloseableHttpResponse response;
        HttpEntity entity;
        block18: {
            block19: {
                HttpUriRequestBase request = requestInfo.toHttpUriRequest();
                request.setConfig(RestUtils.getRequestConfig(timeout));
                entity = null;
                response = RestUtils.getHttpResponse((ClassicHttpRequest)request, true);
                object = null;
                int responseCode = response.getCode();
                if (responseCode < 200 || responseCode >= 300) {
                    throw new ToolException("http response with error code: " + responseCode);
                }
                entity = response.getEntity();
                responseInfo = RestUtils.getResponseInfo(entity, response);
                if (response == null) break block18;
                if (object == null) break block19;
                try {
                    response.close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                break block18;
            }
            response.close();
        }
        EntityUtils.consumeQuietly((HttpEntity)entity);
        return responseInfo;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (response != null) {
                                if (object != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    response.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException | ParseException e) {
                        if (retryTimes <= 0) {
                            throw new ToolException("send http request error.", e);
                        }
                        HttpSession.silentSleep(3, TimeUnit.SECONDS);
                        log.warn("retry http request [{}] on error: {}.", (Object)requestInfo.getURL(), (Object)e.getMessage());
                        object = RestUtils.sendRequest(requestInfo, timeout, retryTimes - 1);
                        EntityUtils.consumeQuietly((HttpEntity)entity);
                        return object;
                    }
                }
                catch (Throwable throwable4) {
                    EntityUtils.consumeQuietly(entity);
                    throw throwable4;
                }
            }
        }
    }

    private static String execute(ClassicHttpRequest requestInfo, boolean defaultTrustServerCert) throws ToolException {
        if (defaultTrustServerCert) {
            return RestUtils.trustServerCertWhenDefault(() -> HTTPEXECUTOR.execute(requestInfo));
        }
        return RestUtils.trustLocalCertAndReExecute(() -> HTTPEXECUTOR.execute(requestInfo));
    }

    private static CloseableHttpResponse getHttpResponse(ClassicHttpRequest requestInfo, boolean defaultTrustServerCert) throws ToolException {
        if (defaultTrustServerCert) {
            return RestUtils.trustServerCertWhenDefault(() -> HTTPEXECUTOR.getHttpResponse(requestInfo));
        }
        return RestUtils.trustLocalCertAndReExecute(() -> HTTPEXECUTOR.getHttpResponse(requestInfo));
    }

    private static ResponseInfo getResponseInfo(HttpEntity entity, CloseableHttpResponse response) throws IOException, ParseException {
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        String type = contentType == null ? "" : contentType.getMimeType();
        ResponseInfo responseInfo = new ResponseInfo();
        responseInfo.setHeaders(response.getHeaders());
        responseInfo.setLocale(response.getLocale());
        responseInfo.setStatusLine(new StatusLine((HttpResponse)response));
        responseInfo.setContentType(type);
        responseInfo.setContent(EntityUtils.toString((HttpEntity)entity));
        return responseInfo;
    }

    private static RequestConfig getRequestConfig(long timeout) {
        return RequestConfig.custom().setConnectTimeout(timeout, TimeUnit.MILLISECONDS).setResponseTimeout(timeout, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(timeout, TimeUnit.MILLISECONDS).build();
    }

    private static <R> R trustServerCertWhenDefault(Supplier<R> restExecute) throws ToolException {
        try {
            return restExecute.get();
        }
        catch (HttpIoRuntimeException exception) {
            return RestUtils.checkTrustCertAndReExecute(restExecute, exception);
        }
    }

    private static <R> R trustLocalCertAndReExecute(Supplier<R> restExecute) {
        try {
            return restExecute.get();
        }
        catch (HttpIoRuntimeException exception) {
            log.error("execute request failed, cause: ", (Throwable)exception);
            RestUtils.initCertificateTrusted();
            return restExecute.get();
        }
    }

    private static <R> R checkTrustCertAndReExecute(Supplier<R> restExecute, HttpIoRuntimeException exception) throws ToolException {
        if (!RestUtils.isCertNotTrustedError(exception)) {
            log.error("execute rest request failed.", (Throwable)exception);
            throw new ToolException("failed to connection", exception);
        }
        log.error("execute request failed, cause: ", (Throwable)exception);
        return (R)ObjectClassConverter.convert((Object)exception.getCause(), SSLException.class).flatMap(sslException -> ObjectClassConverter.convert((Object)sslException.getCause(), CertCheckRuntimeException.class)).filter(RestUtils::isCertNotRevoked).map(CertCheckRuntimeException::getCertificateChain).map(certChain -> {
            RestUtils.makeCertificateChainTrusted(certChain);
            log.info("the certificate has been trusted, re execute request");
            return restExecute.get();
        }).orElseThrow(() -> new ToolException("failed to connection"));
    }

    private static boolean isCertNotTrustedError(HttpIoRuntimeException exception) {
        return exception.getCause() instanceof SSLException && exception.getCause().getCause() instanceof CertCheckRuntimeException;
    }

    private static boolean isCertNotRevoked(CertCheckRuntimeException exception) {
        return !exception.getErrorMessage().contains("server cert is revoked");
    }

    private static void makeCertificateChainTrusted(X509Certificate[] certificateChain) {
        HTTPEXECUTOR.getTrustedHttpConnectionManager().makeCertificateChainTrusted(certificateChain, TRUSTED_CERT);
    }

    private static void initCertificateTrusted() {
        HTTPEXECUTOR.getTrustedHttpConnectionManager().initCertificates(TRUSTED_CERT, CRL);
    }

    private RestUtils() {
    }

    public static HttpExecutor getHTTPEXECUTOR() {
        return HTTPEXECUTOR;
    }

    static {
        ToolPathUtil.makeDir((Path)TRUSTED_CERT);
        ToolPathUtil.makeDir((Path)CRL);
        HTTPEXECUTOR = new HttpExecutor(TRUSTED_CERT, CRL);
    }
}

