/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SceneEnvironmentImpl {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneEnvironmentImpl.class);
    private static final String END_TIME = "endTime";
    private static final String SN_IP = "SN_IP";
    private static final String JSON_SCENE_RESULT_PATH = "jsonSceneResultPath";
    private static final String DEVICE_IP = "IP";
    private static final String STATUS = "status";
    private static final String DEVICE_SN = "SN";
    private static final String FILENAME = "fileName";
    private static final String FILELOG = "fileLog";
    private static final String DEVICE = "host";
    private static final String TOOL_ID = "toolId";
    private static final String SCENE_DATA_XML_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "scenedata.xml";
    private static final String XML = "xml";
    private static final String YES = "yes";
    private static final File SCENE_DATA_XML = new File(SCENE_DATA_XML_PATH);
    private static final String JSON_SCENE = "jsonScene";
    private static SceneEnvironmentImpl instance = null;
    private static DocumentBuilder documentBuilder = null;
    private List<String> strKey = new LinkedList<String>();
    private String[] xmlToolIdDevElement = new String[]{"status", "fileName", "fileLog"};
    private FileLock fileLock = null;
    private FileOutputStream fos = null;

    public SceneEnvironmentImpl() {
        this.initKeyStrList();
        this.initDocBuilder();
    }

    public static SceneEnvironmentImpl getInstance() {
        if (null == instance) {
            instance = new SceneEnvironmentImpl();
        }
        return instance;
    }

    public boolean isScene() {
        String sceneKey = JSON_SCENE;
        String sceneInfo = System.getenv(sceneKey);
        return !StringUtils.isNULLStr((String)sceneInfo);
    }

    private void initDocBuilder() {
        DocumentBuilderFactory builderFactory = XmlUtils.getDocumentBuilderFactory();
        try {
            documentBuilder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("documentBuilder build faild", (Throwable)e);
        }
    }

    private void initKeyStrList() {
        this.strKey.add(STATUS);
        this.strKey.add(DEVICE_IP);
        this.strKey.add(DEVICE_SN);
        this.strKey.add(TOOL_ID);
        this.strKey.add(FILENAME);
        this.strKey.add(END_TIME);
    }

    public boolean initSceneEnvir() throws ToolException {
        try {
            boolean isSucc;
            if (SCENE_DATA_XML.exists()) {
                LOGGER.info("Start deleting files:{}", (Object)SCENE_DATA_XML);
                this.deleteFile(SCENE_DATA_XML);
            }
            if (isSucc = SCENE_DATA_XML.createNewFile()) {
                this.fos = new FileOutputStream(SCENE_DATA_XML);
                this.fileLock = this.fos.getChannel().lock();
                LOGGER.info("fileLock Lock locked.");
                LOGGER.info("init scene environment succ");
                return true;
            }
            LOGGER.error("Failure to create a file:" + SCENE_DATA_XML);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Init FileNotFoundException error!");
        }
        catch (IOException e) {
            LOGGER.error("Init IOException error!");
        }
        return false;
    }

    private void deleteFile(File file) {
        int retryTimes = 2;
        for (int i = 0; i < retryTimes && !file.delete(); ++i) {
        }
    }

    private boolean tranformerResult(Document newdoc) {
        try {
            Transformer trans = XmlUtils.newTransformer();
            trans.setOutputProperty("indent", YES);
            trans.setOutputProperty("method", XML);
            trans.transform(new DOMSource(newdoc), new StreamResult(this.fos));
            return true;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("xml write failed,IllegalArgument");
            return false;
        }
        catch (TransformerFactoryConfigurationError e) {
            LOGGER.error("xml write failed,TransformerFactoryConfigurationError");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("xml write failed,TransformerException", (Throwable)e);
            return false;
        }
    }

    private void appendDevData(Document doc, Map<String, String> map, Element device) {
        for (String tag : this.xmlToolIdDevElement) {
            Element element = doc.createElement(tag);
            String key = element.getTagName();
            CDATASection elementContext = doc.createCDATASection(String.valueOf(map.get(key)));
            device.appendChild(element);
            element.appendChild(elementContext);
        }
    }

    public boolean finishedSceneTask(List<Map<String, String>> listMap) throws ToolException {
        try {
            LinkedList<Map<String, String>> finalResMapList = new LinkedList<Map<String, String>>();
            for (Map<String, String> map : listMap) {
                finalResMapList.add(this.checkIsContainsKey(map));
            }
            return this.wirteDevDataToFile(finalResMapList);
        }
        catch (Exception e) {
            LOGGER.error("The map is error....");
            throw new ToolException("The map is error....", (Throwable)e);
        }
    }

    private boolean wirteDevDataToFile(List<Map<String, String>> listMap) {
        LOGGER.info("get finishedSceneTask params...{}", listMap);
        return this.writeToolSceneData(listMap);
    }

    private boolean writeToolSceneData(List<Map<String, String>> listMap) {
        LoggerFactory.getLogger(this.getClass()).info("scenedata file write ");
        Document doc = null;
        try {
            doc = documentBuilder.newDocument();
            Element root = doc.createElement("scene");
            doc.appendChild(root);
            return this.writeToSceneData(doc, root, listMap);
        }
        catch (DOMException e) {
            LoggerFactory.getLogger(this.getClass()).error("xml writer failed.", (Throwable)e);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("xml writer failed.", (Throwable)e);
        }
        return false;
    }

    private Map<String, String> checkIsContainsKey(Map<String, String> map) {
        for (String keyStr : map.keySet()) {
            if (this.strKey.contains(keyStr)) continue;
            throw new IllegalArgumentException("Missing must-input column:" + this.strKey);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String keyStr : this.strKey) {
            resultMap.put(keyStr, null);
        }
        resultMap.putAll(map);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToSceneData(Document doc, Element root, List<Map<String, String>> listMap) {
        boolean result = false;
        try {
            for (Map<String, String> map : listMap) {
                this.addToolSceneData(doc, root, map);
            }
            if (this.fos == null) {
                LOGGER.info("Start to recreate the XML file");
                this.initSceneEnvir();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("scenedata file start " + (this.fos == null ? " null " : this.fos.getChannel()));
            }
            result = this.tranformerResult(doc);
            LOGGER.info("File write success.");
        }
        catch (DOMException e) {
            LOGGER.error("File write error.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("File write error.", (Throwable)e);
        }
        finally {
            this.lockClose();
        }
        return result;
    }

    private void lockClose() {
        LOGGER.info("fileLock Lock released.");
        try {
            if (null != this.fileLock) {
                this.fileLock.release();
            }
        }
        catch (IOException e) {
            LOGGER.error("FileUnlock failed.");
        }
        StreamUtils.closeStream((OutputStream)this.fos, null);
    }

    private void addToolSceneData(Document doc, Element root, Map<String, String> map) {
        if (StringUtils.isNULLStr((String)map.get(DEVICE_SN))) {
            LOGGER.info("SN is  null...{}", (Object)map.get(DEVICE_SN));
            this.writeSceneDataFinishedTime(doc, root);
            return;
        }
        Element device = doc.createElement(DEVICE);
        device.setAttribute(SN_IP, map.get(DEVICE_SN) + "_" + map.get(DEVICE_IP));
        this.appendDevData(doc, map, device);
        root.appendChild(device);
        this.writeSceneDataFinishedTime(doc, root);
    }

    private Document writeSceneDataFinishedTime(Document doc, Element root) {
        NodeList links = doc.getElementsByTagName(END_TIME);
        if (null != links && links.getLength() > 0) {
            for (int i = 0; i < links.getLength(); ++i) {
                Node node = links.item(i);
                node.getParentNode().removeChild(node);
            }
        }
        Date date = new Date();
        String time = this.getDateString(date);
        Element endTime = doc.createElement(END_TIME);
        root.appendChild(endTime);
        Text endTimeText = doc.createTextNode(time);
        endTime.appendChild(endTimeText);
        return doc;
    }

    private String getDateString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public String getEnvirValueByKey(String envirKeyStr) {
        try {
            LOGGER.info("scene get envir value...{}", (Object)envirKeyStr);
            String envirStrVslue = System.getenv(envirKeyStr);
            if (StringUtils.isNULLStr((String)envirStrVslue)) {
                LOGGER.error("envirKeyStr value can not null.");
                return null;
            }
            if (envirKeyStr.equalsIgnoreCase(JSON_SCENE_RESULT_PATH)) {
                LOGGER.info("return scene path envir value");
                return envirStrVslue;
            }
            return null;
        }
        catch (RuntimeException e) {
            LOGGER.error("envirKeyStr is error");
            return null;
        }
        catch (Exception e) {
            LOGGER.error("envirKeyStr is error");
            return null;
        }
    }
}

