/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.base.BaseTaskPanel;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.context.ItemResultEnum;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.intf.worktaker.AddDeviceService;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Desktop;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.python.google.common.base.Strings;
import org.slf4j.Logger;

public class ToolUtils {
    public static final String HOSTS_TOBE_COLLECTED = "hostInfo4PreUpgradeCheck.csv";
    public static final String HOSTS_TOBE_COLLECTED_INFOGRAB = "hostInfo4PreUpgradeCheck.txt";
    public static final String HOSTS_TOBE_COLLECTED_INFOGRAB_HTML = "hostInfo4PreUpgradeCheck.html";
    public static final String ASM_PMON = "asm_pmon";
    public static final String ASM_PMON_HOME = "/bin/ocssd.bin";
    public static final String HELP_FILE_NAME = "InfoGrab";
    public static final String HELP_FILE_DIR = "help";
    public static final String HELP_FILE_TYPE = ".chm";
    private static final String HH_EXE = "hh.exe ";
    private static final int DEFAULT_EXPORER_TIMEOUT = 3;
    private static final String TEMPFILE_TEMP = "tempfile.temp";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ToolUtils.class);
    private static final String ERROR_CODE_MISUSE_SHELL = "2";
    private static final String ERROR_CODE_CANNOT_EXECUTE = "126";
    private static final String ERROR_CODE_NOT_FOUND = "127";
    private static final String ERROR_CODE_SCRIPT_TERMINATED = "130";
    private static final Pattern PATTERN = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");

    public static String getCanonicalFilePath(File file) {
        if (file == null) {
            return "";
        }
        String canonicalPath = "";
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(ToolUtils.class).error("get file path error");
        }
        return canonicalPath;
    }

    public static void findCategoryItems(List<String> selectedCategory, List<Item> allItems, List<Item> categoryItems) {
        block0: for (Item item : allItems) {
            for (String category : selectedCategory) {
                if (!item.getCategory().contains(category) && !item.getCategory().contains("allApplicationScenariosFlag")) continue;
                Item itemCopy = new Item();
                itemCopy.copyeItem(item);
                categoryItems.add(itemCopy);
                continue block0;
            }
        }
    }

    public static String getCanonicalFilePath(String filePath) {
        String strPath = Normalizer.normalize(filePath, Normalizer.Form.NFKC);
        File file = new File(strPath);
        return ToolUtils.getCanonicalFilePath(file);
    }

    public static File getCanonicalFile(String filePath) {
        String strPath = Normalizer.normalize(filePath, Normalizer.Form.NFKC);
        File file = new File(strPath);
        File canonicalFile = null;
        try {
            canonicalFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(ToolUtils.class).error("get Canonical file error");
        }
        return canonicalFile;
    }

    public static boolean exeExportSelectFile(String path, boolean isSelect) {
        path = Normalizer.normalize(path, Normalizer.Form.NFKC);
        String[] commands = null;
        if (isSelect) {
            commands = new String[]{"explorer.exe /select," + path};
        } else {
            File file = new File(FilePathUtils.filterPath((String)path));
            if (file.isDirectory()) {
                try {
                    Desktop.getDesktop().open(file);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("open file error", (Throwable)e);
                }
            }
            commands = new String[]{"explorer.exe", path};
        }
        return ToolUtils.execCMDs(commands);
    }

    public static boolean exploreFile(String file) {
        if (StringUtils.isNULLStr((String)file) || !new File(file).exists()) {
            return false;
        }
        String[] commands = new String[]{"cmd /c start " + file};
        return ToolUtils.execCMDs(commands);
    }

    /*
     * Exception decompiling
     */
    private static boolean execCMDs(String[] commands) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void exitSystem() {
        Runtime.getRuntime().exit(0);
    }

    public static void createDir(String filePath) {
        File tmpFile = new File(filePath);
        ToolUtils.createDir(tmpFile);
    }

    public static void createDir(File path) {
        if (!path.exists() && !path.mkdirs()) {
            LOGGER.error("create path successed.");
        }
    }

    public static boolean isFunsionSphere(GrabDevNode1 devNode) {
        return null != devNode.getDevTypeLevel2() && devNode.getDevTypeLevel2().toString().equalsIgnoreCase("fusionSphere");
    }

    public static GrabDevNode1 grabNode2ToNode1(GrabDevNode2 devNode) {
        DeviceType devTypeLevel2;
        if (null == devNode) {
            return null;
        }
        GrabDevNode1 grabNewNode = new GrabDevNode1();
        grabNewNode.setCreateTime(devNode.getCreateTime());
        grabNewNode.setDbName(devNode.getDbName());
        grabNewNode.setDeveloperPwd(devNode.getDeveloperPwd());
        grabNewNode.setDeviceName(devNode.getDeviceName());
        grabNewNode.setDeviceSerialNumber(devNode.getDeviceSerialNumber());
        DeviceType deviceType = devNode.getDeviceType();
        if (null != deviceType) {
            grabNewNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf(deviceType.toString()));
        }
        if (null != (devTypeLevel2 = devNode.getDevTypeLevel2())) {
            grabNewNode.setDevTypeLevel2(com.huawei.ism.tool.obase.entity.DeviceType.valueOf(devTypeLevel2.toString()));
        }
        grabNewNode.setIp(devNode.getIp());
        grabNewNode.setIpListAreInnerIp(false);
        grabNewNode.setItDeviceType(devNode.getItDeviceType());
        ToolUtils.setLoginUserInfo(devNode, grabNewNode);
        ToolUtils.setClientUserInfo(devNode, grabNewNode);
        grabNewNode.setMatchType("");
        grabNewNode.setPeerIp(devNode.getPeerIp());
        grabNewNode.setPort(devNode.getPort());
        ToolUtils.checkDevNode(devNode, grabNewNode);
        return grabNewNode;
    }

    private static void setLoginUserInfo(GrabDevNode2 devNode, GrabDevNode1 grabNewNode) {
        if (null != devNode.getLoginUser()) {
            String name = devNode.getLoginUser().getUserName();
            String pass = devNode.getLoginUser().getPassword();
            int port = devNode.getLoginUser().getPort();
            User user = new User(name, pass, port);
            grabNewNode.setLoginUser(user);
        }
    }

    private static void setClientUserInfo(GrabDevNode2 devNode, GrabDevNode1 grabNewNode) {
        if (devNode.getClientUser() != null) {
            String name = devNode.getClientUser().getUserName();
            String pass = devNode.getClientUser().getPassword();
            User user = new User(name, pass);
            grabNewNode.setClientUser(user);
        }
    }

    static void checkDevNode(GrabDevNode2 devNode, GrabDevNode1 grabNewNode) {
        if (null != devNode.getPriKey()) {
            PriKeyInfo info = new PriKeyInfo();
            info.setKeyName(devNode.getPriKey().getKeyName());
            info.setKeyPath(devNode.getPriKey().getKeyPath());
            info.setKeyPwd(devNode.getPriKey().getKeyPwd());
            grabNewNode.setPriKey(info);
        }
        grabNewNode.setProductVersion(devNode.getProductVersion());
        grabNewNode.setSocks5Proxy(EntityUtils.toOldSocksProxy(devNode.getSocks5Proxy()));
        if (devNode.getSshForwardList() != null) {
            ArrayList<MultiRouteNode> sshForwardList = new ArrayList<MultiRouteNode>();
            for (com.huawei.ism.tool.framework.pubservice.entity.MultiRouteNode routeNode : devNode.getSshForwardList()) {
                MultiRouteNode rNode = EntityUtils.toOldMultiRouteNode(routeNode);
                sshForwardList.add(rNode);
            }
            grabNewNode.setSshForwardList(sshForwardList);
        }
        grabNewNode.setSshName("");
        grabNewNode.setTlvPort(devNode.getTlvPort());
        grabNewNode.setUid();
        grabNewNode.setUseJdbc(devNode.isUseJdbc());
        grabNewNode.setUuid(devNode.getUuid());
        ReflectionUtils.syncObjectAttr((Object)((Object)devNode), (Object)grabNewNode);
    }

    public static List<GrabDevNode1> obaseNodetoGrabDevNode1(List<GrabDevNode2> grabDevNode2List) {
        ArrayList<GrabDevNode1> grabDevNode1List = new ArrayList<GrabDevNode1>();
        for (GrabDevNode2 devNode2 : grabDevNode2List) {
            grabDevNode1List.add(ToolUtils.grabNode2ToNode1(devNode2));
        }
        return grabDevNode1List;
    }

    public static GrabDevNode2 toGrabNewNode(DevNode devNode) {
        GrabDevNode2 grabNewNode2 = new GrabDevNode2();
        grabNewNode2.setCreateTime(devNode.getCreateTime());
        grabNewNode2.setDbName(devNode.getDbName());
        grabNewNode2.setDeveloperPwd("");
        grabNewNode2.setDeviceName(devNode.getDeviceName());
        grabNewNode2.setDeviceSerialNumber(devNode.getDeviceSerialNumber().toUpperCase(Locale.ENGLISH));
        grabNewNode2.setDeviceType(devNode.getDeviceType());
        grabNewNode2.setDevTypeLevel2(devNode.getDevTypeLevel2());
        grabNewNode2.setIp(devNode.getIp());
        grabNewNode2.setIpList(devNode.getIpList());
        grabNewNode2.setIpListAreInnerIp(false);
        grabNewNode2.setCollectDone(false);
        grabNewNode2.setCollectStop(false);
        grabNewNode2.setItDeviceType(devNode.getItDeviceType());
        grabNewNode2.setLoginUser(devNode.getLoginUser());
        grabNewNode2.setPeerIp(devNode.getPeerIp());
        grabNewNode2.setPort(devNode.getPort());
        grabNewNode2.setPriKey(devNode.getPriKey());
        grabNewNode2.setProductVersion(devNode.getProductVersion());
        grabNewNode2.setSocks5Proxy(devNode.getSocks5Proxy());
        grabNewNode2.setSshForwardList(devNode.getSshForwardList());
        grabNewNode2.setSslVersion(devNode.getSslVersion());
        grabNewNode2.setTlvPort(devNode.getTlvPort());
        grabNewNode2.setTlvSocketType(devNode.getTlvSocketType());
        grabNewNode2.setUseJdbc(devNode.isUseJdbc());
        grabNewNode2.setUuid(devNode.getUuid());
        grabNewNode2.setSudoGrab(devNode.isSudoGrab());
        ReflectionUtils.syncObjectAttr((Object)devNode, (Object)((Object)grabNewNode2));
        return grabNewNode2;
    }

    public static GrabDevNode2 toGrabNewNode(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        DevNode newNode = EntityUtils.toNewDev(devNode);
        return ToolUtils.toGrabNewNode(newNode);
    }

    public static GrabDevNode1 obaseToNode1(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (null == devNode) {
            return null;
        }
        GrabDevNode1 grabNewNode1 = new GrabDevNode1();
        grabNewNode1.setCreateTime(devNode.getCreateTime());
        grabNewNode1.setDbName(devNode.getDbName());
        grabNewNode1.setDeveloperPwd("");
        grabNewNode1.setDeviceName(devNode.getDeviceName());
        grabNewNode1.setDeviceSerialNumber(devNode.getDeviceSerialNumber().toUpperCase(Locale.ENGLISH));
        grabNewNode1.setDeviceType(devNode.getDeviceType());
        grabNewNode1.setDevTypeLevel2(devNode.getDevTypeLevel2());
        grabNewNode1.setIp(devNode.getIp());
        grabNewNode1.setIpList(devNode.getIpList());
        grabNewNode1.setIpListAreInnerIp(false);
        grabNewNode1.setItDeviceType(devNode.getItDeviceType());
        grabNewNode1.setLoginUser(devNode.getLoginUser());
        grabNewNode1.setMatchType(devNode.getMatchType());
        grabNewNode1.setPeerIp(devNode.getPeerIp());
        grabNewNode1.setPort(devNode.getPort());
        grabNewNode1.setPriKey(devNode.getPriKey());
        grabNewNode1.setProductVersion(devNode.getProductVersion());
        grabNewNode1.setSocks5Proxy(devNode.getSocks5Proxy());
        grabNewNode1.setSshForwardList(devNode.getSshForwardList());
        grabNewNode1.setSshName(devNode.getSshName());
        grabNewNode1.setTlvPort(devNode.getTlvPort());
        grabNewNode1.setUid();
        grabNewNode1.setUseJdbc(devNode.isUseJdbc());
        grabNewNode1.setUuid(devNode.getUuid());
        grabNewNode1.setAdminUser(devNode.getAdminUser());
        grabNewNode1.setRootUser(devNode.getRootUser());
        grabNewNode1.setSudoGrab(devNode.isSudoGrab());
        if (null != devNode.getRootUser()) {
            grabNewNode1.setSwitchRoot(true);
        }
        return grabNewNode1;
    }

    public static List<GrabDevNode1> obaseToNewNode1List(List<com.huawei.ism.tool.obase.entity.DevNode> devNodeList) {
        ArrayList<GrabDevNode1> devNode1List = new ArrayList<GrabDevNode1>();
        for (com.huawei.ism.tool.obase.entity.DevNode obaseNode : devNodeList) {
            devNode1List.add(ToolUtils.obaseToNode1(obaseNode));
        }
        return devNode1List;
    }

    public static com.huawei.ism.tool.obase.entity.DevNode toOldObaseDevNode(GrabDevNode2 devNode2) {
        if (null == devNode2) {
            return null;
        }
        com.huawei.ism.tool.obase.entity.DevNode oldNode = new com.huawei.ism.tool.obase.entity.DevNode();
        oldNode.setDbName(devNode2.getDbName());
        oldNode.setCreateTime(devNode2.getCreateTime());
        oldNode.setDeveloperPwd(devNode2.getDeveloperPwd());
        oldNode.setDeviceName(devNode2.getDeviceName());
        oldNode.setDeviceSerialNumber(devNode2.getDeviceSerialNumber());
        oldNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf(devNode2.getDeviceType().toString()));
        oldNode.setDevKey(devNode2.getDevKey());
        oldNode.setDevTypeLevel2(com.huawei.ism.tool.obase.entity.DeviceType.valueOf(devNode2.getDevTypeLevel2().toString()));
        oldNode.setErrorDecs(devNode2.getErrorDecs());
        oldNode.setIp(devNode2.getIp());
        oldNode.setItDeviceType(devNode2.getItDeviceType());
        User user = new User(devNode2.getLoginUser().getUserName(), devNode2.getLoginUser().getPassword(), devNode2.getLoginUser().getPort());
        oldNode.setLoginUser(user);
        oldNode.setPeerIp(devNode2.getPeerIp());
        oldNode.setPort(devNode2.getPort());
        oldNode.setUseJdbc(devNode2.isUseJdbc());
        ToolUtils.checkDevNode(devNode2, oldNode);
        return oldNode;
    }

    static void checkDevNode(GrabDevNode2 devNode2, com.huawei.ism.tool.obase.entity.DevNode oldNode) {
        if (null != devNode2.getPriKey()) {
            PriKeyInfo priKey = new PriKeyInfo();
            priKey.setKeyName(devNode2.getPriKey().getKeyName());
            priKey.setKeyPath(devNode2.getPriKey().getKeyPath());
            priKey.setKeyPwd(devNode2.getPriKey().getKeyPwd());
            oldNode.setPriKey(priKey);
        }
        oldNode.setProductVersion(devNode2.getProductVersion());
        if (null != devNode2.getSocks5Proxy()) {
            Socks5Proxy socks5Proxy = new Socks5Proxy();
            socks5Proxy.setName(devNode2.getSocks5Proxy().getName());
            socks5Proxy.setPort(devNode2.getSocks5Proxy().getPort());
            socks5Proxy.setServerIp(devNode2.getSocks5Proxy().getServerIp());
            socks5Proxy.setPass(devNode2.getSocks5Proxy().getPass());
            socks5Proxy.setAuthentic(devNode2.getSocks5Proxy().isAuthentic());
            socks5Proxy.setUuid(devNode2.getSocks5Proxy().getUuid());
            socks5Proxy.setUser(devNode2.getSocks5Proxy().getUser());
            oldNode.setSocks5Proxy(socks5Proxy);
        }
        if (devNode2.getSshForwardList() != null) {
            ArrayList<MultiRouteNode> sshForwardList = new ArrayList<MultiRouteNode>();
            MultiRouteNode rNode = null;
            for (com.huawei.ism.tool.framework.pubservice.entity.MultiRouteNode routeNode : devNode2.getSshForwardList()) {
                String host = routeNode.getHost();
                int port = routeNode.getPort();
                String uName = routeNode.getUname();
                rNode = new MultiRouteNode(host, port, uName, routeNode.getPwd());
                sshForwardList.add(rNode);
            }
            oldNode.setSshForwardList(sshForwardList);
        }
        oldNode.setTlvPort(oldNode.getTlvPort());
        oldNode.setUuid(devNode2.getUuid());
    }

    public static List<com.huawei.ism.tool.obase.entity.DevNode> toOldDevNodeList(List<GrabDevNode2> devNode2List) {
        ArrayList<com.huawei.ism.tool.obase.entity.DevNode> oldDevNodeList = new ArrayList<com.huawei.ism.tool.obase.entity.DevNode>();
        for (GrabDevNode2 devNode2 : devNode2List) {
            oldDevNodeList.add(ToolUtils.toOldObaseDevNode(devNode2));
        }
        return oldDevNodeList;
    }

    public static String sceneResultPath() {
        ScenePathValue sceneValue = null;
        String scenePath = null;
        try {
            sceneValue = (ScenePathValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonSceneResultPath");
            if (null == sceneValue) {
                return "";
            }
            scenePath = sceneValue.getJsonSceneResultPathValue();
            LOGGER.info("The sceneResultPath is:{}", (Object)scenePath);
        }
        catch (ToolException e) {
            LOGGER.error("the sceneResultPath exception:", (Throwable)e);
        }
        if (sceneValue == null) {
            scenePath = "";
        }
        return scenePath;
    }

    public static String getErrorMessageFromEcho(String echoValue) {
        if (StringUtils.isNULLStr((String)echoValue)) {
            return "";
        }
        switch (echoValue) {
            case "2": {
                return ResourceUtil.getString((String)"infograb.execute.cmd.error2&126");
            }
            case "126": {
                return ResourceUtil.getString((String)"infograb.execute.cmd.error2&126");
            }
            case "127": {
                return ResourceUtil.getString((String)"infograb.execute.cmd.error127");
            }
            case "130": {
                return ResourceUtil.getString((String)"infograb.execute.cmd.error130");
            }
        }
        return ResourceUtil.getString((String)"infograb.execute.cmd.error127&128&others");
    }

    public static String getSpecialSymbols(Boolean isSimulator) {
        return isSimulator != false ? " ^>>" : " >> ";
    }

    public static String getAppendFileStr(Boolean isSimulator) {
        return isSimulator != false ? " ^>" : " > ";
    }

    public static void dealwithItemResult(ExecuteResult result) {
        if (null == result) {
            LOGGER.error("executeResult is null.");
            return;
        }
        Object retMsgObj = result.getResultMap().get("err_msg");
        if (null == retMsgObj || Strings.isNullOrEmpty((String)retMsgObj.toString())) {
            result.setItemResultEnum(ItemResultEnum.SUCCESS);
            LOGGER.error("retMsgObj is null.");
            return;
        }
        String retMsg = retMsgObj.toString();
        if (retMsg.contains(ResourceUtil.getString((String)"infograb.python.errmsg.success"))) {
            if (!retMsg.contains(ResourceUtil.getString((String)"infograb.python.errmsg.failed")) && !retMsg.contains(ResourceUtil.getString((String)"infograb.dev.status.noecollect"))) {
                result.setItemResultEnum(ItemResultEnum.SUCCESS);
            } else {
                result.setItemResultEnum(ItemResultEnum.PARTIALSUCC);
            }
        } else if (retMsg.contains(ResourceUtil.getString((String)"infograb.python.errmsg.failed"))) {
            result.setItemResultEnum(ItemResultEnum.FAILD);
        } else if (!retMsg.contains(ResourceUtil.getString((String)"infograb.python.errmsg.failed")) && retMsg.contains(ResourceUtil.getString((String)"infograb.dev.status.noecollect"))) {
            result.setItemResultEnum(ItemResultEnum.NOTCOLLECT);
        } else {
            result.setItemResultEnum(ItemResultEnum.FAILD);
        }
    }

    public static void openHelpFile(String fileName, Window parentPara) {
        String htmlFileName = fileName + "_" + LanguageManager.getInstance().getCurrentLanguage().toString().substring(0, 2) + HELP_FILE_TYPE;
        String workDir = System.getProperty("user.dir");
        File helpFilePath = new File(workDir, HELP_FILE_DIR);
        File helpFile = new File(helpFilePath, htmlFileName);
        LOGGER.info("explorer help file:{}", (Object)htmlFileName);
        if (!helpFile.exists()) {
            if (ApplicationContext.getInstance().isJunit()) {
                return;
            }
            DialogUtils.showErrorDialog((Window)parentPara, (String)ResourceUtil.getString((String)"infograb.help.warning"));
            OperationEnum.OPEN_TOOL_HELP_DOCUMENT.failLog("");
        } else {
            OSCmdUtils.explorerFile((File)helpFile);
            OperationEnum.OPEN_TOOL_HELP_DOCUMENT.successLog("");
        }
    }

    public static void openHelpFile(Window parent, String helpLink) {
        String helpFileName;
        String helpDir = ApplicationContext.getInstance().getWorkPath() + File.separator + HELP_FILE_DIR;
        File helpFile = new File(helpDir, helpFileName = File.separator + HELP_FILE_NAME + "_" + LanguageManager.getInstance().getCurrentLanguage().toString().substring(0, 2) + HELP_FILE_TYPE);
        if (helpFile.exists()) {
            LOGGER.info("open help file {} to link page {}.", (Object)helpFileName, (Object)helpLink);
            String helpLinkCmd = HH_EXE + helpDir + helpFileName + helpLink;
            OSCmdUtils.exeExportByCmd((String)helpLinkCmd, (int)2);
        } else {
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString((String)"infograb.help.warning"));
        }
    }

    public static boolean isPaconnected(GrabDevNode1 dev) {
        if (!ToolUtils.isWindowsHost(dev)) {
            return true;
        }
        try {
            if (dev.isFileNode()) {
                return true;
            }
            WmicConnection wmicConn = (WmicConnection)WmicConnectionManager.getWmicConnection(dev);
            Future<Boolean> paConnFuture = wmicConn.getPaexecConnection().getConnectResult();
            boolean isPaConnected = paConnFuture == null ? false : paConnFuture.get();
            return isPaConnected;
        }
        catch (Exception e) {
            LOGGER.error("conn to server error", (Throwable)e);
            return false;
        }
    }

    public static boolean isPaconnected(GrabDevNode2 dev) {
        if (!ToolUtils.isWindowsHost(dev)) {
            return true;
        }
        try {
            if (dev.isFileNode()) {
                return true;
            }
            WmicConnection wmicConn = (WmicConnection)WmicConnectionManager.getWmicConnection(dev);
            Future<Boolean> paConnFuture = wmicConn.getPaexecConnection().getConnectResult();
            boolean isPaConnected = paConnFuture == null ? false : paConnFuture.get();
            return isPaConnected;
        }
        catch (Exception e) {
            LOGGER.error("conn to server error", (Throwable)e);
            return false;
        }
    }

    public static boolean isWinConnected(DevNode dev) {
        if (!ToolUtils.isWindowsHost(dev)) {
            return true;
        }
        try {
            WmicConnection wmicConn = (WmicConnection)WmicConnectionManager.getWmicConnection(dev);
            Future<Boolean> paConnFuture = wmicConn.getPaexecConnection().getConnectResult();
            boolean isPaConnected = paConnFuture == null ? false : paConnFuture.get();
            return isPaConnected;
        }
        catch (Exception e) {
            LOGGER.error("conn to server error", (Throwable)e);
            return false;
        }
    }

    public static boolean isWindowsHost(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (devNode != null && devNode.getDevTypeLevel2() != null) {
            return "Windows".equalsIgnoreCase(devNode.getDevTypeLevel2().toString());
        }
        return false;
    }

    public static boolean isWindowsHost(DevNode devNode) {
        if (devNode != null && devNode.getDevTypeLevel2() != null) {
            return "Windows".equalsIgnoreCase(devNode.getDevTypeLevel2().toString());
        }
        return false;
    }

    public static boolean isWindowsHost(GrabDevNode2 devNode) {
        if (devNode != null && devNode.getDevTypeLevel2() != null) {
            return "Windows".equalsIgnoreCase(devNode.getDevTypeLevel2().toString());
        }
        return false;
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        boolean success = false;
        for (int i = 0; i < 10; ++i) {
            ConnUtils.sleep(512);
            if (null == file || !file.exists()) continue;
            success = file.delete();
            if (success) {
                LOGGER.info("delete {} success", (Object)StringUtils.getCleanMessage((String)filePath));
            } else {
                LOGGER.info("delete {} fail, try again", (Object)StringUtils.getCleanMessage((String)filePath));
                String cmd = "cmd /C del \"" + filePath + "\" /f/s/q";
                OSCmdUtils.executeCmd((String)cmd, (int)32);
                LOGGER.info("force delete result {}", (Object)(!new File(filePath).exists() ? 1 : 0));
                if (!new File(filePath).exists()) {
                    success = true;
                    break;
                }
            }
            return success;
        }
        return success;
    }

    private static boolean isCommandNotSupport(String result, String cmd) {
        if (StringUtils.isNULLStr((String)cmd)) {
            return false;
        }
        String[] cmdWords = cmd.split(" ");
        return result.trim().startsWith('\'' + cmdWords[0] + '\'');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPathWriteAble(String path) {
        String tmpFile = path + File.separator + TEMPFILE_TEMP;
        try {
            File file = new File(tmpFile);
            boolean bl = file.createNewFile();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            ToolUtils.deleteFile(tmpFile);
        }
    }

    public static String handleCmdResult(String result, String originCmd, Map<String, String> echoValueMap) {
        if (ToolUtils.isCommandNotSupport(result, originCmd)) {
            echoValueMap.put(originCmd, ERROR_CODE_NOT_FOUND);
            result = new StringBuffer(result).append(ToolConstants.ENTER).append("TOOLKIT_EXE_CMD_FAILED").append(ToolConstants.ENTER).append(ERROR_CODE_NOT_FOUND).append(ToolConstants.ENTER).toString();
        }
        return result;
    }

    public static boolean isHavePreUpgrabdeScene() {
        boolean isHasPreUpgradeScene = false;
        BaseTaskPanel taskPanel = GrabContext.getInstance().getCurrentTask();
        if (null == taskPanel) {
            return true;
        }
        BaseTask task = taskPanel.getTask();
        if (!(task instanceof RealTimeTask)) {
            return false;
        }
        RealTimeTask rTask = (RealTimeTask)task;
        List<String> catagorys = rTask.getTaskCategory();
        String preUpgradeScene = ResourceUtil.getString((String)"infograb.item.category.pre_update_exploration");
        for (String scene : catagorys) {
            if (!preUpgradeScene.equals(scene)) continue;
            isHasPreUpgradeScene = true;
        }
        return isHasPreUpgradeScene;
    }

    public static boolean isHaveMigraScene() {
        boolean isHaveMigraScene = false;
        BaseTaskPanel taskPanel = GrabContext.getInstance().getCurrentTask();
        if (null == taskPanel) {
            return true;
        }
        BaseTask task = taskPanel.getTask();
        if (!(task instanceof RealTimeTask)) {
            return false;
        }
        RealTimeTask rTask = (RealTimeTask)task;
        List<String> catagorys = rTask.getTaskCategory();
        String migrationScene = ResourceUtil.getString((String)"infograb.item.category.data_migration");
        for (String scene : catagorys) {
            if (!migrationScene.equals(scene)) continue;
            isHaveMigraScene = true;
        }
        return isHaveMigraScene;
    }

    public static String getASMInstanceSID(String asmOracleInfo) {
        if (StringUtils.isNULLStr((String)asmOracleInfo)) {
            return null;
        }
        String result = asmOracleInfo;
        if (result.contains(ASM_PMON)) {
            String dbName = result.substring(result.indexOf(ASM_PMON) + 9);
            int idxOfBr = dbName.indexOf("\n");
            dbName = dbName.substring(0, idxOfBr);
            return dbName.replace("\r", "");
        }
        return null;
    }

    public static String getASMInstanceName(String asmOracleInfo) {
        if (StringUtils.isNULLStr((String)asmOracleInfo)) {
            LOGGER.info("the asmOracleInfo is null");
            return null;
        }
        String result = asmOracleInfo;
        try {
            for (String line : result.split("\n")) {
                if (!line.contains(ASM_PMON)) continue;
                String[] lineArr = line.trim().split("\\s+");
                return lineArr[0];
            }
        }
        catch (Exception e) {
            LOGGER.info("the asmHomeInfo is null", (Throwable)e);
        }
        return null;
    }

    public static String getASMInstanceHome(String asmHomeInfo) {
        if (StringUtils.isNULLStr((String)asmHomeInfo)) {
            LOGGER.info("the asmHomeInfo is null");
            return null;
        }
        String result = asmHomeInfo;
        String homeInfo = "";
        String dbHome = "";
        try {
            for (String line : result.split("\n")) {
                String[] lineArr;
                if (!line.contains(ASM_PMON_HOME) || (lineArr = line.trim().split("\\s+")).length <= 0) continue;
                homeInfo = lineArr[lineArr.length - 1];
                break;
            }
            dbHome = homeInfo.substring(0, homeInfo.indexOf(ASM_PMON_HOME));
        }
        catch (Exception e) {
            LOGGER.info("the asmHomeInfo is null", (Throwable)e);
            return null;
        }
        LOGGER.info("the asmHomeInfo is:{}", (Object)dbHome);
        return dbHome;
    }

    public static void setTimoutCmt2UserDate(String sn, String commd, long startTime, long endTime) {
    }

    public static void executeAddDevice2Complete(AddDeviceService addDeviceService) {
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            LOGGER.error("sleep error:", (Throwable)e);
        }
        if (null != addDeviceService) {
            LOGGER.info("execute addDeviceService");
            addDeviceService.noticeAddDevice2Complete();
        }
    }

    public static boolean isUnixSystem(GrabDevNode2 devNode) {
        return devNode.getDevTypeLevel2().toString().equalsIgnoreCase("hp-ux") || devNode.getDevTypeLevel2().toString().equalsIgnoreCase("solaris");
    }

    public static String unicodeDecode(String string) {
        Matcher matcher = PATTERN.matcher(string);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            string = string.replace(matcher.group(1), ch + "");
        }
        return string;
    }

    public static boolean write2XML(String filepath, Object object) {
        File file = new File(filepath);
        try {
            JAXBContext jaxbcontext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller jaxbMarshaller = jaxbcontext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal(object, file);
            LOGGER.info("creat xml from object successfully");
            return true;
        }
        catch (JAXBException e) {
            LOGGER.error("creat xml from object fail:", (Throwable)e);
            return false;
        }
    }

    public static <T> T read2Obj(String filepath, T hostT) throws JAXBException {
        Path path = Paths.get(filepath, new String[0]).normalize();
        JAXBContext jaxbcontext = JAXBContext.newInstance((Class[])new Class[]{hostT.getClass()});
        Unmarshaller unmarshaller = jaxbcontext.createUnmarshaller();
        return (T)unmarshaller.unmarshal(path.toFile());
    }
}

