/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils.migration;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.entity.AixHost;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.HpuxHost;
import com.huawei.ism.tool.infograb.entity.LinuxHost;
import com.huawei.ism.tool.infograb.entity.SolarisHost;
import com.huawei.ism.tool.infograb.entity.VMwareHost;
import com.huawei.ism.tool.infograb.entity.offline.WindowsHost;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.HostSensitiveCommandsEnum;
import com.huawei.ism.tool.obase.utils.AddressUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.python.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymizeUtils {
    private static final Logger log = LoggerFactory.getLogger(AnonymizeUtils.class);
    private static final String NON_WINDOWS_SEPARATOR = "*********^^^^^^^^^^************^^^^^^^^^^*********";
    private static final String WINDOWS_SEPARATOR = "###########################################################################";
    private static final String OFFLINE_CMD_START = "StartCmd:";
    private static final String UNAME_A = "uname -a";
    private static final String WINDOWS_VERSION_CMD = "wmic OS get Version /value";
    private static final String REPLACEMENT = "REPLACEMENT";
    private static final Pattern MAC_PATTERN = Pattern.compile("(\\w+\\:+){3,}\\w+");
    private static final Pattern IP_PATTERN = Pattern.compile("((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))");

    public static void anonymizeData(List<GrabDevNode2> summaryNodes, String excelPath) {
        try {
            List<GrabDevNode2> nodes = summaryNodes.stream().filter(node -> !Strings.isNullOrEmpty((String)node.getXmlFileName())).collect(Collectors.toList());
            String anonymizeDataDir = new File(excelPath).getParentFile().toString() + InfograbConstants.ANONYMIZE_DATA;
            if (!AnonymizeUtils.needToAnonymize(nodes)) {
                return;
            }
            AnonymizeUtils.anonymizeTextData(nodes, anonymizeDataDir);
            AnonymizeUtils.anonymizeExcelData(nodes, excelPath, anonymizeDataDir);
        }
        catch (Exception e) {
            log.error("handle file error: ", (Throwable)e);
        }
    }

    private static boolean needToAnonymize(List<GrabDevNode2> nodes) {
        return nodes.stream().filter(AnonymizeUtils::isNotAnonymizedData).count() > 0L;
    }

    private static void anonymizeExcelData(List<GrabDevNode2> nodes, String excelPath, String anonymizeDataDir) {
        log.info("begin to anonymize excel data");
        File target = FileUtils.getFile((String[])new String[]{anonymizeDataDir, FileUtils.getFile((String[])new String[]{excelPath}).getName()});
        try (FileInputStream fis = new FileInputStream(FilePathUtils.checkFile((String)excelPath));
             FileOutputStream fos = new FileOutputStream(target);){
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook((InputStream)fis);
            Map<String, String> fields = AnonymizeUtils.getFieldMap(nodes);
            IntStream.range(0, hssfWorkbook.getNumberOfSheets()).mapToObj(sheetIndex -> hssfWorkbook.getSheetAt(sheetIndex)).forEach(oneSheet -> AnonymizeUtils.changeOneSheet(oneSheet, fields));
            hssfWorkbook.write((OutputStream)fos);
            log.info("success to anonymize excel data");
        }
        catch (IOException e) {
            log.error("handle excel file error: ", (Throwable)e);
        }
    }

    private static void changeOneSheet(HSSFSheet oneSheet, Map<String, String> fields) {
        IntStream.range(0, oneSheet.getPhysicalNumberOfRows()).forEach(rowIndex -> AnonymizeUtils.changeOneRowData(oneSheet, rowIndex, fields));
    }

    private static void changeOneRowData(HSSFSheet oneSheet, int rowIndex, Map<String, String> fields) {
        String fillStr = oneSheet.getRow(rowIndex).getCell(0).toString();
        HSSFCell hssfCell = oneSheet.getRow(rowIndex).getCell(0);
        hssfCell.setCellValue(fields.get(fillStr.trim()) == null ? fillStr : fields.get(fillStr.trim()));
    }

    private static Map<String, String> getFieldMap(List<GrabDevNode2> nodes) {
        return nodes.stream().collect(Collectors.toMap(DevNode::getIp, node -> AnonymizeUtils.getIp2Name(node)));
    }

    private static String getIp2Name(GrabDevNode2 node) {
        String targetFileName = AnonymizeUtils.getTargetFileName(node);
        return AnonymizeUtils.getHostName(node) + "_" + targetFileName.substring(0, targetFileName.lastIndexOf("."));
    }

    private static void anonymizeTextData(List<GrabDevNode2> summaryNodes, String anonymizeDataDir) {
        log.info("begin to anonymize text data");
        summaryNodes.stream().filter(AnonymizeUtils::isNotAnonymizedData).forEach(node -> AnonymizeUtils.doAnonymizeOneHostTxtFile(node, anonymizeDataDir));
        log.info("success to anonymize text data");
    }

    private static void doAnonymizeOneHostTxtFile(GrabDevNode2 node, String anonymizeDataDir) {
        String targetFilePath = AnonymizeUtils.getTargetFilePath(anonymizeDataDir, node);
        AnonymizeUtils.createFile(targetFilePath);
        try (FileInputStream fis = new FileInputStream(AnonymizeUtils.getSourceFile(node));
             InputStreamReader inReader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inReader);
             FileOutputStream outStream = new FileOutputStream(FilePathUtils.checkFile((String)targetFilePath), true);
             BufferedOutputStream buffOut = new BufferedOutputStream(outStream);){
            AnonymizeUtils.handleTxtFile(node, reader, buffOut);
        }
        catch (IOException e) {
            log.error("fail to anonymize txt file!", (Throwable)e);
        }
    }

    private static void handleTxtFile(GrabDevNode2 node, BufferedReader reader, BufferedOutputStream buffOut) throws IOException {
        String tempLine;
        List<String> sensitiveCommands = HostSensitiveCommandsEnum.getHostSensitiveCommands(node.getDeviceName());
        String hostName = AnonymizeUtils.getHostName(node);
        StringBuilder content = new StringBuilder();
        String cmd = "";
        String cmdPrefix = AnonymizeUtils.getCmdPrefix(node);
        while ((tempLine = reader.readLine()) != null) {
            if (AnonymizeUtils.isSplitLine(tempLine) && content.length() > 0) {
                AnonymizeUtils.writeData2Text(cmd, sensitiveCommands, content, buffOut);
                content = new StringBuilder();
                cmd = "";
            }
            if (Strings.isNullOrEmpty((String)cmd) && tempLine.startsWith(cmdPrefix)) {
                cmd = tempLine.replace(cmdPrefix, "");
            }
            content.append(tempLine.replaceAll(node.getIp(), hostName) + File.separator);
        }
    }

    private static void writeData2Text(String cmd, List<String> sensitiveCommands, StringBuilder content, BufferedOutputStream buffOut) throws IOException {
        if (AnonymizeUtils.isEvalContent(content)) {
            return;
        }
        if (AnonymizeUtils.isSensitiveCommand(cmd, sensitiveCommands)) {
            AnonymizeUtils.writeData(buffOut, AnonymizeUtils.getInsensitiveContent(content.toString()));
        } else {
            AnonymizeUtils.writeData(buffOut, content.toString());
        }
    }

    private static String getInsensitiveContent(String content) {
        return MAC_PATTERN.matcher(IP_PATTERN.matcher(content).replaceAll(REPLACEMENT)).replaceAll(REPLACEMENT);
    }

    private static String getCmdPrefix(GrabDevNode2 node) {
        if (NodeAddEnum.OFFLINE_IMPORT.equals((Object)node.getNodeAddType())) {
            return OFFLINE_CMD_START;
        }
        return AnonymizeUtils.getOnlineCmdStart(node);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getOnlineCmdStart(GrabDevNode2 node) {
        try (FileReader fileReader = new FileReader(AnonymizeUtils.getSourceFile(node));
             BufferedReader reader = new BufferedReader(fileReader);){
            String tempLine = "";
            do {
                if ((tempLine = reader.readLine()) == null) return "";
            } while (!tempLine.endsWith(UNAME_A) && !tempLine.endsWith(WINDOWS_VERSION_CMD));
            String string = tempLine.replace(UNAME_A, "").replace(WINDOWS_VERSION_CMD, "");
            return string;
        }
        catch (IOException e) {
            log.error("fail to get cmd starter!", (Throwable)e);
        }
        return "";
    }

    private static String getSourceFile(GrabDevNode2 node) {
        if (NodeAddEnum.ONLINE.equals((Object)node.getNodeAddType())) {
            return AnonymizeUtils.geTxtFile(node);
        }
        return node.getDevInfoPkgPath();
    }

    private static boolean isSplitLine(String tempLine) {
        return tempLine.equals(NON_WINDOWS_SEPARATOR) || tempLine.equals(WINDOWS_SEPARATOR);
    }

    private static boolean isNotAnonymizedData(GrabDevNode2 node) {
        return AddressUtil.isValidIPV4(node.getIp()) && !"127.0.0.1".equals(node.getIp());
    }

    private static String getTargetFilePath(String anonymizeDataDir, GrabDevNode2 node) {
        return anonymizeDataDir + AnonymizeUtils.getTargetFileName(node);
    }

    private static boolean isEvalContent(StringBuilder content) {
        return Arrays.stream(content.toString().split("\n")).anyMatch(line -> line.startsWith("_needEvalCmdRtn"));
    }

    private static void createFile(String targetFilePath) {
        try {
            File file = new File(targetFilePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            file.createNewFile();
        }
        catch (IOException e) {
            log.error("creat file fail", (Throwable)e);
        }
    }

    private static boolean isSensitiveCommand(String cmdLine, List<String> sensitiveCommands) {
        return sensitiveCommands.stream().anyMatch(cmd -> cmdLine.toLowerCase(Locale.ENGLISH).contains(cmd.toLowerCase(Locale.ENGLISH)));
    }

    private static void writeData(BufferedOutputStream buffOut, String content) throws IOException {
        buffOut.write(content.getBytes(StandardCharsets.UTF_8));
        buffOut.flush();
    }

    private static String getTargetFileName(GrabDevNode2 node) {
        if (NodeAddEnum.ONLINE.equals((Object)node.getNodeAddType())) {
            return new File(AnonymizeUtils.geTxtFile(node)).getName().replace(node.getIp(), AnonymizeUtils.getHostName(node));
        }
        return new File(node.getDevInfoPkgPath()).getName().replace(node.getIp(), AnonymizeUtils.getHostName(node));
    }

    private static String getHostName(GrabDevNode2 node) {
        try {
            return AnonymizeUtils.getHostName(node.getXmlFileName(), node.getDeviceName());
        }
        catch (JAXBException e) {
            log.error("creat object from xml fail: {}", (Throwable)e);
            return "";
        }
    }

    private static String getHostName(String xmlFile, String deviceName) throws JAXBException {
        switch (deviceName) {
            case "Linux": {
                return ToolUtils.read2Obj(xmlFile, new LinuxHost()).getOverView().getHostName();
            }
            case "AIX": {
                return ToolUtils.read2Obj(xmlFile, new AixHost()).getOverView().getHostName();
            }
            case "HP-UX": {
                return ToolUtils.read2Obj(xmlFile, new HpuxHost()).getOverView().getHostName();
            }
            case "Solaris": {
                return ToolUtils.read2Obj(xmlFile, new SolarisHost()).getOverView().getHostName();
            }
            case "Windows": {
                return ToolUtils.read2Obj(xmlFile, new WindowsHost()).getOverView().getHostName();
            }
            case "VMware": {
                return ToolUtils.read2Obj(xmlFile, new VMwareHost()).getOverView().getHostName();
            }
        }
        return "";
    }

    private static String geTxtFile(GrabDevNode2 node) {
        String xmlFile = node.getXmlFileName();
        return xmlFile.substring(0, xmlFile.lastIndexOf(".")) + ".txt";
    }
}

