/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum HostSensitiveCommandsEnum {
    LINUX("Linux", Arrays.asList("cat /etc/hosts", "ifconfig -a", "netstat -anp", "netstat -rn", "ip addr", "/sbin/ifconfig", "/sbin/ip link show", "ip link show", "ifconfig")),
    AIX("AIX", Arrays.asList("cat /etc/hosts", "ifconfig -a", "prtconf", "netstat -ain", "netstat -rn", "netstat -in")),
    HPUX("HP-UX", Arrays.asList("cat /etc/hosts", "netstat -in", "ifconfig", "netstat -in")),
    SOLARIS("Solaris", Arrays.asList("cat /etc/hosts", "ifconfig -a", "ldm list -l", "ldm list -e", "ldm list -o domain -p", "ldm ls -l -p", "ldm list -l -p", "ldm list-bindings")),
    VMWARE("VMware", Arrays.asList("esxcfg-vmknic -l", "esxcfg-nas -l", "vim-cmd vmsvc/get.summary", "vim-cmd vmsvc/get.guest", "/sbin/ifconfig", "/sbin/ip link show", "ip link show")),
    WINDOWS("Windows", Arrays.asList("wmic nicconfig get IPAddress", "systeminfo", "wmic NICCONFIG get macaddress", "ipconfig /all", "route print", "\\System32\\drivers\\etc\\hosts", "wmic NICCONFIG get ipaddress,macaddress,description")),
    UNKNOWN("", Collections.emptyList());

    private final String hostDeviceName;
    private final List<String> sensitiveCommands;

    public boolean match(String deviceName) {
        return this.hostDeviceName.equals(deviceName);
    }

    public static List<String> getHostSensitiveCommands(String deviceName) {
        return Arrays.stream(HostSensitiveCommandsEnum.values()).filter(status -> status.match(deviceName)).findFirst().orElse(UNKNOWN).getSensitiveCommands();
    }

    private HostSensitiveCommandsEnum(String hostDeviceName, List<String> sensitiveCommands) {
        this.hostDeviceName = hostDeviceName;
        this.sensitiveCommands = sensitiveCommands;
    }

    public String getHostDeviceName() {
        return this.hostDeviceName;
    }

    public List<String> getSensitiveCommands() {
        return this.sensitiveCommands;
    }
}

