/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils.migration;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.runtime.SystemProperties;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.base.BaseTaskPanel;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.MigrationType;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabRefreshUI;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.utils.InfoGrabDeviceTypeUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtils {
    private static final Logger log = LoggerFactory.getLogger(MigrationUtils.class);
    public static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final String NETAPP_MAIN_LOG = "main.log";
    private static final String NETAPP_TRACE_LOG = "trace_log.log";
    private static final SystemProperties APP_CONFIGS = new SystemProperties(System.getProperty("user.dir"));
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss");

    public static boolean onlyMigrationScene(GrabDevNode2 dev) {
        BaseTask task = GrabContext.getInstance().getTaskMap().get((Object)dev);
        if (task instanceof RealTimeTask) {
            List<String> taskCategory = ((RealTimeTask)task).getTaskCategory();
            return taskCategory.size() == 1 && taskCategory.contains(ResourceUtil.getString((String)"infograb.item.category.data_migration"));
        }
        return false;
    }

    public static void setNasParseItem(ExecuteResult nasParseItem, GrabDevNode2 devNode, InfoGrabService grabService, IGrabRefreshUI uiListener) {
        nasParseItem.setDevNode(devNode);
        nasParseItem.setDescription("smartIDC_configuration_analysis");
        nasParseItem.setCureItemCollecting(true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.analyzing"));
        nasParseItem.setResultMap(map);
        grabService.fillOneResultByNode(devNode, nasParseItem);
        uiListener.updateItemProgress(devNode);
    }

    public static void setNetAppReportPath(GrabDevNode2 devNode, String taskName) {
        try {
            devNode.setDevInfoPkgPath(MigrationUtils.getNetAppReportPath(devNode, taskName));
        }
        catch (IOException e) {
            log.error("get tar.gz file name error ", (Throwable)e);
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.unTgzFail"));
        }
    }

    /*
     * Exception decompiling
     */
    public static String getNetAppReportPath(GrabDevNode2 devNode, String taskName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path getNetAppLogFilePath(GrabDevNode2 devNode, String taskName) throws IOException {
        Path logFile = Paths.get(MigrationUtils.getNetAppReportPath(devNode, taskName), NETAPP_MAIN_LOG);
        if (Files.exists(logFile, new LinkOption[0])) {
            return logFile;
        }
        return Paths.get(MigrationUtils.getNetAppReportPath(devNode, taskName), NETAPP_TRACE_LOG);
    }

    public static void setStyleAsText(HSSFWorkbook workbook, HSSFCellStyle style) {
        HSSFDataFormat format = workbook.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
    }

    public static boolean isSanScenario() {
        BaseTaskPanel currentTask = GrabContext.getInstance().getCurrentTask();
        if (Objects.isNull(currentTask) || Objects.isNull(currentTask.getTask())) {
            return true;
        }
        return MigrationType.SAN.getName().equals(currentTask.getTask().getMigrType());
    }

    public static String getToolConfigData(String key) {
        try {
            return APP_CONFIGS.getValue(key);
        }
        catch (MissingResourceException e) {
            log.error("No key in properties.");
            return "";
        }
    }

    public static int getSmartIdcGrabDuration(GrabDevNode2 devNode) {
        if (InfoGrabDeviceTypeUtil.isNetAppCMode(devNode.getDeviceName(), devNode.getDeviceModel())) {
            String duration = MigrationUtils.getToolConfigData("smartidc.grab.netapp.cmode.duration");
            if (duration.matches("\\d+")) {
                return Integer.parseInt(duration);
            }
            return 3;
        }
        return 1;
    }

    private MigrationUtils() {
    }
}

