/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils.migration;

import com.huawei.baize.base.commands.process.ProcessUtils;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.infograb.exception.IdcGrabException;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.utils.RestUtils;
import com.huawei.ism.tool.infograb.utils.migration.StopWindowsProcessUtil;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.GetRequest;
import com.huawei.ism.tool.protocol.rest.HttpSession;
import com.huawei.ism.tool.protocol.rest.PostRequest;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.migration.common.exception.execute.ExecuteOsCmdRuntimeException;
import com.huawei.migration.common.util.data.SecureRandomUtil;
import com.huawei.migration.common.util.json.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartIdcUtil {
    private static final Logger log = LoggerFactory.getLogger(SmartIdcUtil.class);
    private final Object $lock = new Object[0];
    public static final SmartIdcUtil INSTANCE = new SmartIdcUtil();
    private static final int HTTP_SOCKET_TIMEOUT = 60000;
    private static final String HOME_URL = "https://127.0.0.1:7850";
    private static final String COLLECT_URL = "https://127.0.0.1:7850/collect_all";
    private static final String PROGRESS_URL = "https://127.0.0.1:7850/single_process_progress";
    private static final String STOP_URL = "https://127.0.0.1:7850/shutdown";
    private static final String ADD_DEVICE_URL = "https://127.0.0.1:7850/device";
    private static final String PASSWORD_SET_URL = "https://127.0.0.1:7850/sec/renew";
    private static final String SECURITY_SET_URL = "https://127.0.0.1:7850/sec/set-protect-question";
    private static final String LOGIN_URL = "https://127.0.0.1:7850/sec/login";
    private static final String LANG_SET_URL = "https://127.0.0.1:7850/sys/set-lang";
    private static final String ENCODING = "UTF-8";
    private static final Path USER_PATH = Paths.get(System.getProperty("user.dir"), new String[0]);
    private static final Path IDC_UNZIP_DIR_PATH = USER_PATH.resolve("SmartIDC_Grab");
    private static final Path IDC_FILE_PATH = USER_PATH.resolve("SmartIDC_Grab.zip");
    private static final Path IDC_START_BAT_PATH = IDC_UNZIP_DIR_PATH.resolve("start.bat");
    private static final Path IDC_STOP_BAT_PATH = IDC_UNZIP_DIR_PATH.resolve("stop.bat");
    private static final Path IDC_PWD_CIPHER = IDC_UNZIP_DIR_PATH.resolve("config").resolve("smartidcgrab.cipher");
    private static final Path IDC_EXT = IDC_UNZIP_DIR_PATH.resolve("ext");
    private static final Path IDC_DB = IDC_UNZIP_DIR_PATH.resolve("IDC_GRAB.DB");
    private static final Path IDC_CERT = IDC_UNZIP_DIR_PATH.resolve("backend_files").resolve("cer").resolve("smartidc.cer");
    private static final Path IDC_CONFIG_PATH = IDC_UNZIP_DIR_PATH.resolve("config").resolve("system.ini");
    private static final String IDC_WORK_PATH = IDC_UNZIP_DIR_PATH + "\\python";
    private static final String IDC_PROCESS_PYTHON = "python.exe";
    private static final String IDC_PROCESS_PYTHONW = "pythonw.exe";
    private static final int REQUEST_RETRY_TIMES = 6;
    private static final String[] ANONYMIZE_KEYS = new String[]{"username", "password", "session", "session_id"};
    private static final int REQUEST_PERIOD = 3000;
    private static final String SMART_IDC_LIC = "SmartIDC.lic";
    private String encryptedSessionId;
    private String encryptedPassword = "";
    private String cookie;
    private long lastRequestTime = System.currentTimeMillis();
    private boolean hasIdcGrabBeenInit;
    private boolean isIdcGrabInitSuccess;

    private void configureIdc(char[] passwordChars) {
        if (!(this.hasIdcGrabBeenInit || this.configurePassword(passwordChars) && this.configureSecurity())) {
            log.error("Fail to set SmartIdc password or security.");
            return;
        }
        if (!this.login(passwordChars)) {
            log.error("Fail to login.");
            return;
        }
        this.configureLanguage();
        this.isIdcGrabInitSuccess = true;
    }

    private void modifyStartBat() throws IOException {
        File startBat = IDC_START_BAT_PATH.toFile();
        List startLines = FileUtils.readLines((File)startBat, (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.contains("start iexplore.exe")).collect(Collectors.toList());
        FileUtils.writeLines((File)startBat, startLines);
    }

    private void modifySystemIni() throws IOException {
        File systemIni = IDC_CONFIG_PATH.toFile();
        List configs = FileUtils.readLines((File)IDC_CONFIG_PATH.toFile(), (Charset)StandardCharsets.UTF_8);
        for (int i = 0; i < configs.size(); ++i) {
            String config = ((String)configs.get(i)).replace(" ", "");
            if (config.contains("cluster_collection=")) {
                configs.set(i, "cluster_collection = off");
            }
            if (!config.contains("cmode_project_type=")) continue;
            configs.set(i, "cmode_project_type = info_grab");
        }
        FileUtils.writeLines((File)systemIni, (Collection)configs);
    }

    char[] initIdcGrabPwd() {
        char[] passwordChars;
        this.readExistsCipherFile();
        if (StringUtils.isEmpty((CharSequence)this.encryptedPassword)) {
            this.randomSmartIdcPwd();
        }
        if ((passwordChars = AESEncrypt.decrypt((String)this.encryptedPassword).toCharArray()).length == 0) {
            this.randomSmartIdcPwd();
            passwordChars = AESEncrypt.decrypt((String)this.encryptedPassword).toCharArray();
        }
        return passwordChars;
    }

    private void readExistsCipherFile() {
        if (Files.exists(IDC_PWD_CIPHER, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(IDC_PWD_CIPHER);){
                this.encryptedPassword = lines.collect(Collectors.joining());
            }
            catch (IOException e) {
                log.error("failed to read SmartIDC_Grab password cipher.", (Throwable)e);
                this.encryptedPassword = "";
            }
        }
    }

    private void randomSmartIdcPwd() {
        this.encryptedPassword = AESEncrypt.encrypt((String)("A1" + SecureRandomUtil.getRandomString((int)10)));
        try {
            if (this.hasIdcGrabBeenInit) {
                this.deleteIdcDbFiles();
                this.hasIdcGrabBeenInit = false;
            }
            Files.write(IDC_PWD_CIPHER, Collections.singletonList(this.encryptedPassword), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            log.error("failed to write SmartIDC_Grab password cipher.", (Throwable)e);
        }
    }

    boolean hasIdcGrabBeenInit() {
        return Files.exists(IDC_EXT, new LinkOption[0]) && Files.exists(IDC_DB, new LinkOption[0]);
    }

    private void deleteIdcDbFiles() {
        com.huawei.ism.tool.base.utils.FileUtils.deleteFile((File)IDC_EXT.toFile());
        com.huawei.ism.tool.base.utils.FileUtils.deleteFile((File)IDC_DB.toFile());
    }

    private void checkIdcGrabInit() {
        if (!this.isIdcGrabInitSuccess) {
            throw new IdcGrabException("The SmartIDC_Grab service initiation is not completed.");
        }
    }

    private void configureLanguage() {
        this.sendRequest(LANG_SET_URL, this.getLangParams());
    }

    private boolean login(char[] passwordChars) {
        this.cookie = "";
        this.encryptedSessionId = "";
        return this.sendRequest(LOGIN_URL, this.getLoginParams(passwordChars));
    }

    private boolean configureSecurity() {
        return this.sendRequest(SECURITY_SET_URL, this.getSecurityParams());
    }

    private boolean configurePassword(char[] passwordChars) {
        return this.sendRequest(PASSWORD_SET_URL, this.getPasswordBuildParams(passwordChars));
    }

    private Map<String, Object> getSecurityParams() {
        HashMap<String, Object> jsonParams = new HashMap<String, Object>();
        jsonParams.put("question", "What's your favorite movie?");
        jsonParams.put("answers", SecureRandomUtil.getRandomString((int)10));
        return jsonParams;
    }

    private Map<String, Object> getPasswordBuildParams(char[] passwordChars) {
        HashMap<String, Object> jsonParams = new HashMap<String, Object>();
        jsonParams.put("old_key", "");
        jsonParams.put("new_key", new String(passwordChars));
        return jsonParams;
    }

    private Map<String, Object> getLoginParams(char[] passwordChars) {
        HashMap<String, Object> jsonParams = new HashMap<String, Object>();
        jsonParams.put("pass_code", new String(passwordChars));
        return jsonParams;
    }

    private Map<String, Object> getLangParams() {
        HashMap<String, Object> jsonParams = new HashMap<String, Object>();
        jsonParams.put("lang", LanguageManager.isEnglish() ? "en" : "zh");
        return jsonParams;
    }

    private boolean sendRequest(String url, Map<String, Object> params) {
        try {
            String result = this.getRequestResult(url, params);
            JSONObject jsonObject = new JSONObject(result);
            if (LOGIN_URL.equals(url)) {
                this.encryptedSessionId = AESEncrypt.encrypt((String)JsonUtil.safeGetString((JSONObject)jsonObject, (String)"data"));
            }
            return JsonUtil.safeGetString((JSONObject)jsonObject, (String)"status").equals("success");
        }
        catch (ToolException e) {
            log.error("fail to send post info.", (Throwable)e);
            return false;
        }
    }

    public JSONObject postGetTaskProcess(Map<String, Object> params) {
        try {
            JSONObject jsonObject = new JSONObject(this.getRequestResult(PROGRESS_URL, params));
            JSONArray array = jsonObject.getJSONArray("devices");
            JSONObject jsonResult = new JSONObject();
            if (array.length() >= 1) {
                jsonResult = array.getJSONObject(0);
            }
            return jsonResult;
        }
        catch (ToolException e) {
            log.error("fail to get task info.", (Throwable)e);
            return new JSONObject();
        }
    }

    public JSONObject postStartCollect(Map<String, Object> params) {
        try {
            return new JSONObject(this.getRequestResult(COLLECT_URL, params));
        }
        catch (ToolException e) {
            log.error("fail to send post info.", (Throwable)e);
            return new JSONObject();
        }
    }

    public JSONObject postAddDevice(Map<String, Object> params) throws ToolException {
        this.checkIdcGrabInit();
        String jsonStr = this.getRequestResult(ADD_DEVICE_URL, params);
        return new JSONArray(jsonStr).getJSONObject(0);
    }

    public boolean getServerStatus() {
        return this.sendRequest(HOME_URL);
    }

    public void stopServer() {
        log.info("Stop Smart IDC.");
        this.sendRequest(STOP_URL);
        this.stopSmartIdcByCmd();
        this.stopSmartIdcProcess();
    }

    private boolean sendRequest(String url) {
        try {
            GetRequest request = new GetRequest(url, ENCODING);
            this.initHeader(request);
            RestUtils.sendRequest(request, 60000L, 0);
            return true;
        }
        catch (ToolException e) {
            log.error("fail to connect to SmartIDC_Grab, error: {}.", (Object)e.getMessage());
            return false;
        }
    }

    private String getRequestResult(String url, Map<String, Object> params) throws ToolException {
        String result = this.postRequest(url, params);
        if (this.isSessionInvalid(result)) {
            this.reLoginWhenSessionIdInvalid();
            result = this.postRequest(url, params);
        }
        if (!LOGIN_URL.equals(url)) {
            log.info("SmartIDC request result json: {}", (Object)this.getAnonymizeInfo(result));
        }
        return result;
    }

    private String formatResult(String result) {
        return result.replaceAll("(\\\\)+\"", "\"").replaceAll("[\n\r]", "").replace("\"{", "{").replace("}\"", "}").replace("\"[", "[").replace("]\"", "]").replace("\\\\u", "\\u").trim();
    }

    private String getAnonymizeInfo(String json) {
        try {
            if (json.startsWith("[") && json.endsWith("]")) {
                return this.anonymize(new JSONArray(json)).toString();
            }
            return this.anonymize(new JSONObject(json)).toString();
        }
        catch (JSONException e) {
            return "Fail to parse json.";
        }
    }

    private JSONArray anonymize(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object member = jsonArray.get(i);
            if (member instanceof JSONObject) {
                this.anonymize((JSONObject)member);
            }
            if (!(member instanceof JSONArray)) continue;
            this.anonymize((JSONArray)member);
        }
        return jsonArray;
    }

    private JSONObject anonymize(JSONObject jsonObject) {
        for (String anonymizeKey : ANONYMIZE_KEYS) {
            if (!jsonObject.has(anonymizeKey)) continue;
            jsonObject.put(anonymizeKey, (Object)"******");
        }
        return jsonObject;
    }

    private boolean isSessionInvalid(String requestResult) {
        if (!requestResult.startsWith("{") || !requestResult.endsWith("}")) {
            return false;
        }
        try {
            return JsonUtil.safeGetString((JSONObject)new JSONObject(requestResult), (String)"errmsg").equalsIgnoreCase("invalid-session-id.");
        }
        catch (JSONException e) {
            log.error("Fail to parse json when check SmartIDC_Grab session.");
            return false;
        }
    }

    private void reLoginWhenSessionIdInvalid() {
        this.login(AESEncrypt.decrypt((String)this.encryptedPassword).toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postRequest(String url, Map<String, Object> params) throws ToolException {
        Object object = this.$lock;
        synchronized (object) {
            String string;
            if (System.currentTimeMillis() - this.lastRequestTime < 3000L) {
                HttpSession.silentSleep(3000, TimeUnit.MILLISECONDS);
            }
            log.info("SmartIDC request: {}", (Object)url);
            PostRequest request = new PostRequest(url, ENCODING);
            this.addParams(request, params);
            this.initHeader(request);
            try {
                string = this.sendRequest(url, request);
            }
            catch (Throwable throwable) {
                this.lastRequestTime = System.currentTimeMillis();
                throw throwable;
            }
            this.lastRequestTime = System.currentTimeMillis();
            return string;
        }
    }

    private String sendRequest(String url, PostRequest request) throws ToolException {
        ResponseInfo responseInfo = RestUtils.sendRequest(request, SmartIdcUtil.getTimeout(url), 6);
        String result = responseInfo.getContent();
        if (LOGIN_URL.equals(url)) {
            this.cacheCookie(responseInfo.getHeaders());
        }
        return this.formatResult(result);
    }

    private static long getTimeout(String url) {
        return ADD_DEVICE_URL.equals(url) ? 600000L : 60000L;
    }

    private void cacheCookie(Header[] responseHeaders) {
        Arrays.stream(responseHeaders).filter(header -> header.getName().equals("Set-Cookie")).findFirst().map(NameValuePair::getValue).ifPresent(value -> {
            this.cookie = value.split(";")[0].trim();
        });
    }

    private void addParams(PostRequest request, Map<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> keyVal : params.entrySet()) {
                request.addParam(keyVal.getKey(), keyVal.getValue());
            }
        }
    }

    public void startSmartIDC() {
        if (this.getServerStatus()) {
            log.info("smartIDC is running");
            return;
        }
        try {
            if (!this.isSmartIdcUnzip()) {
                ZipUtils.decompressFile((File)IDC_FILE_PATH.toFile(), (String)IDC_UNZIP_DIR_PATH.toString());
            }
            this.copyIdcLic();
            this.modifyStartBat();
            this.modifySystemIni();
            char[] passwordChars = this.initIdcGrabPwd();
            this.startSmartIdcServer();
            if (this.checkAndWaitSmartIdcServer()) {
                this.configureIdc(passwordChars);
            } else {
                log.error("Failed to start SmartIDC_Grab.");
            }
        }
        catch (Exception e) {
            log.error("failed to start smartIDC.", (Throwable)e);
        }
    }

    private void copyIdcLic() throws IOException {
        Path licFromPath = USER_PATH.resolve(SMART_IDC_LIC);
        Path licToPath = IDC_UNZIP_DIR_PATH.resolve(SMART_IDC_LIC);
        if (Files.exists(licFromPath, new LinkOption[0]) && Files.notExists(licToPath, new LinkOption[0])) {
            Files.move(licFromPath, licToPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private boolean isSmartIdcUnzip() {
        return Files.exists(IDC_UNZIP_DIR_PATH, new LinkOption[0]) && Files.exists(IDC_START_BAT_PATH, new LinkOption[0]);
    }

    private void startSmartIdcServer() {
        try {
            this.hasIdcGrabBeenInit = this.hasIdcGrabBeenInit();
            FutureTask<Boolean> future = new FutureTask<Boolean>(this::getStartIdcCallable);
            new Thread(future).start();
            future.get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("execute start SmartIDC_Grab command error.", (Throwable)e);
        }
    }

    private boolean checkAndWaitSmartIdcServer() {
        for (int i = 0; i < 24; ++i) {
            log.info("Waiting smartIdc to start.");
            ConnUtils.sleep(5000);
            if (!this.getServerStatus()) continue;
            return true;
        }
        return false;
    }

    private boolean getStartIdcCallable() {
        try {
            ProcessUtils.run((long)20L, (TimeUnit)TimeUnit.SECONDS, (String[])new String[]{"cmd.exe", "/c", IDC_START_BAT_PATH.toString()});
            OperationEnum.START_SMART_IDC.successLog("");
            return true;
        }
        catch (Exception e) {
            log.error("Failed to start SmartIDC-grab", (Throwable)e);
            OperationEnum.START_SMART_IDC.failLog("");
            return false;
        }
    }

    private void stopSmartIdcByCmd() {
        try {
            ProcessUtils.run((long)20L, (TimeUnit)TimeUnit.SECONDS, (String[])new String[]{"cmd.exe", "/c", IDC_STOP_BAT_PATH.toString(), " && exit"});
            OperationEnum.CLOSE_SMART_IDC.successLog("");
        }
        catch (Exception e) {
            log.error("Failed to stop SmartIDC-grab", (Throwable)e);
            OperationEnum.CLOSE_SMART_IDC.failLog("");
        }
    }

    private void stopSmartIdcProcess() {
        try {
            StopWindowsProcessUtil.stopWindowsProcess(IDC_PROCESS_PYTHONW, IDC_WORK_PATH);
            StopWindowsProcessUtil.stopWindowsProcess(IDC_PROCESS_PYTHON, IDC_WORK_PATH);
        }
        catch (ExecuteOsCmdRuntimeException e) {
            log.error("failed to execute stop SmartIDC_Grab process command.", (Throwable)e);
        }
    }

    private void initHeader(RequestInfo requestInfo) {
        requestInfo.setHeader("Accept", "application/json");
        requestInfo.setHeader("Connection", "keep-alive");
        requestInfo.setHeader("Content-Type", "application/json");
        requestInfo.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.encryptedSessionId}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.cookie})) {
            requestInfo.setHeader("Session-Id", AESEncrypt.decrypt((String)this.encryptedSessionId));
            requestInfo.setHeader("Cookie", this.cookie);
        }
    }

    public String getLogDir(String migrType, String deviceName, String deviceModel, String ip) {
        return InfoGrabDirPropertiesUtil.getProperty() + File.separator + migrType + "-" + deviceName + "-" + deviceModel + "-" + ip;
    }

    public static Path getIdcCert() {
        return IDC_CERT;
    }

    private SmartIdcUtil() {
    }

    public String getEncryptedSessionId() {
        return this.encryptedSessionId;
    }

    void setHasIdcGrabBeenInit(boolean hasIdcGrabBeenInit) {
        this.hasIdcGrabBeenInit = hasIdcGrabBeenInit;
    }
}

