/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils.migration;

import com.huawei.migration.common.util.execute.OsCommandExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StopWindowsProcessUtil {
    public static void stopWindowsProcess(String processName, String workPath) {
        List<ProcessRunInfo> processRunInfos = StopWindowsProcessUtil.getProcessRunInfos(processName);
        StopWindowsProcessUtil.stopProcess(processName, workPath, processRunInfos);
    }

    private static void stopProcess(String processName, String workPath, List<ProcessRunInfo> processRunInfos) {
        for (ProcessRunInfo processRunInfo : processRunInfos) {
            if (!processName.equals(processRunInfo.getName()) || !processRunInfo.getPath().contains(workPath)) continue;
            OsCommandExecutor.executeWindowsCmd((String)("taskkill /f /pid " + processRunInfo.getPid()));
        }
    }

    static List<ProcessRunInfo> getProcessRunInfos(String processName) {
        List result = OsCommandExecutor.executeWindowsCmd((String)("wmic process where name='" + processName + "'"));
        boolean start = false;
        Map<String, HeaderIndexes> headerIndexesMap = new HashMap<String, HeaderIndexes>();
        ArrayList<ProcessRunInfo> processRunInfos = new ArrayList<ProcessRunInfo>();
        for (String line : result) {
            if (!start && line.contains("Caption") && line.contains("ExecutablePath") && line.contains("Handle")) {
                start = true;
                headerIndexesMap = StopWindowsProcessUtil.parseHeaderIndexesMap(line);
                continue;
            }
            if (!start || !line.startsWith(processName)) continue;
            processRunInfos.add(new ProcessRunInfo(line, headerIndexesMap));
        }
        return processRunInfos;
    }

    private static Map<String, HeaderIndexes> parseHeaderIndexesMap(String headersLine) {
        HashMap<String, HeaderIndexes> headerIndexesMap = new HashMap<String, HeaderIndexes>();
        String[] headers = headersLine.trim().split("\\s+");
        String lastHeader = "";
        for (String header : headers) {
            if (!lastHeader.isEmpty()) {
                headerIndexesMap.put(lastHeader, new HeaderIndexes(headersLine.indexOf(lastHeader), headersLine.indexOf(header)));
            }
            lastHeader = header;
        }
        headerIndexesMap.put(lastHeader, new HeaderIndexes(headersLine.indexOf(lastHeader), headersLine.length()));
        return headerIndexesMap;
    }

    private StopWindowsProcessUtil() {
    }

    static class ProcessRunInfo {
        private final String name;
        private final String pid;
        private final String path;

        ProcessRunInfo(String line, Map<String, HeaderIndexes> headerIndexesMap) {
            this.name = this.parseProcessInfo(line, headerIndexesMap.get("Caption"));
            this.pid = this.parseProcessInfo(line, headerIndexesMap.get("Handle"));
            this.path = this.parseProcessInfo(line, headerIndexesMap.get("ExecutablePath"));
        }

        private String parseProcessInfo(String line, HeaderIndexes headerIndexes) {
            return line.substring(headerIndexes.getStart(), headerIndexes.getEnd()).trim();
        }

        public String getName() {
            return this.name;
        }

        public String getPid() {
            return this.pid;
        }

        public String getPath() {
            return this.path;
        }
    }

    private static class HeaderIndexes {
        private final int start;
        private final int end;

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public HeaderIndexes(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

