/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.utils.ssh;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.utils.UiUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.migration.common.ssh.TrustedSshConnectionChecker;
import java.awt.Window;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionSecurityChecker {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionSecurityChecker.class);
    private Window deviceAddDialog;
    private Collection<GrabDevNode1> nodes;

    public boolean check() {
        if (!ApplicationContext.getInstance().isVerifySshHostKeyForStorage()) {
            log.info("No need to check ssh connection in properties.");
            return true;
        }
        log.info("Start checking ssh connection.");
        return UiUtil.asyncExecute(this.deviceAddDialog, Boolean.class, () -> new TrustedSshConnectionChecker(this.deviceAddDialog).isBatchDeviceSshTrusted(this.getHostDevNodes(this.nodes))).orElse(false);
    }

    private Collection<DevNode> getHostDevNodes(Collection<GrabDevNode1> nodes) {
        return nodes.stream().filter(this::isNeedCheck).collect(Collectors.toList());
    }

    private boolean isNeedCheck(GrabDevNode1 devNode) {
        return devNode instanceof DevNode && ObjectUtils.isEmpty(devNode.getSshForwardList());
    }

    public SshConnectionSecurityChecker(Window deviceAddDialog, Collection<GrabDevNode1> nodes) {
        this.deviceAddDialog = deviceAddDialog;
        this.nodes = nodes;
    }
}

