/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.checkboxtree;

import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckLabelPanel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.ui.swing.TernaryCheckBox;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CheckTreeCellEditor
extends DefaultCellEditor {
    private CheckTreeNode node = null;
    private JTree tree = null;
    private CheckLabelPanel chkPanel = null;
    private static final long serialVersionUID = 276774752723956344L;

    public CheckTreeCellEditor(CheckLabelPanel clPanel) {
        super((JCheckBox)clPanel.getCheckBox());
        this.chkPanel = clPanel;
        clPanel.getCheckBox().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TernaryCheckBox checkbox = (TernaryCheckBox)changeEvent.getSource();
                boolean isSelected = checkbox.isSelected();
                if (isSelected == CheckTreeCellEditor.this.node.isSelected()) {
                    return;
                }
                CheckTreeCellEditor.this.node.setAction(true);
                CheckTreeCellEditor.this.node.setSelected(isSelected);
                CheckTreeCellEditor.this.node.setAction(false);
                if (CheckTreeCellEditor.this.tree != null) {
                    CheckTreeCellEditor.this.tree.repaint();
                }
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object valueObj, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = jTree.convertValueToText(valueObj, isSelected, expanded, leaf, row, false);
        CheckLabelPanel clPanel = this.chkPanel;
        this.node = (CheckTreeNode)valueObj;
        if (!this.node.isHasCheckBox()) {
            clPanel = new CheckLabelPanel(false);
        }
        this.tree = jTree;
        TernaryCheckBox box = clPanel.getCheckBox();
        box.setSelected(this.node.isSelected());
        box.setEnabled(this.node.isCheckEnable());
        clPanel.getTreeLabel().setFont(jTree.getFont());
        clPanel.getTreeLabel().setText(stringValue);
        clPanel.getTreeLabel().setSelected(true);
        return clPanel;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.node != null) {
            return this.node.getUserObject();
        }
        return null;
    }

    public CheckTreeNode getNode() {
        return this.node;
    }
}

