/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.checkboxtree;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class CheckTreeNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private static final long serialVersionUID = 1L;
    private List<String> setDefaultSelectList = Collections.unmodifiableList(Arrays.asList(ResourceUtil.getString("default_select_item_recent_fault_disklog")));
    private List<String> bondingBrotherNodesIds = new ArrayList<String>();
    private boolean selected = false;
    private boolean checkEnable = true;
    private boolean expanded;
    private String description;
    private boolean hasCheckBox = true;
    private boolean partSelect = false;
    private boolean partSingleSelect = false;
    private boolean singleSelect = false;
    private boolean defaultSelect = true;
    private boolean hilight;
    private String toolTips = this.toString();
    private String nodeId;
    private int selectionMode;
    private CheckTreeNode groupRootNode = null;
    private boolean globalSingleSelect = false;
    private boolean action = false;

    public CheckTreeNode() {
        this(null);
    }

    public CheckTreeNode(Object userObject) {
        this(userObject, true, false);
    }

    public CheckTreeNode(Object userObject, boolean allowsChildren, boolean isSelected) {
        super(userObject, allowsChildren);
        this.selected = isSelected;
        this.setSelectionMode(4);
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public boolean isPartSingleSelect() {
        return this.partSingleSelect;
    }

    public void setPartSingleSelect(boolean partSingleSelect) {
        this.partSingleSelect = partSingleSelect;
    }

    public void setSelected(boolean isSelected) {
        if (this.globalSingleSelect && this.action && isSelected) {
            this.setRootNodeSelected(false);
        }
        this.setChildrenSelected(isSelected);
        this.setFatherSelected(isSelected);
        this.setBrothersSelected(this.singleSelect, isSelected);
        this.setBondingNodesSelected(isSelected);
        this.setGroupSelected(isSelected);
    }

    private void setRootNodeSelected(boolean select) {
        CheckTreeNode rootNode = this.getRootNode();
        if (null != rootNode) {
            rootNode.setSelected(this.selected);
        }
    }

    private CheckTreeNode getRootNode() {
        CheckTreeNode parent = (CheckTreeNode)this.getParent();
        while (null != parent.getParent()) {
            parent = (CheckTreeNode)parent.getParent();
        }
        return parent;
    }

    private void setGroupSelected(boolean isSelected) {
        if (null == this.groupRootNode || !isSelected) {
            return;
        }
        CheckTreeNode father = (CheckTreeNode)this.groupRootNode.getParent();
        if (null != father) {
            Enumeration e = father.children.elements();
            while (e.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)e.nextElement();
                if (this.groupRootNode == node || !node.isPartSelect() && !node.isSelected()) continue;
                node.setSelected(false);
                node.setPartSelect(false);
            }
        }
    }

    public void setNonImmediateFamily(boolean isSelected) {
        CheckTreeNode father = (CheckTreeNode)this.getParent();
        if (null == father) {
            return;
        }
        Enumeration fe = father.children.elements();
        while (fe.hasMoreElements()) {
            CheckTreeNode node = (CheckTreeNode)fe.nextElement();
            if (node == this) continue;
            node.selected = isSelected;
            Enumeration ce = node.children.elements();
            while (ce.hasMoreElements()) {
                CheckTreeNode cd = (CheckTreeNode)ce.nextElement();
                cd.selected = isSelected;
            }
        }
        CheckTreeNode grandfather = (CheckTreeNode)father.getParent();
        if (null == grandfather) {
            return;
        }
        Enumeration ge = grandfather.children.elements();
        while (ge.hasMoreElements()) {
            CheckTreeNode node = (CheckTreeNode)ge.nextElement();
            if (node == father) continue;
            node.selected = isSelected;
            Enumeration ce = node.children.elements();
            while (ce.hasMoreElements()) {
                CheckTreeNode cd = (CheckTreeNode)ce.nextElement();
                cd.selected = isSelected;
            }
        }
    }

    private void setBrothersSelected(boolean singleSel, boolean isSelected) {
        if (!singleSel) {
            return;
        }
        CheckTreeNode father = (CheckTreeNode)this.getParent();
        if (null != father && isSelected) {
            Enumeration e = father.children.elements();
            while (e.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)e.nextElement();
                if (father.partSingleSelect && !node.singleSelect || node == this) continue;
                node.selected = false;
            }
        }
    }

    private void setBondingNodesSelected(boolean isSelected) {
        if (this.bondingBrotherNodesIds.isEmpty()) {
            return;
        }
        CheckTreeNode father = (CheckTreeNode)this.getParent();
        if (father != null && isSelected) {
            Enumeration e = father.children.elements();
            while (e.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)e.nextElement();
                if (!this.bondingBrotherNodesIds.contains(node.getNodeId())) continue;
                node.setSelected(true);
            }
        }
    }

    public void setExpanded(boolean isExpanded) {
        this.expanded = isExpanded;
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)e.nextElement();
                node.setExpanded(isExpanded);
            }
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setCheckEnable(boolean isEnable) {
        this.checkEnable = isEnable;
    }

    public boolean isCheckEnable() {
        return this.checkEnable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setChildrenSelected(boolean isSelected) {
        this.selected = isSelected;
        this.setPartSelect(false);
        if (isSelected && this.singleSelect) {
            this.selected = this.defaultSelect;
        }
        if (!this.defaultSelect && this.setDefaultSelectList.contains(this.toolTips)) {
            this.defaultSelect = true;
        }
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration em = this.children.elements();
            while (em.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)em.nextElement();
                node.setChildrenSelected(isSelected);
            }
        }
    }

    protected void setFatherSelected(boolean isSelected) {
        this.selected = isSelected;
        CheckTreeNode node = (CheckTreeNode)this.getParent();
        if (null != node) {
            boolean isFatherSelected = true;
            Enumeration em = node.children.elements();
            int notSelectCount = 0;
            int allSize = 0;
            int partSelectcount = 0;
            while (em.hasMoreElements()) {
                CheckTreeNode child = (CheckTreeNode)em.nextElement();
                if (!child.selected) {
                    isFatherSelected = false;
                    ++notSelectCount;
                }
                if (child.partSelect) {
                    ++partSelectcount;
                }
                ++allSize;
            }
            if (0 != partSelectcount) {
                node.setPartSelect(true);
            } else if (allSize != notSelectCount) {
                node.setPartSelect(allSize - notSelectCount != allSize);
            } else {
                node.setPartSelect(false);
            }
            node.setFatherSelected(isFatherSelected);
        }
    }

    public String getToolTips() {
        return this.toolTips;
    }

    public void setToolTips(String toolTips) {
        this.toolTips = toolTips;
    }

    public boolean isHasCheckBox() {
        return this.hasCheckBox;
    }

    public void setHasCheckBox(boolean hasCheckBox) {
        this.hasCheckBox = hasCheckBox;
    }

    public boolean isHilight() {
        return this.hilight;
    }

    public void setHilight(boolean hilight) {
        this.hilight = hilight;
    }

    public boolean isPartSelect() {
        return this.partSelect;
    }

    public void setPartSelect(boolean partSelect) {
        this.partSelect = partSelect;
    }

    public void addBondingNodeIds(List<String> nodeIds) {
        this.bondingBrotherNodesIds.addAll(nodeIds);
    }

    public void setSingleSelect(boolean singleSelect) {
        this.singleSelect = singleSelect;
    }

    public void setDefaultSelect(boolean defaultSelect) {
        this.defaultSelect = defaultSelect;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    public Object getGroup() {
        return this.groupRootNode;
    }

    public void setGroup(CheckTreeNode groupRootNode) {
        this.groupRootNode = groupRootNode;
    }

    public void setGlobalSingleSelect(boolean globalSingleSelect) {
        this.globalSingleSelect = globalSingleSelect;
    }

    public void setAction(boolean action) {
        this.action = action;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }
}

