/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.wizard;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.flow.FlowFactory;
import com.huawei.ism.tool.obase.flow.ui.Title;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardHeadPanel;
import com.huawei.ism.tool.obase.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.InputStream;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JPanel;

public class VerticalFlowWizardDialog
extends FlowWizardDialog {
    private static final long serialVersionUID = 3698424153310775593L;

    public VerticalFlowWizardDialog(Window parent, Locale loc, FlowFactory flowFactory, Icon icon) throws ToolException {
        super(parent, loc, flowFactory);
        WizardHeadPanel stepsPanel = this.getStepsPanel();
        if (null == stepsPanel) {
            throw new ToolException("init erro");
        }
        stepsPanel.setIcon(icon);
    }

    public VerticalFlowWizardDialog(Window parent, Locale loc, ClassLoader clsLoader, InputStream defXmlStream, InputStream flowXmlStream, Icon icon) throws ToolException {
        super(parent, loc, clsLoader, defXmlStream, flowXmlStream);
        WizardHeadPanel stepsPanel = this.getStepsPanel();
        if (null == stepsPanel) {
            throw new ToolException("init erro");
        }
        stepsPanel.setIcon(icon);
    }

    @Override
    protected JPanel getWizardPanel() {
        JPanel pane = new JPanel(new BorderLayout());
        this.setStepsPanel(new WizardHeadPanel(null, "", ""));
        Dimension dim = new Dimension(100, 75);
        this.getStepsPanel().setPreferredSize(dim);
        this.getStepsPanel().setMinimumSize(dim);
        pane.add((Component)this.getStepsPanel(), "North");
        pane.add((Component)this.getContentPane(), "Center");
        pane.add((Component)this.getSouthBox(), "South");
        return pane;
    }

    @Override
    protected void updateTitle(int index) {
        StringBuffer dialogTitle = new StringBuffer();
        dialogTitle.append(this.getWizardTitle()).append(" ");
        dialogTitle.append(this.getStageTitles().size()).append("-").append(index + 1);
        this.setTitle(dialogTitle.toString());
        Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
        Title wizardTitle = this.getStageTitles().get(index);
        this.getStepsPanel().setTitle(wizardTitle.getName(locale));
        this.getStepsPanel().setDesc(wizardTitle.getDesc(locale));
    }
}

