/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.ui.swing.chart.IsmChartFactory;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.category.CategoryDataset;

public final class BarChartBuilder {
    private static final Color MINORALARMCOLOR = new Color(14993495);
    private static final Color IMPORTANTALARMCOLOR = new Color(15508023);
    private static final Color NORMALCOLOR = new Color(8705131);
    private static final int CHART_WIDTH = 800;
    private static final int CHART_HEIGHT = 500;

    private BarChartBuilder() {
    }

    public static JFreeChart createChart(CategoryDataset dataset, String chartTitle, String valueTitle) {
        JFreeChart chart = IsmChartFactory.createBarChart((CategoryDataset)dataset, (String)chartTitle, (String)"", (String)valueTitle, (PlotOrientation)PlotOrientation.VERTICAL);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setDomainCrosshairPaint((Paint)Color.RED);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(BarChartBuilder.createIntegerTickUnits());
        rangeAxis.setRange(0.0, 105.0);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(true);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.954929658551372));
        plot.setRenderer((CategoryItemRenderer)BarChartBuilder.getRenderer3D(dataset));
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setMinimumBarLength(0.03);
        renderer.setMaximumBarWidth(0.04);
        renderer.setItemMargin(0.06);
        LegendTitle title = chart.getLegend();
        title.visible = false;
        return chart;
    }

    public static BarRenderer getRenderer3D(CategoryDataset dataset) {
        AdvanceColorRenderer3D renderer = new AdvanceColorRenderer3D(dataset);
        renderer.setDefaultOutlinePaint(Color.BLACK);
        renderer.setIncludeBaseInRange(true);
        renderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setDefaultItemLabelsVisible(true);
        ItemLabelPosition itemLabelPositionFallback = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER, TextAnchor.HALF_ASCENT_RIGHT, 0.0);
        renderer.setPositiveItemLabelPositionFallback(itemLabelPositionFallback);
        renderer.setNegativeItemLabelPositionFallback(itemLabelPositionFallback);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.BASELINE_CENTER, TextAnchor.BASELINE_CENTER, 0.0);
        renderer.setDefaultPositiveItemLabelPosition(itemLabelPosition);
        renderer.setDefaultNegativeItemLabelPosition(itemLabelPosition);
        renderer.setDefaultPaint(new Color(215, 215, 215));
        return renderer;
    }

    public static TickUnitSource createIntegerTickUnits() {
        TickUnits units = new TickUnits();
        DecimalFormat df0 = new DecimalFormat("0");
        units.add((TickUnit)new NumberTickUnit(10.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(20.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(30.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(40.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(50.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(60.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(70.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(80.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(90.0, (NumberFormat)df0, 2));
        units.add((TickUnit)new NumberTickUnit(100.0, (NumberFormat)df0, 2));
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChart2File(File chartFile, JFreeChart chart) {
        BufferedImage buffer = chart.createBufferedImage(800, 500);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(chartFile);
            ImageIO.write((RenderedImage)buffer, "GIF", output);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(BarChartBuilder.class).error("writeChart2File error.", e);
        }
        finally {
            StreamUtils.closeStream(output, null);
        }
    }

    private static class AdvanceColorRenderer3D
    extends BarRenderer {
        private static final long serialVersionUID = 1L;
        private CategoryDataset dataset;

        public AdvanceColorRenderer3D(CategoryDataset dataset) {
            this.dataset = dataset;
        }

        public Paint getItemPaint(int row, int column) {
            Number value = this.dataset.getValue(row, column);
            if (null == value) {
                return super.getItemPaint(row, column);
            }
            int val = value.intValue();
            if (100 == val) {
                return NORMALCOLOR;
            }
            if (val >= 80) {
                return MINORALARMCOLOR;
            }
            return IMPORTANTALARMCOLOR;
        }
    }
}

