/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.UnZipLimit;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.file.FileTypeUtils;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSizeUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipSizeUtils.class);
    private static final int BUFFER_SIZE = 2048;
    private static final String[] FILECODE_ZIP = new String[]{"504b30", "504b03"};
    private static final String[] FILECODE_TARGZ = new String[]{"1f8b"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long unTarSize(InputStream inputStream) {
        long wholeSize = 0L;
        UnZipLimit unZipLimit = new UnZipLimit();
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(inputStream, 2048);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                wholeSize += entry.getSize();
                unZipLimit.increaseOneFileNum();
                ZipUtils.checkUnzipLimit((UnZipLimit)unZipLimit);
            }
            log.info("filesize= {} byte", (Object)wholeSize);
            long l = wholeSize;
            return l;
        }
        catch (FileNotFoundException e) {
            log.error("unTarSize method may have file not found");
            return unZipLimit.getMaxSize();
        }
        catch (IOException e) {
            log.error("unTarSize may have some error", e);
            return unZipLimit.getMaxSize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long unTar(String tarFilePath) throws IOException {
        File file = new File(tarFilePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            long l = ZipSizeUtils.unTarSize(inputStream);
            return l;
        }
        catch (FileNotFoundException e) {
            log.error("invalid fil:{}", (Object)file.getName());
            throw new IOException(String.format(Locale.ROOT, "unTar %s fail", file.getName()));
        }
    }

    /*
     * Exception decompiling
     */
    private static long unTarGZ(String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static long unTarBZip2(String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long unBZip2(String bzip2File, String destDir) throws Exception {
        File file = new File(bzip2File);
        return ZipSizeUtils.unBZip2Size(file, destDir);
    }

    private static long unBZip2Size(File srcFile, String destDir) throws Exception {
        long l;
        long wholesize = 0L;
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = srcFile.getParent();
            destDir = FileAssistant.getRandomTmpDir(destDir);
            log.info("destDir={}", (Object)destDir);
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        BZip2CompressorInputStream is = null;
        BufferedOutputStream os = null;
        try {
            File destFile = new File(destDir, FilenameUtils.getBaseName((String)srcFile.toString()));
            is = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(srcFile), 2048));
            os = new BufferedOutputStream(new FileOutputStream(destFile), 2048);
            wholesize = IOUtils.copy((InputStream)is, (OutputStream)os);
            destFile.deleteOnExit();
            FileUtils.deleteFile(destFile);
            l = wholesize;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                FileUtils.close(new Closeable[]{os, is});
                throw throwable;
            }
        }
        FileUtils.close(new Closeable[]{os, is});
        return l;
    }

    private static long unGZ(String gzFile, String destDir) throws Exception {
        File file = new File(gzFile);
        return ZipSizeUtils.unGZ(file, destDir);
    }

    private static long unGZ(File srcFile, String destDir) throws Exception {
        long l;
        long wholesize = 0L;
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = srcFile.getParent();
            destDir = FileAssistant.getRandomTmpDir(destDir);
            if (log.isInfoEnabled()) {
                log.info("destDir=" + destDir);
            }
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        GzipCompressorInputStream is = null;
        BufferedOutputStream os = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            File destFile = new File(destDir, FilenameUtils.getBaseName((String)srcFile.toString()));
            fileInputStream = new FileInputStream(srcFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            is = new GzipCompressorInputStream((InputStream)bufferedInputStream);
            fileOutputStream = new FileOutputStream(destFile);
            os = new BufferedOutputStream(fileOutputStream, 2048);
            wholesize = IOUtils.copy((InputStream)is, (OutputStream)os);
            destFile.deleteOnExit();
            l = wholesize;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                FileUtils.close(new Closeable[]{fileOutputStream, bufferedInputStream, fileInputStream, os, is});
                throw throwable;
            }
        }
        FileUtils.close(new Closeable[]{fileOutputStream, bufferedInputStream, fileInputStream, os, is});
        return l;
    }

    private static long unZipSize(File zipfile) {
        long wholeSize = 0L;
        UnZipLimit limit = new UnZipLimit();
        try (FileInputStream fileInputStream = new FileInputStream(zipfile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
             ZipArchiveInputStream is = new ZipArchiveInputStream((InputStream)bufferedInputStream);){
            ZipArchiveEntry entry;
            log.info("filename=:{}", (Object)zipfile.getCanonicalPath());
            while ((entry = is.getNextZipEntry()) != null) {
                wholeSize += entry.getSize();
                limit.increaseOneFileNum();
                ZipUtils.checkUnzipLimit((UnZipLimit)limit);
            }
        }
        catch (FileNotFoundException e) {
            log.error("invalid file :{}", (Object)zipfile.getName());
            wholeSize = limit.getMaxSize();
        }
        catch (IOException e) {
            log.error("unZipSize fail!", e);
            wholeSize = limit.getMaxSize();
        }
        if (log.isInfoEnabled()) {
            log.info("filesize={} byte", (Object)wholeSize);
        }
        return wholeSize;
    }

    private static long unZip(String zipfile) {
        File zipFile = new File(zipfile);
        return ZipSizeUtils.unZipSize(zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static long getRealSize(String compressFile) {
        log.info("-------------getRealSize::begin--------");
        long ffilesize = 0L;
        long lfilesize = 0L;
        long rfilesize = 0L;
        try {
            File zipFile = new File(compressFile);
            rfilesize = ffilesize = zipFile.length();
            lfilesize = ZipSizeUtils.dealCompress(compressFile, null);
            if (log.isInfoEnabled()) {
                log.info("before uncompress, filesize=" + ffilesize + " byte");
                log.info("after compress, filesize=" + lfilesize + " byte");
            }
            if (lfilesize > 0L && ffilesize < lfilesize) {
                rfilesize = lfilesize;
            }
            if (log.isInfoEnabled()) {
                log.info("real filesize=" + rfilesize + " byte");
            }
            long l = rfilesize;
            return l;
        }
        catch (Exception e) {
            log.error("real filesize=" + rfilesize + " byte");
            log.error("getRealSize fail!", e);
            long l = rfilesize;
            return l;
        }
        finally {
            log.info("-------------getRealSize::end----------");
        }
    }

    private static long dealCompress(String compressFile, String destDir) throws Exception {
        long allfilesize = 0L;
        String filecode = ZipSizeUtils.getfilecode(compressFile);
        try {
            log.info("unCompressByName");
            allfilesize = ZipSizeUtils.unCompressSizeByName(compressFile, destDir);
            if (allfilesize == 0L) {
                throw new Exception("unCompressByName fail!");
            }
        }
        catch (Exception e) {
            log.error("unCompressByName fail!");
            try {
                allfilesize = ZipSizeUtils.unCompressSizeByCode(compressFile, filecode);
            }
            catch (Exception ex) {
                log.error("unCompressSizeByCode fail!");
            }
        }
        return allfilesize;
    }

    private static boolean matchCompressType(String fileCode, String[] filetypes) {
        if (fileCode == null || filetypes == null) {
            return false;
        }
        for (String filetype : filetypes) {
            if (!fileCode.toLowerCase(Locale.ENGLISH).startsWith(filetype.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getfilecode(String compressFile) {
        String filecode;
        FileInputStream is;
        block4: {
            is = null;
            filecode = null;
            try {
                is = new FileInputStream(compressFile);
                filecode = FileTypeUtils.getFileCode(is);
                if (!log.isInfoEnabled()) break block4;
                log.info("filecode=" + filecode);
            }
            catch (Throwable ex) {
                try {
                    log.error("getfilecode fail!");
                }
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    throw throwable;
                }
                FileUtils.close(is);
            }
        }
        FileUtils.close(is);
        return filecode;
    }

    private static long unCompressSizeByName(String compressFile, String destDir) throws Exception {
        String upperName = compressFile.toUpperCase(Locale.ENGLISH);
        if (upperName.endsWith(".ZIP")) {
            log.info("-----zip:unZip-----");
            return ZipSizeUtils.unZip(compressFile);
        }
        if (upperName.endsWith(".TAR")) {
            log.info("-----tar:unTar-----");
            return ZipSizeUtils.unTar(compressFile);
        }
        if (upperName.endsWith(".TAR.BZ2")) {
            log.info("-----tar.bz2:unTarBZip2-----");
            return ZipSizeUtils.unTarBZip2(compressFile);
        }
        if (upperName.endsWith(".TAR.GZ")) {
            log.info("-----tar.gz:unTarGZ-----");
            return ZipSizeUtils.unTarGZ(compressFile);
        }
        if (upperName.endsWith(".TGZ")) {
            log.info("-----unTarGZ-----");
            return ZipSizeUtils.unTarGZ(compressFile);
        }
        if (upperName.endsWith(".TAR.Z")) {
            log.info("-----unTarGZ-----");
            return ZipSizeUtils.unTarGZ(compressFile);
        }
        if (upperName.endsWith(".BZ2")) {
            log.info("-----unBZip2-----");
            return ZipSizeUtils.unBZip2(compressFile, destDir);
        }
        if (upperName.endsWith(".GZ")) {
            log.info("-----unGZ-----");
            return ZipSizeUtils.unGZ(compressFile, destDir);
        }
        return 0L;
    }

    private static long unCompressSizeByCode(String compressFile, String fileCode) throws Exception {
        if (ZipSizeUtils.matchCompressType(fileCode, FILECODE_ZIP)) {
            return ZipSizeUtils.unZip(compressFile);
        }
        if (ZipSizeUtils.matchCompressType(fileCode, FILECODE_TARGZ)) {
            return ZipSizeUtils.unTarGZ(compressFile);
        }
        log.info("can not uncompress by code!");
        return 0L;
    }

    private ZipSizeUtils() {
    }
}

