/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.safe;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SensitiveInfoFilter {
    private static final List<String> SENSITIVE_WORDS = Arrays.asList("55847747659", "password", "pwd", "token", "session", "59594908477", "59594908474", "sk", "cookie", "cmo_sms_service_centre", "accessSession");
    private static final String DESENSITIZATION_INFO = "******";

    public static String filter(String info) {
        if (StringUtils.isBlank((CharSequence)info)) {
            return info;
        }
        if (SENSITIVE_WORDS.stream().anyMatch(word -> info.toLowerCase(Locale.ROOT).contains((CharSequence)word))) {
            return DESENSITIZATION_INFO;
        }
        return info;
    }

    public static Map<String, String> filterMap(Map<String, String> map) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SensitiveInfoFilter.filterEntryValue(entry)));
    }

    private static String filterEntryValue(Map.Entry<String, String> entry) {
        if (StringUtils.isNotEmpty((CharSequence)entry.getKey()) && SENSITIVE_WORDS.stream().anyMatch(word -> ((String)entry.getKey()).toLowerCase(Locale.ROOT).contains((CharSequence)word))) {
            return DESENSITIZATION_INFO;
        }
        return entry.getValue();
    }
}

