/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.certificate.util;

import com.huawei.ism.tool.certbase.enums.TlsSecureProtocolVer;
import com.huawei.ism.tool.certbase.ssl.MySslX509TrustManager;
import com.huawei.migration.common.certificate.util.SSLConfigConstant;
import com.huawei.migration.common.exception.certificate.CertCheckRuntimeException;
import com.huawei.migration.common.exception.certificate.CertificateRuntimeException;
import com.huawei.migration.common.util.collection.CollectionConverter;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConnectionFactory.class);

    public static PoolingHttpClientConnectionManager buildTrustedConnectionManager(Set<X509Certificate> trustedCertificates, boolean checkHttpsServerSecurity) {
        log.info("build httpClientConnectionManager");
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(HttpClientConnectionFactory.getConnectionRegistry(trustedCertificates, checkHttpsServerSecurity));
        HttpClientConnectionFactory.initConnectionManagerConfig(connectionManager);
        return connectionManager;
    }

    public static PoolingHttpClientConnectionManager buildSafeTrustedConnectionManager(Set<X509Certificate> trustedCertificates, boolean checkHttpsServerSecurity) {
        log.info("build safestHttpClientConnectionManager");
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(HttpClientConnectionFactory.getSafestConnectionRegistry(trustedCertificates, checkHttpsServerSecurity));
        HttpClientConnectionFactory.initConnectionManagerConfig(connectionManager);
        return connectionManager;
    }

    private static void initConnectionManagerConfig(PoolingHttpClientConnectionManager connectionManager) {
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(20);
    }

    private static Registry<ConnectionSocketFactory> getConnectionRegistry(Set<X509Certificate> trustedCertificates, boolean checkHttpsServerSecurity) {
        return RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(HttpClientConnectionFactory.getSslContext(trustedCertificates, checkHttpsServerSecurity), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
    }

    private static Registry<ConnectionSocketFactory> getSafestConnectionRegistry(Set<X509Certificate> trustedCertificates, boolean checkHttpsServerSecurity) {
        return RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(HttpClientConnectionFactory.getSslContext(trustedCertificates, checkHttpsServerSecurity), SSLConfigConstant.getSupportProtocols(), SSLConfigConstant.getSupportedCipherSuites(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
    }

    private static SSLContext getSslContext(Set<X509Certificate> trustedCertificates, boolean checkHttpsServerSecurity) {
        if (checkHttpsServerSecurity) {
            return HttpClientConnectionFactory.getTrustedSslContext(trustedCertificates);
        }
        return HttpClientConnectionFactory.getDefaultTrustSslContext();
    }

    private static SSLContext getDefaultTrustSslContext() {
        try {
            TrustStrategy defaultTrustStrategy = (certificateChain, authType) -> true;
            return SSLContexts.custom().loadTrustMaterial(defaultTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CertificateRuntimeException("Load default sslContext error.", e);
        }
    }

    private static SSLContext getTrustedSslContext(Set<X509Certificate> trustedCertificates) {
        log.info("start to getMyTrustSSLFactory...");
        try {
            SSLContext sslContext = SSLContext.getInstance(TlsSecureProtocolVer.TLS_V1_D2.getTlsVersion());
            sslContext.init(null, HttpClientConnectionFactory.getSslCertificateTrustManager(trustedCertificates), null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new CertificateRuntimeException("get trustedSslContext error", e);
        }
    }

    private static TrustManager[] getSslCertificateTrustManager(Set<X509Certificate> trustedCertificates) {
        return HttpClientConnectionFactory.getTrustManagers(HttpClientConnectionFactory.getTrustedKeyStore(trustedCertificates));
    }

    private static TrustManager[] getTrustManagers(KeyStore keyStore) {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
            factory.init(keyStore);
            TrustManager[] trustManagers = HttpClientConnectionFactory.getWrappedTrustManagers(factory.getTrustManagers());
            if (trustManagers.length == 0) {
                throw new CertificateRuntimeException("no trust manager found");
            }
            return trustManagers;
        }
        catch (Exception e) {
            throw new CertificateRuntimeException("get trustManager error", e);
        }
    }

    private static TrustManager[] getWrappedTrustManagers(TrustManager[] trustManagers) {
        return (TrustManager[])CollectionConverter.convert(Arrays.stream(trustManagers), X509TrustManager.class).map(x$0 -> new ToolSslX509TrustManager((X509TrustManager)x$0)).toArray(X509TrustManager[]::new);
    }

    private static KeyStore getTrustedKeyStore(Set<X509Certificate> certificates) {
        try {
            KeyStore trustKeyStore = KeyStore.getInstance("JKS");
            trustKeyStore.load(null, null);
            int count = 1;
            for (Certificate certificate : certificates) {
                trustKeyStore.setCertificateEntry("TrustCert" + count++, certificate);
            }
            return trustKeyStore;
        }
        catch (Exception e) {
            throw new CertificateRuntimeException("get trustedKeyStore error", e);
        }
    }

    private HttpClientConnectionFactory() {
    }

    private static class ToolSslX509TrustManager
    extends MySslX509TrustManager {
        private ToolSslX509TrustManager(X509TrustManager wrappedTrustManager) {
            super(wrappedTrustManager);
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            try {
                super.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                throw new CertCheckRuntimeException(e.getMessage(), e, chain);
            }
        }
    }
}

