/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.certificate.util;

import com.huawei.migration.common.exception.certificate.GenerateCertException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.time.DateUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class MutualTrustCertKeyStoreFactory {
    public static final String KEY_STORE_TYPE = "PKCS12";
    static final String KEY_STORE_FILE_TYPE = ".p12";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String PROVIDER = "BC";
    private static final String KEY_PAIR_GEN_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 4096;
    private static final String ROOT_ALIAS = "root";
    private static final int VALID_DAYS_FROM_COMPATIBLE_WINDOW = -7;
    private int validPeriodYears = 3;
    private final String certNameFormat;
    private final List<String> certNames;
    private final Path certDir;
    private final Map<String, KeyStoreInfoGroup> certInfos = new HashMap<String, KeyStoreInfoGroup>();
    private KeyStoreInfoGroup rootInfo;
    private Date certValidFrom;
    private Date certValidTo;

    public void generate(char[] keyStorePwd) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.initCertValidDate();
        this.generateCerts();
        this.saveKeyStores(keyStorePwd);
    }

    private void initCertValidDate() {
        this.certValidFrom = DateUtils.addDays((Date)new Date(), (int)-7);
        this.certValidTo = DateUtils.addYears((Date)this.certValidFrom, (int)this.validPeriodYears);
    }

    private void generateCerts() {
        this.generateRootCert();
        this.certNames.forEach(certName -> this.certInfos.put((String)certName, this.generateCertByRoot((String)certName)));
    }

    private void generateRootCert() {
        X500Name rootName = new X500Name(String.format(Locale.ROOT, this.certNameFormat, ROOT_ALIAS));
        KeyPair rootKeyPair = this.createKeyPair();
        Certificate rootCert = this.generateCert(rootName, rootKeyPair.getPublic(), rootName, rootKeyPair.getPrivate());
        this.rootInfo = new KeyStoreInfoGroup(rootName, rootKeyPair, rootCert);
    }

    private KeyStoreInfoGroup generateCertByRoot(String certName) {
        X500Name subject = new X500Name(String.format(Locale.ROOT, this.certNameFormat, certName));
        KeyPair keyPair = this.createKeyPair();
        Certificate certificate = this.generateCert(subject, keyPair.getPublic(), this.rootInfo.subject, this.rootInfo.keyPair.getPrivate());
        return new KeyStoreInfoGroup(subject, keyPair, certificate);
    }

    private Certificate generateCert(X500Name subject, PublicKey publicKey, X500Name issuer, PrivateKey issuerPrivateKey) {
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuer, BigInteger.valueOf(new SecureRandom().nextLong()), this.certValidFrom, this.certValidTo, subject, publicKey);
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER).build(issuerPrivateKey);
            return new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new GenerateCertException("generate certificate error.", e);
        }
    }

    private KeyPair createKeyPair() {
        try {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance(KEY_PAIR_GEN_ALGORITHM, PROVIDER);
            kpGen.initialize(this.getKeySize(), new SecureRandom());
            return kpGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new GenerateCertException("generate keypair error.", e);
        }
    }

    int getKeySize() {
        return 4096;
    }

    private void saveKeyStores(char[] keyStorePwd) {
        this.certNames.forEach(certName -> this.saveKeyStore((String)certName, keyStorePwd));
    }

    private void saveKeyStore(String certName, char[] keyStorePwd) {
        try (OutputStream outputStream = Files.newOutputStream(this.certDir.resolve(certName + KEY_STORE_FILE_TYPE), new OpenOption[0]);){
            this.buildKeyStore(certName, keyStorePwd).store(outputStream, keyStorePwd);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new GenerateCertException("save keystore error.", e);
        }
    }

    private KeyStore buildKeyStore(String certName, char[] keyStorePwd) throws KeyStoreException {
        KeyStore keyStore = this.getEmptyKeyStore();
        this.setKeyEntry(certName, keyStorePwd, keyStore);
        this.setCertificateEntry(certName, keyStore);
        return keyStore;
    }

    private void setKeyEntry(String certName, char[] keyStorePwd, KeyStore keyStore) throws KeyStoreException {
        KeyStoreInfoGroup ketStoreInfo = Objects.requireNonNull(this.certInfos.get(certName));
        keyStore.setKeyEntry(certName, ketStoreInfo.keyPair.getPrivate(), keyStorePwd, new Certificate[]{ketStoreInfo.certificate});
    }

    private void setCertificateEntry(String currentCertName, KeyStore keyStore) throws KeyStoreException {
        keyStore.setCertificateEntry(ROOT_ALIAS, this.rootInfo.certificate);
        for (String certName : this.certNames) {
            if (currentCertName.equals(certName)) continue;
            keyStore.setCertificateEntry(certName, Objects.requireNonNull(this.certInfos.get(certName)).certificate);
        }
    }

    private KeyStore getEmptyKeyStore() {
        try {
            return MutualTrustCertKeyStoreFactory.loadKeyStoreByInputStream(null, null);
        }
        catch (IOException e) {
            throw new GenerateCertException("load empty keystore error.", e);
        }
    }

    public static KeyStore loadKeyStore(Path keyStoreFile, char[] password) throws IOException {
        try (InputStream inputStream = Files.newInputStream(keyStoreFile, new OpenOption[0]);){
            KeyStore keyStore = MutualTrustCertKeyStoreFactory.loadKeyStoreByInputStream(inputStream, password);
            return keyStore;
        }
    }

    private static KeyStore loadKeyStoreByInputStream(InputStream inputStream, char[] password) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            keyStore.load(inputStream, password);
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException("load key store error.", e);
        }
    }

    public MutualTrustCertKeyStoreFactory(String certNameFormat, List<String> certNames, Path certDir) {
        this.certNameFormat = certNameFormat;
        this.certNames = certNames;
        this.certDir = certDir;
    }

    public MutualTrustCertKeyStoreFactory validPeriodYears(int validPeriodYears) {
        this.validPeriodYears = validPeriodYears;
        return this;
    }

    private static class KeyStoreInfoGroup {
        private final X500Name subject;
        private final KeyPair keyPair;
        private final Certificate certificate;

        public KeyStoreInfoGroup(X500Name subject, KeyPair keyPair, Certificate certificate) {
            this.subject = subject;
            this.keyPair = keyPair;
            this.certificate = certificate;
        }
    }
}

