/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.certificate.util;

import com.huawei.ism.tool.certbase.utils.RevokedCertUtil;
import com.huawei.migration.common.exception.certificate.CertificateRuntimeException;
import com.huawei.migration.common.util.file.FileRenameUtil;
import com.huawei.migration.common.util.path.ToolPathUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CRLException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokedCertificateManager {
    private static final Logger log = LoggerFactory.getLogger(RevokedCertificateManager.class);

    public static void importRevokedCertFile(String crlFilePath, String crlDirPath, Collection<X509Certificate> trustedCertificates) {
        if (!RevokedCertificateManager.isCrl(crlFilePath)) {
            throw new CertificateRuntimeException("Not a crl file.");
        }
        try {
            RevokedCertUtil.addCrl((String)crlFilePath, trustedCertificates);
            RevokedCertificateManager.copyCrl(crlFilePath, crlDirPath);
        }
        catch (CRLException e) {
            throw new CertificateRuntimeException("Add crl error.", e);
        }
    }

    private static void copyCrl(String crlFilePath, String crlDirPath) {
        Path crlDir = Paths.get(crlDirPath, new String[0]);
        ToolPathUtil.makeDir(crlDir);
        Path sourceCrlFilePath = Paths.get(crlFilePath, new String[0]);
        Path copyCrlFilePath = FileRenameUtil.renameWhenDuplicate(crlDir, sourceCrlFilePath.getFileName().toString());
        try {
            Files.copy(sourceCrlFilePath, copyCrlFilePath, new CopyOption[0]);
        }
        catch (IOException e) {
            log.error("Copy crl file error.", (Throwable)e);
        }
    }

    public static void initRevokedCerts(String crlDirPath, Collection<X509Certificate> trustedCertificates) {
        RevokedCertUtil.getX509Crl().clear();
        try {
            RevokedCertUtil.addCrl((String)crlDirPath, trustedCertificates);
        }
        catch (CRLException e) {
            log.error("Load crl error.", (Throwable)e);
        }
    }

    public static boolean isCrl(String fileName) {
        return FilenameUtils.getExtension((String)fileName).equalsIgnoreCase("crl");
    }

    private RevokedCertificateManager() {
    }
}

