/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.certificate.util;

import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.migration.common.certificate.bean.LocalX509Certificate;
import com.huawei.migration.common.util.date.DateTimeUtil;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import java.awt.Window;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SslCertExpireChecker {
    private static final int ABOUT_TO_EXPIRED_DAYS = 30;
    private final Window parentWindow;
    private final Collection<LocalX509Certificate> localCertificates;
    private final LocalDateTime aboutExpiredCheckTime;
    private final LocalDateTime currentTime;

    public SslCertExpireChecker(Window parentWindow, Collection<LocalX509Certificate> localCertificates) {
        this.parentWindow = parentWindow;
        this.localCertificates = localCertificates;
        this.currentTime = this.getCurrentDateTime();
        this.aboutExpiredCheckTime = this.currentTime.plusDays(30L);
    }

    public void checkCertificates() {
        String aboutExpiredCertFileNames;
        String message = "";
        String expiredCertFileNames = this.getExpiredCertFileNames();
        if (!expiredCertFileNames.isEmpty()) {
            message = message + PropertiesResourceUtil.getInnerMsg("migration.ssl.certificate.check.expired", expiredCertFileNames);
        }
        if (!(aboutExpiredCertFileNames = this.getAboutExpiredCertFileNames()).isEmpty()) {
            message = message + (message.isEmpty() ? "" : System.lineSeparator()) + PropertiesResourceUtil.getInnerMsg("migration.ssl.certificate.check.about.expired", aboutExpiredCertFileNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.showCertExpiredMessage(message);
        }
    }

    void showCertExpiredMessage(String message) {
        DialogUtils.showInfoDialog((Window)this.parentWindow, (String)message);
    }

    private String getExpiredCertFileNames() {
        return this.getCertFileNamesByPredicate(this::isCertExpired);
    }

    private boolean isCertExpired(LocalX509Certificate localCertificate) {
        return this.getCertExpiredTime(localCertificate).compareTo(this.currentTime) <= 0;
    }

    private String getAboutExpiredCertFileNames() {
        return this.getCertFileNamesByPredicate(this::isCertAboutExpired);
    }

    private boolean isCertAboutExpired(LocalX509Certificate localCertificate) {
        LocalDateTime certExpiredTime = this.getCertExpiredTime(localCertificate);
        return certExpiredTime.compareTo(this.aboutExpiredCheckTime) <= 0 && certExpiredTime.compareTo(this.currentTime) > 0;
    }

    private String getCertFileNamesByPredicate(Predicate<LocalX509Certificate> expiredPredicate) {
        return this.localCertificates.stream().filter(expiredPredicate).map(LocalX509Certificate::getFilePath).map(filePath -> filePath.getFileName().toString()).distinct().collect(Collectors.joining(", "));
    }

    private LocalDateTime getCertExpiredTime(LocalX509Certificate localCertificate) {
        return DateTimeUtil.getLocalDateTime(localCertificate.getCertificate().getNotAfter());
    }

    LocalDateTime getCurrentDateTime() {
        return LocalDateTime.now();
    }
}

