/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.certificate.util;

import com.huawei.migration.common.certificate.bean.LocalX509Certificate;
import com.huawei.migration.common.util.collection.CollectionConverter;
import com.huawei.migration.common.util.path.ToolPathUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslCertificateParser {
    private static final Logger log = LoggerFactory.getLogger(SslCertificateParser.class);
    private static final List<String> CERTIFICATE_FILE_TYPES = Arrays.asList("pem", "cer", "crt", "der", "p7b");
    private static final LinkOption[] NO_FOLLOW_LINKS_OPTIONS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<LocalX509Certificate> loadTrustedCertificates(Path trustedCertDir) {
        try (Stream<Path> pathStream = Files.list(trustedCertDir);){
            Set<LocalX509Certificate> set = pathStream.map(SslCertificateParser::parseCertificatesByFile).flatMap(Collection::stream).collect(Collectors.toSet());
            return set;
        }
        catch (IOException exception) {
            log.error("List certificate file error", (Throwable)exception);
            return Collections.emptySet();
        }
    }

    public static X509Certificate[] getCertificateChain(List<LocalX509Certificate> localCertificates) {
        return (X509Certificate[])localCertificates.stream().map(LocalX509Certificate::getCertificate).toArray(X509Certificate[]::new);
    }

    public static String getSha1FingerPrint(X509Certificate certificate) {
        try {
            byte[] digest = MessageDigest.getInstance("SHA-1").digest(certificate.getEncoded());
            return DatatypeConverter.printHexBinary((byte[])digest).toLowerCase(Locale.ENGLISH);
        }
        catch (Exception e) {
            log.error("Get certificate SHA1 finger print error.", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LocalX509Certificate> parseCertificatesByFile(Path certificateFilePath) {
        if (!SslCertificateParser.isCertificateFile(certificateFilePath)) {
            return Collections.emptyList();
        }
        log.info("Load certificate file: {}", (Object)certificateFilePath.getFileName());
        try (FileInputStream certInputStream = new FileInputStream(certificateFilePath.toFile());){
            List<LocalX509Certificate> list = SslCertificateParser.parseCertificates(certInputStream, certificateFilePath);
            return list;
        }
        catch (IOException | CertificateException e) {
            log.error("Load certificate file error.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<LocalX509Certificate> parseCertificates(FileInputStream certInputStream, Path certificateFilePath) throws CertificateException {
        Collection<? extends Certificate> certificates = CertificateFactory.getInstance("X.509").generateCertificates(certInputStream);
        return CollectionConverter.convert(certificates, X509Certificate.class).map(certificate -> new LocalX509Certificate(certificateFilePath, (X509Certificate)certificate)).collect(Collectors.toList());
    }

    private static boolean isCertificateFile(Path filePath) {
        if (!Files.isRegularFile(filePath, NO_FOLLOW_LINKS_OPTIONS)) {
            return false;
        }
        return ToolPathUtil.checkFileExtension(CERTIFICATE_FILE_TYPES, filePath.toString());
    }

    public static List<String> getCertificateFileTypes() {
        return CERTIFICATE_FILE_TYPES;
    }

    private SslCertificateParser() {
    }
}

