/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.certificate.util;

import com.huawei.migration.common.certificate.bean.LocalX509Certificate;
import com.huawei.migration.common.util.thread.ThreadPoolFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SslCertificateWriter {
    private static final Logger log = LoggerFactory.getLogger(SslCertificateWriter.class);
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private static ExecutorService certFileExecutor = ThreadPoolFactory.newFixedThreadPool(2, "WriteCertToFile");

    static void writeCertificateTrusted(LocalX509Certificate localX509Certificate) {
        certFileExecutor.submit(() -> SslCertificateWriter.writeLocalCertificateToFile(localX509Certificate));
    }

    static void writeLocalCertificateToFile(LocalX509Certificate localX509Certificate) {
        try {
            SslCertificateWriter.writeCertificateEncodeInfo(SslCertificateWriter.getCertificateBase64EncodeInfo(localX509Certificate.getCertificate()), localX509Certificate.getFilePath().toFile());
        }
        catch (CertificateEncodingException e) {
            log.error("Get certificate encode info error.", (Throwable)e);
        }
    }

    private static String getCertificateBase64EncodeInfo(X509Certificate certificate) throws CertificateEncodingException {
        return new String(Base64.encodeBase64((byte[])certificate.getEncoded()));
    }

    private static void writeCertificateEncodeInfo(String certificateBase64EncodeInfo, File certificateFile) {
        try {
            FileUtils.writeLines((File)certificateFile, (String)StandardCharsets.UTF_8.name(), SslCertificateWriter.getCertificateEncodeInfoLines(certificateBase64EncodeInfo));
        }
        catch (IOException e) {
            log.error("Write certificate file error.", (Throwable)e);
        }
    }

    private static List<String> getCertificateEncodeInfoLines(String certificateBase64EncodeInfo) {
        int subLength;
        ArrayList<String> certEncodeInfoLines = new ArrayList<String>();
        certEncodeInfoLines.add(BEGIN_CERT);
        for (int subIndex = 0; certificateBase64EncodeInfo.length() > subIndex; subIndex += subLength) {
            subLength = Math.min(certificateBase64EncodeInfo.length() - subIndex, 64);
            certEncodeInfoLines.add(certificateBase64EncodeInfo.substring(subIndex, subIndex + subLength));
        }
        certEncodeInfoLines.add(END_CERT);
        return certEncodeInfoLines;
    }

    private SslCertificateWriter() {
    }
}

