/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.certificate.util;

import com.huawei.migration.common.certificate.bean.LocalX509Certificate;
import com.huawei.migration.common.certificate.util.SslCertificateWriter;
import com.huawei.migration.common.util.file.FileRenameUtil;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedCertificateManager {
    private static final Logger log = LoggerFactory.getLogger(TrustedCertificateManager.class);
    private static final boolean SAVE_TEMP_TRUST_CERTS_TO_FILE = Boolean.parseBoolean(PropertiesResourceUtil.getApplicationProperty("save.temp.trust.certs.to.file", "true"));
    private final Set<LocalX509Certificate> localTrustedCertificates = new HashSet<LocalX509Certificate>();

    public Set<X509Certificate> getTrustedCertificates() {
        return this.getLocalTrustedCertificates().stream().map(LocalX509Certificate::getCertificate).collect(Collectors.toSet());
    }

    public void initTrustedCertificates(Set<LocalX509Certificate> localTrustedCertificates) {
        this.getLocalTrustedCertificates().clear();
        this.getLocalTrustedCertificates().addAll(localTrustedCertificates);
    }

    public boolean importCertificate(Path certificateFilePath, Path trustedCertDir, List<LocalX509Certificate> localX509Certificates) {
        Path copyCertFilePath = FileRenameUtil.renameWhenDuplicate(trustedCertDir, certificateFilePath.getFileName().toString());
        if (this.copyCertificateFileToTrusted(certificateFilePath, copyCertFilePath)) {
            this.addCertificatesToTrusted(localX509Certificates, copyCertFilePath);
            return true;
        }
        return false;
    }

    private void addCertificatesToTrusted(List<LocalX509Certificate> localX509Certificates, Path copyCertFilePath) {
        localX509Certificates.stream().map(importCert -> new LocalX509Certificate(copyCertFilePath, importCert.getCertificate())).forEach(this::addCertificateToTrusted);
    }

    private boolean copyCertificateFileToTrusted(Path certificateFilePath, Path copyCertPath) {
        try {
            Files.copy(certificateFilePath, copyCertPath, new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            log.error("Copy certificate file error.", (Throwable)e);
            return false;
        }
    }

    public boolean removeTrustedCertificate(LocalX509Certificate localCertificate) {
        if (this.deleteCertFile(localCertificate)) {
            this.removeDuplicateCertificates(localCertificate);
            return true;
        }
        return false;
    }

    private boolean deleteCertFile(LocalX509Certificate localCertificate) {
        return this.getLocalTrustedCertificates().stream().filter(localCertificate::isSameCert).allMatch(this::deleteLocalCertFile);
    }

    private boolean deleteLocalCertFile(LocalX509Certificate localCertificate) {
        try {
            return !Files.exists(localCertificate.getFilePath(), new LinkOption[0]) || Files.deleteIfExists(localCertificate.getFilePath());
        }
        catch (IOException e) {
            log.error("Delete certificate file error.", (Throwable)e);
            return false;
        }
    }

    public boolean isCertificateImported(List<LocalX509Certificate> localX509Certificates) {
        Set<X509Certificate> trustedCertificates = this.getTrustedCertificates();
        return localX509Certificates.stream().map(LocalX509Certificate::getCertificate).anyMatch(trustedCertificates::contains);
    }

    public void makeCertificateChainTrusted(X509Certificate[] certificateChain, Path tempTrustCertSavePath) {
        if (certificateChain != null) {
            AtomicInteger index = new AtomicInteger(1);
            Arrays.asList(certificateChain).forEach(certificate -> this.makeCertificateTrusted((X509Certificate)certificate, tempTrustCertSavePath, index));
        }
    }

    private void makeCertificateTrusted(X509Certificate certificate, Path tempTrustCertDir, AtomicInteger index) {
        LocalX509Certificate localX509Certificate = new LocalX509Certificate(this.getTempCertFilePath(tempTrustCertDir, index), certificate);
        this.addCertificateToTrusted(localX509Certificate);
        if (SAVE_TEMP_TRUST_CERTS_TO_FILE) {
            SslCertificateWriter.writeCertificateTrusted(localX509Certificate);
            localX509Certificate.getFilePath().toFile().deleteOnExit();
        }
    }

    private Path getTempCertFilePath(Path tempTrustCertDir, AtomicInteger index) {
        if (!SAVE_TEMP_TRUST_CERTS_TO_FILE) {
            return tempTrustCertDir;
        }
        String tempCertFileName = "Temp_Cert_" + System.nanoTime() + index.getAndIncrement() + ".cer";
        return FileRenameUtil.renameWhenDuplicate(tempTrustCertDir, tempCertFileName);
    }

    private void addCertificateToTrusted(LocalX509Certificate localCertificate) {
        this.getLocalTrustedCertificates().add(localCertificate);
    }

    private void removeDuplicateCertificates(LocalX509Certificate localX509Certificate) {
        this.getLocalTrustedCertificates().removeIf(localX509Certificate::isSameCert);
    }

    public Set<LocalX509Certificate> getLocalTrustedCertificates() {
        return this.localTrustedCertificates;
    }
}

