/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.connection.https;

import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.migration.common.connection.https.HttpExecutor;
import com.huawei.migration.common.exception.https.HttpExecuteRuntimeException;
import com.huawei.migration.common.exception.https.HttpHandshakeRuntimeException;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import java.awt.Window;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;

public class HttpConnectionSecurityChecker {
    private final Window parentWindow;
    private final HttpExecutor httpExecutor;

    public Optional<CloseableHttpResponse> checkHttpResponse(ClassicHttpRequest httpRequest) {
        return this.checkHttpConnection(httpRequest, this.httpExecutor::getHttpResponse);
    }

    public Optional<String> checkHttpExecute(ClassicHttpRequest httpRequest) {
        return this.checkHttpConnection(httpRequest, this.httpExecutor::execute);
    }

    private <T> Optional<T> checkHttpConnection(ClassicHttpRequest httpRequest, Function<ClassicHttpRequest, T> httpExecuteFunction) {
        try {
            return Optional.of(httpExecuteFunction.apply(httpRequest));
        }
        catch (HttpHandshakeRuntimeException e) {
            return this.warnForContinueWhenHandshakeFail(httpRequest, httpExecuteFunction);
        }
    }

    private <T> Optional<T> warnForContinueWhenHandshakeFail(ClassicHttpRequest httpRequest, Function<ClassicHttpRequest, T> httpExecuteFunction) {
        if (this.isCheckHttpsServerSecurity() && this.isHandshakeFailWarnCancelled()) {
            return Optional.empty();
        }
        try {
            this.httpExecutor.addServerIpToWhiteList(httpRequest.getUri().getHost());
        }
        catch (URISyntaxException e) {
            throw new HttpExecuteRuntimeException("Failed to get host form uri.");
        }
        return Optional.of(httpExecuteFunction.apply(httpRequest));
    }

    boolean isCheckHttpsServerSecurity() {
        return this.httpExecutor.getTrustedHttpConnectionManager().isCheckHttpsServerSecurity();
    }

    boolean isHandshakeFailWarnCancelled() {
        return DialogUtils.showWarnConfirmDialog((Window)this.parentWindow, (String)PropertiesResourceUtil.getInnerMsg("migration.http.handshake.fail"), (String)PropertiesResourceUtil.getInnerMsg("migration.dialog.warn.box.msg")).getValue() != 0;
    }

    public HttpConnectionSecurityChecker(Window parentWindow, HttpExecutor httpExecutor) {
        this.parentWindow = parentWindow;
        this.httpExecutor = httpExecutor;
    }
}

