/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.connection.https;

import com.huawei.migration.common.certificate.util.TrustedCertificateManager;
import com.huawei.migration.common.connection.https.TrustedHttpConnectionManager;
import com.huawei.migration.common.exception.https.HttpExecuteRuntimeException;
import com.huawei.migration.common.exception.https.HttpHandshakeRuntimeException;
import com.huawei.migration.common.exception.https.HttpIoRuntimeException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExecutor {
    private static final Logger log = LoggerFactory.getLogger(HttpExecutor.class);
    private final Set<String> autoNegotiationHttpConnectionServerIps = new HashSet<String>(0);
    private final TrustedHttpConnectionManager trustedHttpConnectionManager = new TrustedHttpConnectionManager(new TrustedCertificateManager());

    public HttpExecutor(Path trustedCertDir, Path revokedCertDir) {
        this.trustedHttpConnectionManager.initCertificates(trustedCertDir, revokedCertDir);
    }

    /*
     * Exception decompiling
     */
    public String execute(ClassicHttpRequest httpRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseableHttpResponse getHttpResponse(ClassicHttpRequest httpRequest) {
        CloseableHttpResponse httpResponse = null;
        try (CloseableHttpClient httpClient = this.buildHttpClient(httpRequest.getUri().getHost());){
            httpResponse = this.httpExecute(httpRequest, httpClient);
            this.checkHttpStatusCode(httpResponse.getCode());
            CloseableHttpResponse closeableHttpResponse = httpResponse;
            return closeableHttpResponse;
        }
        catch (URISyntaxException | SSLHandshakeException e) {
            this.closeHttpResponseWhenHandshakeFail(httpResponse);
            throw new HttpHandshakeRuntimeException("Http handshake fail.", e);
        }
        catch (IOException e) {
            throw new HttpIoRuntimeException(e);
        }
    }

    CloseableHttpResponse httpExecute(ClassicHttpRequest httpRequest, CloseableHttpClient httpClient) throws IOException {
        return httpClient.execute(httpRequest);
    }

    private void closeHttpResponseWhenHandshakeFail(CloseableHttpResponse httpResponse) {
        if (httpResponse == null) {
            return;
        }
        try {
            httpResponse.close();
        }
        catch (IOException e) {
            log.error("Close http response error.", (Throwable)e);
        }
    }

    private void checkHttpStatusCode(int statusCode) {
        if (statusCode < 200 || statusCode >= 300) {
            throw new HttpExecuteRuntimeException("Error status code: " + statusCode);
        }
    }

    private CloseableHttpClient buildHttpClient(String serverIp) {
        return HttpClients.custom().setConnectionManager(this.getHttpClientConnectionManager(serverIp)).setConnectionManagerShared(true).build();
    }

    private HttpClientConnectionManager getHttpClientConnectionManager(String serverIp) {
        if (this.autoNegotiationHttpConnectionServerIps.contains(serverIp)) {
            return this.trustedHttpConnectionManager.getHttpClientConnectionManager();
        }
        return this.trustedHttpConnectionManager.getSafeHttpClientConnectionManager();
    }

    public void addServerIpToWhiteList(String serverIp) {
        this.autoNegotiationHttpConnectionServerIps.add(serverIp);
    }

    public TrustedHttpConnectionManager getTrustedHttpConnectionManager() {
        return this.trustedHttpConnectionManager;
    }
}

