/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.connection.https;

import com.huawei.migration.common.certificate.bean.LocalX509Certificate;
import com.huawei.migration.common.certificate.util.HttpClientConnectionFactory;
import com.huawei.migration.common.certificate.util.RevokedCertificateManager;
import com.huawei.migration.common.certificate.util.SslCertificateParser;
import com.huawei.migration.common.certificate.util.TrustedCertificateManager;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;

public class TrustedHttpConnectionManager {
    private final TrustedCertificateManager trustedCertificateManager;
    private boolean checkHttpsServerSecurity = Boolean.parseBoolean(PropertiesResourceUtil.getApplicationProperty("https.check.server.security", "true"));
    private PoolingHttpClientConnectionManager httpClientConnectionManager;
    private PoolingHttpClientConnectionManager safeHttpClientConnectionManager;

    public void initCertificates(Path trustedCertDir, Path revokedCertDir) {
        this.initTrustedCertificates(SslCertificateParser.loadTrustedCertificates(trustedCertDir));
        RevokedCertificateManager.initRevokedCerts(revokedCertDir.toString(), this.trustedCertificateManager.getTrustedCertificates());
    }

    public void initTrustedCertificates(Set<LocalX509Certificate> localTrustedCertificates) {
        this.getTrustedCertificateManager().initTrustedCertificates(localTrustedCertificates);
        this.destroyHttpClientConnectionManager();
    }

    public HttpClientConnectionManager getHttpClientConnectionManager() {
        this.httpClientConnectionManager = this.getHttpClientConnectionManager(this.httpClientConnectionManager, HttpClientConnectionFactory::buildTrustedConnectionManager, this.getTrustedCertificateManager().getTrustedCertificates());
        return this.httpClientConnectionManager;
    }

    public HttpClientConnectionManager getSafeHttpClientConnectionManager() {
        this.safeHttpClientConnectionManager = this.getHttpClientConnectionManager(this.safeHttpClientConnectionManager, HttpClientConnectionFactory::buildSafeTrustedConnectionManager, this.getTrustedCertificateManager().getTrustedCertificates());
        return this.safeHttpClientConnectionManager;
    }

    public boolean importCertificate(Path certificateFilePath, Path trustedCertDir, List<LocalX509Certificate> localX509Certificates) {
        if (this.getTrustedCertificateManager().importCertificate(certificateFilePath, trustedCertDir, localX509Certificates)) {
            this.destroyHttpClientConnectionManager();
            return true;
        }
        return false;
    }

    public void makeCertificateChainTrusted(X509Certificate[] certificateChain, Path tempTrustCertSavePath) {
        this.getTrustedCertificateManager().makeCertificateChainTrusted(certificateChain, tempTrustCertSavePath);
        this.destroyHttpClientConnectionManager();
    }

    public boolean removeTrustedCertificate(LocalX509Certificate localCertificate) {
        if (this.getTrustedCertificateManager().removeTrustedCertificate(localCertificate)) {
            this.destroyHttpClientConnectionManager();
            return true;
        }
        return false;
    }

    private void destroyHttpClientConnectionManager() {
        this.httpClientConnectionManager = null;
        this.safeHttpClientConnectionManager = null;
    }

    private PoolingHttpClientConnectionManager getHttpClientConnectionManager(PoolingHttpClientConnectionManager httpClientConnectionManager, BiFunction<Set<X509Certificate>, Boolean, PoolingHttpClientConnectionManager> initHttpClientManagerFunction, Set<X509Certificate> trustedCerts) {
        if (Objects.isNull(httpClientConnectionManager)) {
            return initHttpClientManagerFunction.apply(trustedCerts, this.isCheckHttpsServerSecurity());
        }
        return httpClientConnectionManager;
    }

    public void setCheckHttpsServerSecurity(boolean checkHttpsServerSecurity) {
        if (this.checkHttpsServerSecurity != checkHttpsServerSecurity) {
            this.checkHttpsServerSecurity = checkHttpsServerSecurity;
            this.destroyHttpClientConnectionManager();
        }
    }

    public TrustedHttpConnectionManager(TrustedCertificateManager trustedCertificateManager) {
        this.trustedCertificateManager = trustedCertificateManager;
    }

    public TrustedCertificateManager getTrustedCertificateManager() {
        return this.trustedCertificateManager;
    }

    public boolean isCheckHttpsServerSecurity() {
        return this.checkHttpsServerSecurity;
    }
}

