/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.ssh;

import com.huawei.ism.tool.obase.connection.SshConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SshAlgorithmChecker {
    private static final List<String> UNSAFE_KEX_ALGORITHMS = Arrays.asList("diffie-hellman-group14-sha1", "diffie-hellman-group-exchange-sha1", "ssh-rsa");
    private static final List<String> UNSAFE_CIPHER_ALGORITHMS = Arrays.asList("aes128-cbc", "3des-ctr", "3des-cbc", "blowfish-cbc", "aes192-cbc", "aes256-cbc");
    private static final List<String> UNSAFE_MAC_ALGORITHMS = Arrays.asList("hmac-md5", "hmac-sha1", "hmac-sha1-96", "hmac-md5-96");
    private final SshConnection sshConnection;

    boolean isSshConnUseUnsafeAlgorithm() {
        return this.isUseUnsafeKexAlgorithm() || this.isUseUnsafeCipherAlgorithm() || this.isUseUnsafeMacAlgorithm();
    }

    private boolean isUseUnsafeKexAlgorithm() {
        return this.isUseUnsafeAlgorithm("kex", UNSAFE_KEX_ALGORITHMS);
    }

    private boolean isUseUnsafeCipherAlgorithm() {
        return this.isUseUnsafeAlgorithm("cipher.s2c", UNSAFE_CIPHER_ALGORITHMS) || this.isUseUnsafeAlgorithm("cipher.c2s", UNSAFE_CIPHER_ALGORITHMS);
    }

    private boolean isUseUnsafeMacAlgorithm() {
        return this.isUseUnsafeAlgorithm("mac.s2c", UNSAFE_MAC_ALGORITHMS) || this.isUseUnsafeAlgorithm("mac.c2s", UNSAFE_MAC_ALGORITHMS);
    }

    private boolean isUseUnsafeAlgorithm(String algorithmType, List<String> unsafeAlgorithms) {
        return this.getConfigStream(algorithmType).anyMatch(unsafeAlgorithms::contains);
    }

    private Stream<String> getConfigStream(String configKey) {
        String config = StringUtils.defaultString((String)"");
        return Arrays.stream(config.toLowerCase(Locale.ENGLISH).split(","));
    }

    SshAlgorithmChecker(SshConnection sshConnection) {
        this.sshConnection = sshConnection;
    }
}

