/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.ssh;

import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionCreator;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.migration.common.exception.ssh.SshConnRuntimeException;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionFactory.class);
    static final boolean SSH_KNOWN_HOSTS_CHECK = Boolean.parseBoolean(PropertiesResourceUtil.getApplicationProperty("ssh.knownHosts.check", "true"));

    public static SshConnection createSshConnection(DevNode devNode, ISshJudge sshJudge) {
        try {
            return SshConnectionFactory.getSshConnectionCreator(devNode, sshJudge, true).create();
        }
        catch (ToolException e) {
            throw new SshConnRuntimeException(e.getErrorLocaleDescription(), e);
        }
    }

    public static SshConnection createTemporaryConnection(DevNode devNode) {
        try (SshConnection sshConnection = null;){
            SshConnection sshConnection2 = sshConnection = SshConnectionFactory.getSshConnectionCreator(devNode, null, false).create();
            return sshConnection2;
        }
    }

    private static SshConnectionCreator getSshConnectionCreator(DevNode devNode, ISshJudge sshJudge, boolean checkHostKey) {
        SshConnectionCreator creator = new SshConnectionCreator(devNode, sshJudge, false, false);
        if (!SSH_KNOWN_HOSTS_CHECK) {
            return creator;
        }
        if (checkHostKey) {
            creator.setStrictHostKeyChecking("yes");
            creator.setKnownHostsInfo(SshKnownHostsManager.getHostKeyInfo((String)devNode.getIp()));
        } else {
            creator.setStrictHostKeyChecking("ask");
        }
        return creator;
    }

    private SshConnectionFactory() {
    }
}

