/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.ssh;

import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorYesOrNoDialog;
import com.huawei.migration.common.exception.ssh.SshConnRuntimeException;
import com.huawei.migration.common.ssh.SshAlgorithmChecker;
import com.huawei.migration.common.ssh.SshConnectionFactory;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedSshConnectionChecker {
    private static final Logger log = LoggerFactory.getLogger(TrustedSshConnectionChecker.class);
    private final Window parentWindow;

    public boolean isDeviceSshTrusted(DevNode devNode) {
        return this.isTrusted(devNode) || this.shouldTrustTheSshConnection(devNode);
    }

    private boolean shouldTrustTheSshConnection(DevNode devNode) {
        SshConnection sshConnection = this.createTemporaryConnection(devNode);
        if (this.isTrustSshAskConfirmed(sshConnection)) {
            this.saveSshHostKey(sshConnection);
            return true;
        }
        return false;
    }

    private boolean isTrustSshAskConfirmed(SshConnection sshConnection) {
        String fingerprint = sshConnection.getFingerPrint();
        return this.isSshConnUseUnsafeAlgorithm(sshConnection) ? this.isWarnAskGetOkOption(PropertiesResourceUtil.getInnerMsg("migration.ssh.algorithm.unsafe.msg", fingerprint)) : this.isYesNoAskGetOkOption(PropertiesResourceUtil.getInnerMsg("migration.ssh.fingerprint.msg", fingerprint));
    }

    private boolean isSshConnUseUnsafeAlgorithm(SshConnection sshConnection) {
        return new SshAlgorithmChecker(sshConnection).isSshConnUseUnsafeAlgorithm();
    }

    public boolean isBatchDeviceSshTrusted(Collection<DevNode> devNodes) {
        if (this.isAllDevicesTrusted(devNodes)) {
            return true;
        }
        Map<String, SshConnection> deviceConnections = this.getDeviceConnections(devNodes);
        long connectFailCount = this.getConnectFailCount(deviceConnections);
        if (connectFailCount != 0L) {
            this.showConnectFaiDeviceInfo(this.getConnectFailDevices(deviceConnections));
        }
        if (connectFailCount == (long)devNodes.size()) {
            return false;
        }
        if (connectFailCount + this.getConnectTrustCount(devNodes) == (long)devNodes.size()) {
            return true;
        }
        if (this.isTrustDevicesAskConfirmed(this.getConnectionCheckData(deviceConnections))) {
            this.trustConnectedDevHostKey(deviceConnections);
            return true;
        }
        return false;
    }

    private long getConnectTrustCount(Collection<DevNode> devNodes) {
        return devNodes.stream().filter(this::isTrusted).count();
    }

    private long getConnectFailCount(Map<String, SshConnection> deviceConnections) {
        return deviceConnections.values().stream().filter(Objects::isNull).count();
    }

    private void trustConnectedDevHostKey(Map<String, SshConnection> deviceConnections) {
        deviceConnections.values().stream().filter(Objects::nonNull).forEach(this::saveSshHostKey);
    }

    private boolean isAllDevicesTrusted(Collection<DevNode> devNodes) {
        return devNodes.stream().allMatch(this::isTrusted);
    }

    boolean isTrustDevicesAskConfirmed(List<List<String>> connectionsCheckMsgs) {
        MultiErrorYesOrNoDialog multiWarningYesNoDialog = DialogUtils.createMultiWarningYesNoDialog((Window)this.parentWindow, (String)PropertiesResourceUtil.getInnerMsg("migration.ssh.batch.alert.msg"), (String[])this.getConnectFailMultiInfoHeaders(), connectionsCheckMsgs);
        multiWarningYesNoDialog.switchContinueToConfirm();
        multiWarningYesNoDialog.setVisible(true);
        return multiWarningYesNoDialog.getValue() == 0;
    }

    private String[] getConnectFailMultiInfoHeaders() {
        return new String[]{PropertiesResourceUtil.getInnerMsg("migration.dialog.multi.info.header.ip"), PropertiesResourceUtil.getInnerMsg("migration.dialog.multi.info.header.reason")};
    }

    private List<List<String>> getConnectionCheckData(Map<String, SshConnection> deviceConnections) {
        return deviceConnections.values().stream().filter(Objects::nonNull).map(this::getOneConnectionMsg).collect(Collectors.toList());
    }

    private List<String> getOneConnectionMsg(SshConnection sshConnection) {
        return Arrays.asList(sshConnection.getHost(), this.buildConnectionFailMessage(sshConnection));
    }

    private String buildConnectionFailMessage(SshConnection sshConnection) {
        if (this.isSshConnUseUnsafeAlgorithm(sshConnection)) {
            return PropertiesResourceUtil.getInnerMsg("migration.ssh.batch.fingerprint.algorithm.unsafe.msg", sshConnection.getFingerPrint());
        }
        return PropertiesResourceUtil.getInnerMsg("migration.ssh.batch.fingerprint.msg", sshConnection.getFingerPrint());
    }

    private String getConnectFailDevices(Map<String, SshConnection> deviceConnections) {
        return deviceConnections.entrySet().stream().filter(fingerprintEntry -> Objects.isNull(fingerprintEntry.getValue())).map(Map.Entry::getKey).collect(Collectors.joining(", "));
    }

    private Map<String, SshConnection> getDeviceConnections(Collection<DevNode> devNodes) {
        HashMap<String, SshConnection> deviceConnections = new HashMap<String, SshConnection>();
        devNodes.stream().filter(devNode -> !this.isTrusted((DevNode)devNode)).forEach(devNode -> {
            SshConnection cfr_ignored_0 = deviceConnections.put(devNode.getIp(), this.getDevSshConnection((DevNode)devNode).orElse(null));
        });
        return deviceConnections;
    }

    private Optional<SshConnection> getDevSshConnection(DevNode devNode) {
        try {
            return Optional.ofNullable(this.createTemporaryConnection(devNode));
        }
        catch (SshConnRuntimeException e) {
            log.error("Connect device by ssh error.", (Throwable)e);
            return Optional.empty();
        }
    }

    SshConnection createTemporaryConnection(DevNode devNode) {
        return SshConnectionFactory.createTemporaryConnection(devNode);
    }

    private boolean isTrusted(DevNode devNode) {
        return !SshConnectionFactory.SSH_KNOWN_HOSTS_CHECK || SshKnownHostsManager.isHostAdded((String)devNode.getIp());
    }

    void saveSshHostKey(SshConnection sshConnection) {
        SshKnownHostsManager.cacheHostKey((String)sshConnection.getHost(), (String)this.getHostKey(sshConnection));
    }

    private String getHostKey(SshConnection sshConnection) {
        int port = sshConnection.getPort();
        String hostName = port == 22 ? sshConnection.getHost() : '[' + sshConnection.getHost() + "]:" + port;
        return SshUtils.getKnownHostsInfo((ClientSession)sshConnection.getSession(), (String)hostName);
    }

    boolean isYesNoAskGetOkOption(String message) {
        return DialogUtils.showYesNoDialog((Window)this.parentWindow, (String)message).getValue() == 0;
    }

    boolean isWarnAskGetOkOption(String message) {
        return DialogUtils.showWarnConfirmDialog((Window)this.parentWindow, (String)message, (String)PropertiesResourceUtil.getInnerMsg("migration.dialog.warn.box.msg")).getValue() == 0;
    }

    void showConnectFaiDeviceInfo(String connectFailDevices) {
        DialogUtils.showInfoDialog((Window)this.parentWindow, (String)PropertiesResourceUtil.getInnerMsg("migration.ssh.batch.connect.fail.msg", connectFailDevices));
    }

    public TrustedSshConnectionChecker(Window parentWindow) {
        this.parentWindow = parentWindow;
    }
}

